/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.source;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.debug.internal.ui.display.JavaScriptDebugViewerConfiguration;

public class JavaScriptSourceViewer
extends SourceViewer
implements IPropertyChangeListener {
    private Font fFont;
    private Color fBackgroundColor;
    private Color fForegroundColor;
    private IPreferenceStore fStore;
    private JavaScriptDebugViewerConfiguration fConfiguration;

    public JavaScriptSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this(parent, ruler, null, false, styles | 0x2000000);
    }

    public JavaScriptSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean isOverviewRulerVisible, int styles) {
        super(parent, ruler, overviewRuler, isOverviewRulerVisible, styles | 0x2000000);
    }

    private void updateViewerFont() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            FontData data = null;
            data = store.contains("org.eclipse.jface.textfont") && !store.isDefault("org.eclipse.jface.textfont") ? PreferenceConverter.getFontData((IPreferenceStore)store, (String)"org.eclipse.jface.textfont") : PreferenceConverter.getDefaultFontData((IPreferenceStore)store, (String)"org.eclipse.jface.textfont");
            if (data != null) {
                Font font = new Font((Device)this.getTextWidget().getDisplay(), data);
                this.applyFont(font);
                if (this.getFont() != null) {
                    this.getFont().dispose();
                }
                this.setFont(font);
                return;
            }
        }
        this.applyFont(JFaceResources.getTextFont());
    }

    private void setFont(Font font) {
        this.fFont = font;
    }

    private Font getFont() {
        return this.fFont;
    }

    private void applyFont(Font font) {
        IDocument doc = this.getDocument();
        if (doc != null && doc.getLength() > 0) {
            Point selection = this.getSelectedRange();
            int topIndex = this.getTopIndex();
            StyledText styledText = this.getTextWidget();
            styledText.setRedraw(false);
            styledText.setFont(font);
            this.setSelectedRange(selection.x, selection.y);
            this.setTopIndex(topIndex);
            styledText.setRedraw(true);
        } else {
            this.getTextWidget().setFont(font);
        }
    }

    public void updateViewerColors() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            StyledText styledText = this.getTextWidget();
            Color color = store.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
            styledText.setForeground(color);
            if (this.getForegroundColor() != null) {
                this.getForegroundColor().dispose();
            }
            this.setForegroundColor(color);
            color = store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.getBackgroundColor() != null) {
                this.getBackgroundColor().dispose();
            }
            this.setBackgroundColor(color);
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    protected Color getBackgroundColor() {
        return this.fBackgroundColor;
    }

    protected void setBackgroundColor(Color backgroundColor) {
        this.fBackgroundColor = backgroundColor;
    }

    protected Color getForegroundColor() {
        return this.fForegroundColor;
    }

    protected void setForegroundColor(Color foregroundColor) {
        this.fForegroundColor = foregroundColor;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("org.eclipse.jface.textfont".equals(property)) {
            this.updateViewerFont();
        }
        if ("AbstractTextEditor.Color.Foreground".equals(property) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property)) {
            this.updateViewerColors();
        }
        if (this.fConfiguration != null && this.fConfiguration.affectsTextPresentation(event)) {
            this.fConfiguration.handlePropertyChangeEvent(event);
            this.invalidateTextPresentation();
        }
    }

    public IContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }

    public void dispose() {
        if (this.getFont() != null) {
            this.getFont().dispose();
            this.setFont(null);
        }
        if (this.getBackgroundColor() != null) {
            this.getBackgroundColor().dispose();
            this.setBackgroundColor(null);
        }
        if (this.getForegroundColor() != null) {
            this.getForegroundColor().dispose();
            this.setForegroundColor(null);
        }
        if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
    }

    public void configure(SourceViewerConfiguration configuration) {
        super.configure(configuration);
        if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        if (configuration instanceof JavaScriptDebugViewerConfiguration) {
            this.fConfiguration = (JavaScriptDebugViewerConfiguration)configuration;
            this.fStore = this.fConfiguration.getTextPreferenceStore();
            this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }
        this.updateViewerFont();
        this.updateViewerColors();
    }

    private IPreferenceStore getPreferenceStore() {
        return this.fStore;
    }
}

