/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.compare.HistoryItem;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaElementHistoryPageSource;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaStructureCreator;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;

abstract class JavaHistoryActionImpl {
    private boolean fModifiesFile;
    private ISelection fSelection;
    private JavaEditor fEditor;
    private String fTitle;
    private String fMessage;

    JavaHistoryActionImpl(boolean modifiesFile) {
        this.fModifiesFile = modifiesFile;
    }

    ISelection getSelection() {
        return this.fSelection;
    }

    final IFile getFile(Object input) {
        return JavaElementHistoryPageSource.getInstance().getFile(input);
    }

    final ITypedElement[] buildEditions(ITypedElement target, IFile file) {
        IFileState[] states = null;
        try {
            states = file.getHistory(null);
        }
        catch (CoreException ex) {
            JavaScriptPlugin.log(ex);
        }
        int count = 1;
        if (states != null) {
            count += states.length;
        }
        ITypedElement[] editions = new ITypedElement[count];
        editions[0] = new ResourceNode((IResource)file);
        if (states != null) {
            int i = 0;
            while (i < states.length) {
                editions[i + 1] = new HistoryItem(target, states[i]);
                ++i;
            }
        }
        return editions;
    }

    final Shell getShell() {
        if (this.fEditor != null) {
            return this.fEditor.getEditorSite().getShell();
        }
        return JavaScriptPlugin.getActiveWorkbenchShell();
    }

    final IJavaScriptElement getWorkingCopy(IJavaScriptElement input) {
        return input;
    }

    final ASTNode getBodyContainer(JavaScriptUnit root, IMember parent) throws JavaScriptModelException {
        ISourceRange sourceRange = parent.getNameRange();
        ASTNode parentNode = NodeFinder.perform((ASTNode)root, sourceRange);
        do {
            if (!(parentNode instanceof TypeDeclaration)) continue;
            return parentNode;
        } while ((parentNode = parentNode.getParent()) != null);
        return null;
    }

    final boolean beingEdited(IFile file) {
        FileEditorInput input;
        ICompilationUnitDocumentProvider dp = JavaScriptPlugin.getDefault().getCompilationUnitDocumentProvider();
        return dp.getDocument(input = new FileEditorInput(file)) != null;
    }

    final IMember getEditionElement(ISelection selection) {
        IMember m;
        Object o;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (o = ss.getFirstElement()) instanceof IMember && (m = (IMember)o).exists() && !m.isBinary() && JavaStructureCreator.hasEdition((IJavaScriptElement)m)) {
            return m;
        }
        return null;
    }

    final boolean isEnabled(IFile file) {
        if (file == null || !file.exists()) {
            return false;
        }
        if (this.fModifiesFile) {
            return true;
        }
        return true;
    }

    boolean isEnabled(ISelection selection) {
        IMember m = this.getEditionElement(selection);
        if (m == null) {
            return false;
        }
        IFile file = this.getFile(m);
        return this.isEnabled(file);
    }

    void applyChanges(ASTRewrite rewriter, IDocument document, final ITextFileBuffer textFileBuffer, Shell shell, boolean inEditor, Map options) throws CoreException, InvocationTargetException, InterruptedException {
        MultiTextEdit edit = new MultiTextEdit();
        try {
            TextEdit res = rewriter.rewriteAST(document, options);
            edit.addChildren(res.removeChildren());
        }
        catch (IllegalArgumentException e) {
            JavaScriptPlugin.log(e);
        }
        try {
            new RewriteSessionEditProcessor(document, (TextEdit)edit, 2).performEdits();
        }
        catch (BadLocationException e) {
            JavaScriptPlugin.log(e);
        }
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    textFileBuffer.commit(pm, false);
                }
                catch (CoreException ex) {
                    throw new InvocationTargetException(ex);
                }
            }
        };
        if (inEditor) {
            r.run((IProgressMonitor)new NullProgressMonitor());
        } else {
            PlatformUI.getWorkbench().getProgressService().run(true, false, r);
        }
    }

    static String trimTextBlock(String content, String delimiter, IJavaScriptProject currentProject) {
        String[] lines;
        if (content != null && (lines = Strings.convertIntoLines(content)) != null) {
            Strings.trimIndentation(lines, currentProject);
            return Strings.concatenate(lines, delimiter);
        }
        return null;
    }

    final JavaEditor getEditor(IFile file) {
        FileEditorInput fei = new FileEditorInput(file);
        IWorkbench workbench = JavaScriptPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    JavaEditor je;
                    IEditorPart ep = editors[z];
                    if (ep instanceof JavaEditor && fei.equals((Object)(je = (JavaEditor)ep).getEditorInput())) {
                        return (JavaEditor)ep;
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return null;
    }

    public abstract void run(ISelection var1);

    void init(JavaEditor editor, String title, String message) {
        this.fEditor = editor;
        this.fTitle = title;
        this.fMessage = message;
    }

    final JavaEditor getEditor() {
        return this.fEditor;
    }

    public final void runFromEditor(IAction uiProxy) {
        IJavaScriptElement element = null;
        try {
            element = SelectionConverter.getElementAtOffset(this.fEditor);
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        this.fSelection = element != null ? new StructuredSelection((Object)element) : StructuredSelection.EMPTY;
        boolean isEnabled = this.isEnabled(this.fSelection);
        uiProxy.setEnabled(isEnabled);
        if (!isEnabled) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.fTitle, (String)this.fMessage);
            return;
        }
        this.run(this.fSelection);
    }

    boolean checkEnabled() {
        IJavaScriptUnit unit = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
        IFile file = this.getFile(unit);
        return this.isEnabled(file);
    }

    public final void update(IAction uiProxy) {
        uiProxy.setEnabled(this.checkEnabled());
    }

    public final void selectionChanged(IAction uiProxy, ISelection selection) {
        this.fSelection = selection;
        uiProxy.setEnabled(this.isEnabled(selection));
    }

    public final void run(IAction action) {
        this.run(this.fSelection);
    }

    static JavaScriptUnit parsePartialCompilationUnit(IJavaScriptUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        try {
            ASTParser c = ASTParser.newParser((int)3);
            c.setSource(unit);
            c.setFocalPosition(0);
            c.setResolveBindings(false);
            c.setWorkingCopyOwner(null);
            ASTNode result = c.createAST(null);
            return (JavaScriptUnit)result;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException();
        }
    }
}

