/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.keyword.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.wst.jsdt.internal.ui.text.keyword.contentassist.KeywordProposal;
import org.eclipse.wst.jsdt.internal.ui.text.keyword.contentassist.KeywordUtilities;

public class KeywordEngine {
    private CompilationUnitContextType fContextType;
    private ArrayList<KeywordProposal> fProposals = new ArrayList();

    public KeywordEngine(CompilationUnitContextType contextType) {
        Assert.isNotNull((Object)((Object)contextType));
        this.fContextType = contextType;
    }

    public void complete(ITextViewer viewer, int completionPosition, IJavaScriptUnit compilationUnit) {
        this.reset();
        IDocument document = viewer.getDocument();
        Point selection = viewer.getSelectedRange();
        Position position = new Position(completionPosition, selection.y);
        CompilationUnitContext context = this.fContextType.createContext(document, position, compilationUnit);
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        KeywordUtilities keywordUtil = KeywordUtilities.getInstance();
        List<String> matchingKeywords = keywordUtil.getMatchingKeywords(context.getKey());
        for (String keywordName : matchingKeywords) {
            KeywordProposal keywordProposal = new KeywordProposal(keywordName, (IRegion)region);
            this.fProposals.add(keywordProposal);
        }
    }

    public void reset() {
        this.fProposals.clear();
    }

    public KeywordProposal[] getResults() {
        return this.fProposals.toArray(new KeywordProposal[this.fProposals.size()]);
    }
}

