/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timechart;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;

public class TimeChartDecorationProvider {
    private final IFile fBookmarksFile;
    private final Set<Long> fBookmarksSet = new HashSet<Long>();
    private ITmfFilter fFilterFilter;
    private ITmfFilter fSearchFilter;

    public TimeChartDecorationProvider(IFile bookmarksFile) {
        this.fBookmarksFile = bookmarksFile;
        this.refreshBookmarks();
    }

    public IFile getBookmarksFile() {
        return this.fBookmarksFile;
    }

    public boolean isBookmark(long rank) {
        return this.fBookmarksSet.contains(rank);
    }

    public void refreshBookmarks() {
        try {
            this.fBookmarksSet.clear();
            if (this.fBookmarksFile == null) {
                return;
            }
            IMarker[] iMarkerArray = this.fBookmarksFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker bookmark = iMarkerArray[n2];
                long rank = bookmark.getAttribute("location", -1);
                if (rank == -1L) {
                    String rankString = bookmark.getAttribute("rank", null);
                    try {
                        rank = Long.parseLong(rankString);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (rank != -1L) {
                    this.fBookmarksSet.add(rank);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error refreshing bookmarks", e);
        }
    }

    public void filterApplied(ITmfFilter filter) {
        this.fFilterFilter = filter;
    }

    public boolean isVisible(ITmfEvent event) {
        if (this.fFilterFilter != null) {
            return this.fFilterFilter.matches(event);
        }
        return true;
    }

    public void searchApplied(ITmfFilter filter) {
        this.fSearchFilter = filter;
    }

    public boolean isSearchMatch(ITmfEvent event) {
        if (this.fSearchFilter != null) {
            return this.fSearchFilter.matches(event);
        }
        return false;
    }
}

