/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.ui.views.stacktable;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxPidAspect;
import org.eclipse.tracecompass.incubator.callstack.core.flamechart.IEventCallStackProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.signal.TmfEventSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderUtils;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;

public class CallStackTableView
extends TmfView {
    public static final String ID = "org.eclipse.tracecompass.incubator.internal.callstack.ui.views.stacktable";
    private static final IProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();
    private @Nullable TreeViewer fTreeViewer;
    private final Multimap<ITmfTrace, ISymbolProvider> fSymbolProviders = HashMultimap.create();

    public CallStackTableView() {
        super("Call Stack Table");
    }

    public void createPartControl(@Nullable Composite parent) {
        TreeViewer treeViewer;
        super.createPartControl(parent);
        SashForm sf = new SashForm(parent, 0);
        this.fTreeViewer = treeViewer = new TreeViewer((Composite)sf, 65792);
        treeViewer.setAutoExpandLevel(-1);
        Tree tree = treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeViewerColumn column = new TreeViewerColumn(treeViewer, 16384);
        column.getColumn().setText("CallSite");
        column.getColumn().setWidth(50);
        treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
    }

    public void setFocus() {
    }

    @TmfSignalHandler
    public void eventSelected(TmfEventSelectedSignal signal) {
        Collection symbolProviders;
        ITmfTrace trace;
        ITmfEvent event = signal.getEvent();
        Iterable analysisModules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)event.getTrace(), IEventCallStackProvider.class);
        TreeViewer treeViewer = this.fTreeViewer;
        if (treeViewer == null) {
            return;
        }
        if (!analysisModules.iterator().hasNext()) {
            treeViewer.setInput(null);
        }
        if ((trace = TmfTraceManager.getInstance().getActiveTrace()) == null) {
            trace = event.getTrace();
        }
        if ((symbolProviders = this.fSymbolProviders.get((Object)trace)).isEmpty()) {
            symbolProviders = SymbolProviderManager.getInstance().getSymbolProviders(trace);
            symbolProviders.forEach(provider -> provider.loadConfiguration(NULL_PROGRESS_MONITOR));
            this.fSymbolProviders.putAll((Object)trace, (Iterable)symbolProviders);
        }
        HashMap<String, Collection<Object>> stacks = new HashMap<String, Collection<Object>>();
        for (IEventCallStackProvider provider2 : analysisModules) {
            Map stack = provider2.getCallStack(event);
            stacks.putAll(stack);
        }
        Integer pid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxPidAspect.class, (ITmfEvent)event);
        pid = pid == null ? -1 : pid;
        treeViewer.setInput(this.convertStack(stacks, symbolProviders, pid, event.getTimestamp().toNanos()));
    }

    private StackTableEntry createCallSiteEntry(StackTableStringEntry entry, Object callsite, Collection<ISymbolProvider> symbolProviders, Integer pid, long timestamp) {
        if (callsite instanceof Long) {
            String symbol = SymbolProviderUtils.getSymbolText(symbolProviders, (int)pid, (long)timestamp, (long)((Long)callsite));
            return new StackTableObjEntry(entry, symbol);
        }
        return new StackTableObjEntry(entry, callsite);
    }

    private Object convertStack(Map<String, Collection<Object>> stack, Collection<@NonNull ISymbolProvider> symbolProviders, Integer pid, long timestamp) {
        StackTableRootEntry rootEntry = new StackTableRootEntry();
        for (Map.Entry<String, Collection<Object>> entry : stack.entrySet()) {
            new StackTableStringEntry(rootEntry, entry.getKey(), entry.getValue(), symbolProviders, pid, timestamp);
        }
        return rootEntry;
    }

    private class StackTableEntry {
        private @Nullable StackTableEntry fParent;

        public StackTableEntry(StackTableEntry parent) {
            this.fParent = parent;
        }

        public StackTableEntry[] getChildren() {
            return new StackTableEntry[0];
        }

        public boolean hasChildren() {
            return this.getChildren().length != 0;
        }

        public @Nullable Object getParent() {
            return this.fParent;
        }
    }

    private class StackTableObjEntry
    extends StackTableEntry {
        private Object fCallsite;

        public StackTableObjEntry(StackTableStringEntry entry, Object callsite) {
            super(entry);
            this.fCallsite = callsite;
        }

        public String toString() {
            return String.valueOf(this.fCallsite);
        }
    }

    private class StackTableRootEntry
    extends StackTableEntry {
        List<StackTableEntry> fEntries;

        public StackTableRootEntry() {
            super(null);
            this.fEntries = new ArrayList<StackTableEntry>();
        }

        public void addEntry(StackTableEntry entry) {
            this.fEntries.add(entry);
        }

        @Override
        public StackTableEntry[] getChildren() {
            return this.fEntries.toArray(new StackTableEntry[this.fEntries.size()]);
        }
    }

    private class StackTableStringEntry
    extends StackTableEntry {
        private String fName;
        private List<StackTableEntry> fChildren;

        StackTableStringEntry(StackTableRootEntry entry, String name, Collection<Object> list, Collection<ISymbolProvider> symbolProviders, Integer pid, long timestamp) {
            super(entry);
            entry.addEntry(this);
            this.fName = name;
            this.fChildren = list.stream().map(l2 -> CallStackTableView.this.createCallSiteEntry(this, l2, symbolProviders, pid, timestamp)).collect(Collectors.toList());
        }

        @Override
        public StackTableEntry[] getChildren() {
            return this.fChildren.toArray(new StackTableEntry[this.fChildren.size()]);
        }

        public String toString() {
            return this.fName;
        }
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(@Nullable Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
        }

        public Object[] getElements(@Nullable Object inputElement) {
            if (inputElement instanceof StackTableEntry) {
                return ((StackTableEntry)inputElement).getChildren();
            }
            return new StackTableEntry[0];
        }

        public Object[] getChildren(@Nullable Object parentElement) {
            if (parentElement == null) {
                return new StackTableEntry[0];
            }
            StackTableEntry entry = (StackTableEntry)parentElement;
            return entry.getChildren();
        }

        public @Nullable Object getParent(@Nullable Object element) {
            if (element == null) {
                return null;
            }
            StackTableEntry entry = (StackTableEntry)element;
            return entry.getParent();
        }

        public boolean hasChildren(@Nullable Object element) {
            if (element == null) {
                return false;
            }
            StackTableEntry entry = (StackTableEntry)element;
            return entry.hasChildren();
        }
    }

    protected static class TreeLabelProvider
    implements ITableLabelProvider,
    ITableFontProvider,
    ITableColorProvider {
        protected TreeLabelProvider() {
        }

        public void addListener(@Nullable ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(@Nullable Object element, @Nullable String property) {
            return false;
        }

        public void removeListener(@Nullable ILabelProviderListener listener) {
        }

        public @Nullable Image getColumnImage(@Nullable Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(@Nullable Object element, int columnIndex) {
            return String.valueOf(element);
        }

        public Color getForeground(@Nullable Object element, int columnIndex) {
            return Display.getCurrent().getSystemColor(24);
        }

        public Color getBackground(@Nullable Object element, int columnIndex) {
            return Display.getCurrent().getSystemColor(25);
        }

        public @Nullable Font getFont(@Nullable Object element, int columnIndex) {
            return null;
        }
    }
}

