/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.Annotation;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.PeriodicAnnotationSource;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.tmf.core.markers.ITimeReference;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.ui.colors.RGBAUtil;
import org.eclipse.tracecompass.tmf.ui.model.StyleManager;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;

@NonNullByDefault
public class PeriodicMarkerEventSource
implements IMarkerEventSource {
    private final String fCategory;
    private final boolean fForeground;
    private final PeriodicAnnotationSource fSource;

    public PeriodicMarkerEventSource(String category, Reference reference, double period, long rollover, RGBA color, boolean foreground) {
        this(category, reference, period, rollover, foreground, color, null);
    }

    public PeriodicMarkerEventSource(String category, Reference reference, double period, long rollover, RGBA color1, RGBA color2, boolean foreground) {
        this(category, reference, period, rollover, foreground, color1, color2);
    }

    private PeriodicMarkerEventSource(String category, Reference reference, double period, long rollover, boolean foreground, RGBA color1, @Nullable RGBA color2) {
        if (period <= 0.0) {
            throw new IllegalArgumentException("period cannot be less than or equal to zero");
        }
        if (rollover < 0L) {
            throw new IllegalArgumentException("rollover cannot be less than zero");
        }
        this.fSource = new PeriodicAnnotationSource(category, reference.getIndex(), reference.getTime(), period, rollover, Objects.requireNonNull(PeriodicMarkerEventSource.wrap(color1)), PeriodicMarkerEventSource.wrap(color2));
        this.fCategory = category;
        this.fForeground = foreground;
    }

    private static @Nullable RGBAColor wrap(@Nullable RGBA rgba) {
        if (rgba == null) {
            return null;
        }
        return new RGBAColor(rgba.rgb.red, rgba.rgb.green, rgba.rgb.blue, rgba.alpha);
    }

    @Override
    public List<String> getMarkerCategories() {
        return Arrays.asList(this.fCategory);
    }

    @Override
    public List<IMarkerEvent> getMarkerList(String category, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        if (startTime > endTime) {
            return Collections.emptyList();
        }
        StyleManager sm = StyleManager.empty();
        ArrayList<IMarkerEvent> markers = new ArrayList<IMarkerEvent>();
        if (resolution >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot query " + resolution + " times");
        }
        List times = StateSystemUtils.getTimes((long)startTime, (long)endTime, (long)resolution);
        HashMap<String, Collection<Object>> query = new HashMap<String, Collection<Object>>();
        query.put("requested_times", times);
        query.put("requested_marker_categories", Collections.singleton(category));
        TmfModelResponse annotations = this.fSource.fetchAnnotations(query, monitor);
        AnnotationModel model = (AnnotationModel)annotations.getModel();
        if (model == null) {
            return markers;
        }
        Map annotationsMap = model.getAnnotations();
        Collection collection = (Collection)annotationsMap.get(category);
        if (collection != null) {
            for (Annotation annotation : collection) {
                String indexStr;
                long index;
                OutputElementStyle style = annotation.getStyle();
                if (style == null || !this.isApplicable(index = Long.parseLong(indexStr = annotation.getLabel()))) continue;
                String label = this.getMarkerLabel(index);
                annotation = new Annotation(annotation.getTime(), annotation.getDuration(), annotation.getEntryId(), label, style);
                RGBAColor rgbaColor = sm.getColorStyle(style, "color");
                if (rgbaColor == null) continue;
                RGBA color = RGBAUtil.fromRGBAColor(rgbaColor);
                MarkerEvent marker = new MarkerEvent(null, annotation.getTime(), annotation.getDuration(), category, color, label, this.fForeground);
                markers.add(marker);
            }
        }
        return markers;
    }

    public String getMarkerLabel(long index) {
        return (String)NonNullUtils.checkNotNull((Object)Long.toString(index));
    }

    public boolean isApplicable(long index) {
        return true;
    }

    public static class Reference
    implements ITimeReference {
        public static final Reference ZERO = new Reference(0L, 0);
        private final long time;
        private final long index;

        public Reference(long time, int index) {
            this.time = time;
            this.index = index;
        }

        public Reference(long time, long index) {
            this.time = time;
            this.index = index;
        }

        public long getTime() {
            return this.time;
        }

        public long getIndex() {
            return this.index;
        }

        public String toString() {
            return String.format("[%d, %d]", this.time, this.index);
        }
    }
}

