/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;

public abstract class AbstractJavaScriptBreakpointEditor {
    private ListenerList fListeners = new ListenerList();
    private boolean fDirty = false;
    private boolean fMnemonics = true;

    public void addPropertyListener(IPropertyListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void setMnemonics(boolean mnemonics) {
        this.fMnemonics = mnemonics;
    }

    protected boolean isMnemonics() {
        return this.fMnemonics;
    }

    protected String processMnemonics(String text) {
        if (this.isMnemonics()) {
            return text;
        }
        return LegacyActionTools.removeMnemonics((String)text);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public abstract Control createControl(Composite var1);

    protected void dispose() {
        this.fListeners.clear();
    }

    public abstract void setFocus();

    public abstract void doSave() throws CoreException;

    public abstract IStatus getStatus();

    public boolean isDirty() {
        return this.fDirty;
    }

    protected void setDirty(int propId) {
        this.fDirty = true;
        this.firePropertyChange(propId);
    }

    protected void setDirty(boolean dirty) {
        if (this.fDirty != dirty) {
            this.fDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    protected void firePropertyChange(int propId) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IPropertyListener listener = (IPropertyListener)listeners[i];
            listener.propertyChanged((Object)this, propId);
            ++i;
        }
    }

    public abstract Object getInput();

    public abstract void setInput(Object var1) throws CoreException;
}

