/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.application;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.WebApplication;

public class Application
implements IApplication {
    private static final String WORKSPACE_NAME = ".tracecompass-webapp";
    private WebApplication fWebAppl;
    private Location fInstanceLoc = null;

    public Object start(IApplicationContext context) throws Exception {
        this.fInstanceLoc = Platform.getInstanceLocation();
        if (!this.fInstanceLoc.allowsDefault() && !this.fInstanceLoc.isSet()) {
            File workspaceRoot = new File(Application.getWorkspaceRoot());
            if (!workspaceRoot.exists()) {
                return IApplication.EXIT_OK;
            }
            if (!workspaceRoot.canWrite()) {
                return IApplication.EXIT_OK;
            }
            String workspace = String.valueOf(Application.getWorkspaceRoot()) + File.separator + WORKSPACE_NAME;
            this.fInstanceLoc.set(new URL("file", null, workspace), false);
        }
        if (!this.fInstanceLoc.lock()) {
            return IApplication.EXIT_OK;
        }
        this.fWebAppl = new WebApplication();
        this.fWebAppl.start();
        return null;
    }

    public void stop() {
        this.fWebAppl.stop();
        this.fInstanceLoc.release();
    }

    private static String getWorkspaceRoot() {
        String workspaceRoot = System.getenv().get("TRACING_SERVER_ROOT");
        if (workspaceRoot == null) {
            workspaceRoot = System.getProperty("user.home");
        }
        return workspaceRoot;
    }
}

