/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class ChangeSessionStateHandler
extends BaseControlViewHandler {
    protected List<TraceSessionComponent> fSessions = new ArrayList<TraceSessionComponent>();

    public abstract TraceSessionState getNewState();

    public abstract void changeState(TraceSessionComponent var1, IProgressMonitor var2) throws ExecutionException;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        this.fLock.lock();
        try {
            final ArrayList<TraceSessionComponent> sessions = new ArrayList<TraceSessionComponent>();
            sessions.addAll(this.fSessions);
            Job job = new Job(Messages.TraceControl_ChangeSessionStateJob){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        for (TraceSessionComponent session : sessions) {
                            ChangeSessionStateHandler.this.changeState(session, monitor);
                            session.setSessionState(ChangeSessionStateHandler.this.getNewState());
                            session.fireComponentChanged(session);
                        }
                    }
                    catch (ExecutionException e) {
                        return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.TraceControl_ChangeSessionStateFailure, (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ArrayList<TraceSessionComponent> sessions = new ArrayList<TraceSessionComponent>(0);
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceSessionComponent session;
                if (!(element instanceof TraceSessionComponent) || (session = (TraceSessionComponent)element).getSessionState() == this.getNewState() || session.isDestroyed()) continue;
                sessions.add(session);
            }
        }
        boolean isEnabled = !sessions.isEmpty();
        this.fLock.lock();
        try {
            this.fSessions.clear();
            if (isEnabled) {
                this.fSessions = sessions;
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

