/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public class AddToFavoritesAction
extends SelectionListenerAction {
    private ILaunchConfiguration fConfiguration = null;
    private String fMode = null;
    private ILaunchGroup fGroup = null;

    public AddToFavoritesAction() {
        super("");
        this.setEnabled(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.Add_launch_configuration_to_favorites_action_context");
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        ILaunchConfiguration config;
        this.setLaunchConfiguration(null);
        this.setMode(null);
        this.setGroup(null);
        if (selection.size() == 1) {
            ILaunchConfiguration configuration;
            Object object = selection.getFirstElement();
            ILaunch launch = null;
            if (object instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)object;
                launch = (ILaunch)iAdaptable.getAdapter(ILaunch.class);
            }
            if (launch == null) {
                if (object instanceof ILaunch) {
                    ILaunch iLaunch;
                    launch = iLaunch = (ILaunch)object;
                } else if (object instanceof IDebugElement) {
                    IDebugElement iDebugElement = (IDebugElement)object;
                    launch = iDebugElement.getLaunch();
                } else if (object instanceof IProcess) {
                    IProcess iProcess = (IProcess)object;
                    launch = iProcess.getLaunch();
                }
            }
            if (launch != null && (configuration = launch.getLaunchConfiguration()) != null) {
                ILaunchGroup group = DebugUITools.getLaunchGroup(configuration, launch.getLaunchMode());
                if (group == null) {
                    return false;
                }
                this.setGroup(group);
                this.setLaunchConfiguration(configuration);
                this.setMode(launch.getLaunchMode());
                try {
                    List favoriteGroups = configuration.getAttribute("org.eclipse.debug.ui.favoriteGroups", new ArrayList());
                    if (favoriteGroups.contains(group.getIdentifier())) {
                        this.setText(MessageFormat.format(ActionMessages.RemoveFromFavoritesAction, this.fMode.substring(0, 1).toUpperCase() + this.fMode.substring(1)));
                    } else {
                        this.setText(MessageFormat.format(ActionMessages.AddToFavoritesAction_1, DebugUIPlugin.removeAccelerators(this.fMode.substring(0, 1).toUpperCase() + this.fMode.substring(1))));
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
        if ((config = this.getLaunchConfiguration()) == null) {
            return false;
        }
        return !DebugUITools.isPrivate(config);
    }

    protected void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.fConfiguration = configuration;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fConfiguration;
    }

    protected void setMode(String mode) {
        this.fMode = mode;
    }

    protected String getMode() {
        return this.fMode;
    }

    protected void setGroup(ILaunchGroup group) {
        this.fGroup = group;
    }

    protected ILaunchGroup getGroup() {
        return this.fGroup;
    }

    public void run() {
        CoreException[] ex = new CoreException[1];
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), () -> {
            try {
                String groupIdentifier;
                ArrayList<String> list = this.getLaunchConfiguration().getAttribute("org.eclipse.debug.ui.favoriteGroups", null);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                if (list.contains(groupIdentifier = this.getGroup().getIdentifier())) {
                    list.remove(groupIdentifier);
                } else {
                    list.add(groupIdentifier);
                }
                ILaunchConfigurationWorkingCopy copy = this.getLaunchConfiguration().getWorkingCopy();
                copy.setAttribute("org.eclipse.debug.ui.favoriteGroups", list);
                copy.doSave();
                this.setEnabled(false);
            }
            catch (CoreException e) {
                coreExceptionArray[0] = e;
            }
        });
        if (ex[0] != null) {
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), ActionMessages.AddToFavoritesAction_2, ActionMessages.AddToFavoritesAction_3, ex[0].getStatus());
        }
    }
}

