/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import org.eclipse.collections.api.set.primitive.ShortSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.ShortSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyShortIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import net.jcip.annotations.Immutable;

/**
 * ImmutableShortEmptySet is an optimization for {@link ImmutableShortSet} of size 0.
 * This file was automatically generated from template file immutablePrimitiveEmptySet.stg.
 *
 * @since 4.0.
 */
@Immutable
final class ImmutableShortEmptySet implements ImmutableShortSet, Serializable
{
    static final ImmutableShortSet INSTANCE = new ImmutableShortEmptySet();

    private static final long serialVersionUID = 1L;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public ImmutableShortSet newWith(short element)
    {
        return new ImmutableShortSingletonSet(element);
    }

    public ImmutableShortSet newWithout(short element)
    {
        return this;
    }

    public ImmutableShortSet newWithAll(ShortIterable elements)
    {
        return ShortSets.immutable.withAll(elements);
    }

    public ImmutableShortSet newWithoutAll(ShortIterable elements)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public boolean contains(short value)
    {
        return false;
    }

    public boolean containsAll(ShortIterable source)
    {
        return source.isEmpty();
    }

    public boolean containsAll(short... elements)
    {
        return elements.length == 0;
    }

    public void forEach(ShortProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(ShortProcedure procedure)
    {
    }

    public ImmutableShortSet select(ShortPredicate predicate)
    {
        return this;
    }

    public ImmutableShortSet reject(ShortPredicate predicate)
    {
        return this;
    }

    public <V> ImmutableSet<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return Sets.immutable.of();
    }

    public MutableShortList toList()
    {
        return new ShortArrayList();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return ifNone;
    }

    public int count(ShortPredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return false;
    }

    public long sum()
    {
        return 0L;
    }

    public short min()
    {
        throw new NoSuchElementException();
    }

    public short max()
    {
        throw new NoSuchElementException();
    }

    public short maxIfEmpty(short defaultValue)
    {
        return defaultValue;
    }

    public short minIfEmpty(short defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public short[] toSortedArray()
    {
        return new short[0];
    }

    public MutableShortList toSortedList()
    {
        return new ShortArrayList();
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return true;
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ShortSet))
        {
            return false;
        }
        ShortSet set = (ShortSet) obj;
        return set.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    public MutableShortSet toSet()
    {
        return new ShortHashSet();
    }

    public MutableShortBag toBag()
    {
        return new ShortHashBag();
    }

    public ShortSet freeze()
    {
        return this;
    }

    public ImmutableShortSet toImmutable()
    {
        return this;
    }

    public LazyShortIterable asLazy()
    {
        return new LazyShortIterableAdapter(this);
    }

    public short[] toArray()
    {
        return new short[0];
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public ShortIterator shortIterator()
    {
        return ImmutableEmptyShortIterator.INSTANCE;
    }
}
