/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.batch.eiq;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationType;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.State;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.StateMachine;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.deployment.BehaviorState;
import org.eclipse.viatra.examples.cps.deployment.BehaviorTransition;
import org.eclipse.viatra.examples.cps.deployment.Deployment;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.deployment.DeploymentFactory;
import org.eclipse.viatra.examples.cps.deployment.DeploymentHost;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.traceability.TraceabilityFactory;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.eiq.queries.CommunicatingAppInstancesMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.eiq.queries.Cps2DepTraces;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.eiq.queries.Cps2depTraceMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.eiq.queries.CpsApplicationTransitionMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.eiq.queries.CpsXformM2M;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.eiq.queries.DepTransitionMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.batch.eiq.queries.TriggerPairMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.util.NamingUtil;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.GenericQueryGroup;
import org.eclipse.viatra.query.runtime.api.IQueryGroup;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class CPS2DeploymentBatchTransformationEiq {
    @Extension
    protected Logger logger = Logger.getLogger((String)"cps.xform.m2m.batch.eiq");
    @Extension
    protected CpsXformM2M cpsXformM2M = CpsXformM2M.instance();
    @Extension
    protected Cps2DepTraces cpsTraces = Cps2DepTraces.instance();
    private DeploymentFactory depFactory = DeploymentFactory.eINSTANCE;
    private TraceabilityFactory tracFactory = TraceabilityFactory.eINSTANCE;
    private CPSToDeployment mapping;
    protected AdvancedViatraQueryEngine engine;
    protected QueryEvaluationHint hint;
    protected QueryEvaluationHint tracesHint;
    private Stopwatch clearModelPerformance;
    private Stopwatch hostTransformationPerformance;
    private Stopwatch appTransformationPerformance;
    private Stopwatch stateMachineTransformationPerformance;
    private Stopwatch stateTransformationPerformance;
    private Stopwatch transitionTransformationPerformance;
    private Stopwatch triggerTransformationPerformance;
    private Stopwatch otherTimer;
    private Table<State, DeploymentBehavior, BehaviorState> stateTable;
    private Map<Identifiable, CPS2DeploymentTrace> traceTable;

    public CPS2DeploymentBatchTransformationEiq(CPSToDeployment mapping, AdvancedViatraQueryEngine engine, QueryEvaluationHint hint, QueryEvaluationHint tracesHint) {
        boolean _notEquals;
        Preconditions.checkArgument((mapping != null ? 1 : 0) != 0, (Object)"Mapping cannot be null!");
        CyberPhysicalSystem _cps = mapping.getCps();
        boolean _tripleNotEquals = _cps != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"CPS not defined in mapping!");
        Deployment _deployment = mapping.getDeployment();
        boolean _tripleNotEquals_1 = _deployment != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Deployment not defined in mapping!");
        Preconditions.checkArgument((engine != null ? 1 : 0) != 0, (Object)"Engine cannot be null!");
        this.mapping = mapping;
        this.engine = engine;
        this.hint = hint;
        this.tracesHint = tracesHint;
        this.logger.debug((Object)"Preparing queries on engine.");
        Stopwatch watch = Stopwatch.createStarted();
        boolean bl = _notEquals = !Objects.equal((Object)hint, (Object)tracesHint);
        if (_notEquals) {
            engine.prepareGroup((IQueryGroup)this.cpsXformM2M, hint);
            engine.prepareGroup((IQueryGroup)this.cpsTraces, tracesHint);
        } else {
            engine.prepareGroup(GenericQueryGroup.of((IQueryGroup[])new IQueryGroup[]{this.cpsXformM2M, this.cpsTraces}), hint);
        }
        watch.stop();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Prepared queries on engine (");
        long _elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed);
        _builder.append(" ms)");
        this.logger.info((Object)_builder);
    }

    public void execute() {
        this.initPerformanceTimers();
        this.clearModelPerformance.start();
        this.clearModel();
        this.clearModelPerformance.stop();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing transformation on:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Cyber-physical system: ");
        String _identifier = this.mapping.getCps().getIdentifier();
        _builder.append(_identifier, "\t");
        this.logger.info((Object)_builder);
        this.stateTable = HashBasedTable.create();
        this.traceTable = Maps.newHashMap();
        this.logger.debug((Object)"Running host transformations.");
        Functions.Function1 _function = it -> it.getInstances();
        Consumer<HostInstance> _function_1 = it -> this.transform((HostInstance)it);
        Iterables.concat((Iterable)ListExtensions.map((List)this.mapping.getCps().getHostTypes(), (Functions.Function1)_function)).forEach(_function_1);
        this.logger.debug((Object)"Running action transformations.");
        this.transformActions();
        this.reportPerformance();
    }

    protected void transformActions() {
        Functions.Function1 _function = it -> it.getDepTransition();
        Consumer<BehaviorTransition> _function_1 = it -> this.mapAction((BehaviorTransition)it);
        IterableExtensions.map((Iterable)((DepTransitionMatcher)this.engine.getMatcher((IQuerySpecification)this.cpsXformM2M.getDepTransition(), this.hint)).getAllMatches(), (Functions.Function1)_function).forEach(_function_1);
    }

    private Stopwatch initPerformanceTimers() {
        Stopwatch _xblockexpression = null;
        this.clearModelPerformance = Stopwatch.createUnstarted();
        this.hostTransformationPerformance = Stopwatch.createUnstarted();
        this.appTransformationPerformance = Stopwatch.createUnstarted();
        this.stateMachineTransformationPerformance = Stopwatch.createUnstarted();
        this.stateTransformationPerformance = Stopwatch.createUnstarted();
        this.transitionTransformationPerformance = Stopwatch.createUnstarted();
        this.triggerTransformationPerformance = Stopwatch.createUnstarted();
        _xblockexpression = this.otherTimer = Stopwatch.createUnstarted();
        return _xblockexpression;
    }

    private void reportPerformance() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(">>>Cleared model in: ");
        long _elapsed = this.clearModelPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>Host transformation: ");
        long _elapsed_1 = this.hostTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_1);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>Application Instance transformation: ");
        long _elapsed_2 = this.appTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_2);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>State Machine transformation: ");
        long _elapsed_3 = this.stateMachineTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_3);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>State transformation: ");
        long _elapsed_4 = this.stateTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_4);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>Transition transformation: ");
        long _elapsed_5 = this.transitionTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_5);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>Trigger transformation: ");
        long _elapsed_6 = this.triggerTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_6);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>Other perf: ");
        long _elapsed_7 = this.otherTimer.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_7);
        _builder.append(" ms");
        this.logger.info((Object)_builder);
    }

    private DeploymentHost transform(HostInstance cpsHost) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: transform(cpsHost = ");
        String _name = NamingUtil.name((EObject)cpsHost);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        this.hostTransformationPerformance.start();
        DeploymentHost depHost = this.createDepHost(cpsHost);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Adding host (");
        String _description = depHost.getDescription();
        _builder_1.append(_description);
        _builder_1.append(") to deployment model.");
        this.logger.debug((Object)_builder_1);
        EList _hosts = this.mapping.getDeployment().getHosts();
        _hosts.add((Object)depHost);
        this.addTrace((Identifiable)cpsHost, (DeploymentElement)depHost);
        this.hostTransformationPerformance.stop();
        this.logger.debug((Object)"Running application instance transformations.");
        Functions.Function1 _function = it -> {
            ApplicationType _type = it.getType();
            CyberPhysicalSystem _cps = null;
            if (_type != null) {
                _cps = _type.getCps();
            }
            CyberPhysicalSystem _cps_1 = this.mapping.getCps();
            return Objects.equal((Object)_cps, (Object)_cps_1);
        };
        Consumer<ApplicationInstance> _function_1 = it -> this.transform((ApplicationInstance)it, depHost);
        IterableExtensions.filter((Iterable)cpsHost.getApplications(), (Functions.Function1)_function).forEach(_function_1);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("Running application instance transformations finished");
        this.logger.debug((Object)_builder_2);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("Execution ended: transform");
        this.logger.trace((Object)_builder_3);
        return depHost;
    }

    protected void transform(ApplicationInstance cpsInstance, DeploymentHost depHost) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: transform(cpsInstance = ");
        String _name = NamingUtil.name((EObject)cpsInstance);
        _builder.append(_name);
        _builder.append(", depHost = ");
        String _name_1 = NamingUtil.name((EObject)depHost);
        _builder.append(_name_1);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        this.appTransformationPerformance.start();
        DeploymentApplication depApp = this.createDepApplication(cpsInstance);
        EList _applications = depHost.getApplications();
        _applications.add((Object)depApp);
        this.addTrace((Identifiable)cpsInstance, (DeploymentElement)depApp);
        this.appTransformationPerformance.stop();
        this.logger.debug((Object)"Running state machine transformations.");
        Stopwatch watch = Stopwatch.createStarted();
        StateMachine _behavior = cpsInstance.getType().getBehavior();
        if (_behavior != null) {
            this.transform(_behavior, depApp);
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Running state machine transformations (");
        long _elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
        _builder_1.append((Object)_elapsed);
        _builder_1.append(" ms)");
        this.logger.debug((Object)_builder_1);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("Execution ended: transform");
        this.logger.trace((Object)_builder_2);
    }

    private void transform(StateMachine cpsBehavior, DeploymentApplication depApp) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: transform(cpsBehavior = ");
        String _name = NamingUtil.name((EObject)cpsBehavior);
        _builder.append(_name);
        _builder.append(", depApp = ");
        String _name_1 = NamingUtil.name((EObject)depApp);
        _builder.append(_name_1);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        this.stateMachineTransformationPerformance.start();
        DeploymentBehavior depBehavior = this.createDepBehavior(cpsBehavior);
        depApp.setBehavior(depBehavior);
        this.addTraceOneToN((Identifiable)cpsBehavior, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new DeploymentElement[]{depBehavior})));
        this.stateMachineTransformationPerformance.stop();
        this.logger.debug((Object)"Running state transformations.");
        Stopwatch watch = Stopwatch.createStarted();
        Consumer<State> _function = it -> this.transform((State)it, depBehavior);
        cpsBehavior.getStates().forEach(_function);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Running state transformations finished");
        this.logger.debug((Object)_builder_1);
        this.logger.debug((Object)"Resolving state relationships.");
        watch.reset().start();
        Consumer<State> _function_1 = it -> this.buildStateRelations((State)it, depBehavior, cpsBehavior);
        cpsBehavior.getStates().forEach(_function_1);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("Resolving state relationships finished");
        this.logger.debug((Object)_builder_2);
        this.logger.debug((Object)"Resolving initial state.");
        this.stateMachineTransformationPerformance.start();
        watch.reset().start();
        State _initial = cpsBehavior.getInitial();
        boolean bl = _tripleNotEquals = _initial != null;
        if (_tripleNotEquals) {
            Functions.Function1 _function_2 = it -> it.getDepElement();
            Functions.Function1 _function_3 = it -> depBehavior.getStates().contains(it);
            depBehavior.setCurrent((BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)IterableExtensions.map(((Cps2depTraceMatcher)this.engine.getMatcher((IQuerySpecification)this.cpsTraces.getCps2depTrace(), this.tracesHint)).getAllMatches(null, (Identifiable)cpsBehavior.getInitial(), null), (Functions.Function1)_function_2), BehaviorState.class), (Functions.Function1)_function_3));
        } else {
            depBehavior.setCurrent(null);
        }
        this.stateMachineTransformationPerformance.stop();
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("Resolving initial state finished");
        this.logger.debug((Object)_builder_3);
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("Execution ended: transform");
        this.logger.trace((Object)_builder_4);
    }

    private void transform(State cpsState, DeploymentBehavior depBehavior) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: transform(cpsState = ");
        String _name = NamingUtil.name((EObject)cpsState);
        _builder.append(_name);
        _builder.append(", depBehavior = ");
        String _name_1 = NamingUtil.name((EObject)depBehavior);
        _builder.append(_name_1);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        this.stateTransformationPerformance.start();
        BehaviorState depState = this.createDepState(cpsState);
        EList _states = depBehavior.getStates();
        _states.add((Object)depState);
        this.addTraceOneToN((Identifiable)cpsState, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new DeploymentElement[]{depState})));
        this.stateTable.put((Object)cpsState, (Object)depBehavior, (Object)depState);
        this.stateTransformationPerformance.stop();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: transform");
        this.logger.trace((Object)_builder_1);
    }

    private void buildStateRelations(State cpsState, DeploymentBehavior depBehavior, StateMachine cpsBehavior) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: buildStateRelations(cpsState = ");
        String _name = NamingUtil.name((EObject)cpsState);
        _builder.append(_name);
        _builder.append(", depBehavior = ");
        String _name_1 = NamingUtil.name((EObject)depBehavior);
        _builder.append(_name_1);
        _builder.append(", cpsBehavior = ");
        String _name_2 = NamingUtil.name((EObject)cpsBehavior);
        _builder.append(_name_2);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        this.transitionTransformationPerformance.start();
        BehaviorState depState = (BehaviorState)this.stateTable.get((Object)cpsState, (Object)depBehavior);
        Functions.Function1 _function = it -> it.getTargetState() != null && cpsBehavior.getStates().contains((Object)it.getTargetState());
        Consumer<Transition> _function_1 = it -> this.mapTransition((Transition)it, depState, depBehavior);
        IterableExtensions.filter((Iterable)cpsState.getOutgoingTransitions(), (Functions.Function1)_function).forEach(_function_1);
        this.transitionTransformationPerformance.stop();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: buildStateRelations");
        this.logger.trace((Object)_builder_1);
    }

    private void mapTransition(Transition transition, BehaviorState depState, DeploymentBehavior depBehavior) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: mapTransition(transition = ");
        String _name = NamingUtil.name((EObject)transition);
        _builder.append(_name);
        _builder.append(", depState = ");
        String _name_1 = NamingUtil.name((EObject)depState);
        _builder.append(_name_1);
        _builder.append(", depBehavior = ");
        String _name_2 = NamingUtil.name((EObject)depBehavior);
        _builder.append(_name_2);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        BehaviorTransition depTransition = this.createDepTransition(transition);
        EList _outgoing = depState.getOutgoing();
        _outgoing.add((Object)depTransition);
        EList _transitions = depBehavior.getTransitions();
        _transitions.add((Object)depTransition);
        this.otherTimer.start();
        this.addTraceOneToN((Identifiable)transition, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new DeploymentElement[]{depTransition})));
        this.otherTimer.stop();
        Functions.Function1 _function = it -> it.getDepElement();
        Functions.Function1 _function_1 = it -> depBehavior.getStates().contains(it);
        depTransition.setTo((BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)IterableExtensions.map(((Cps2depTraceMatcher)this.engine.getMatcher((IQuerySpecification)this.cpsTraces.getCps2depTrace(), this.tracesHint)).getAllMatches(null, (Identifiable)transition.getTargetState(), null), (Functions.Function1)_function), BehaviorState.class), (Functions.Function1)_function_1));
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: mapTransition");
        this.logger.trace((Object)_builder_1);
    }

    private void mapAction(BehaviorTransition depSendTransition) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: mapAction(depTrigger = ");
        String _name = NamingUtil.name((EObject)depSendTransition);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        this.triggerTransformationPerformance.start();
        Identifiable _head = (Identifiable)IterableExtensions.head(((Cps2depTraceMatcher)this.engine.getMatcher((IQuerySpecification)this.cpsTraces.getCps2depTrace(), this.tracesHint)).getAllValuesOfcpsElement(null, (DeploymentElement)depSendTransition));
        Transition cpsSendTransition = (Transition)_head;
        Iterable<Transition> cpsWaitTransitions = this.getWaitTransitionsForSendTransition(cpsSendTransition);
        boolean _isEmpty = IterableExtensions.isEmpty(cpsWaitTransitions);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EObject _eContainer = depSendTransition.eContainer().eContainer();
            DeploymentApplication senderDepApp = (DeploymentApplication)_eContainer;
            Identifiable _head_1 = (Identifiable)IterableExtensions.head(((Cps2depTraceMatcher)this.engine.getMatcher((IQuerySpecification)this.cpsTraces.getCps2depTrace(), this.tracesHint)).getAllValuesOfcpsElement(null, (DeploymentElement)senderDepApp));
            ApplicationInstance cpsSendAppInstance = (ApplicationInstance)_head_1;
            Consumer<Transition> _function = cpsWaitTransition -> {
                Set<ApplicationInstance> cpsWaitAppInstances = ((CpsApplicationTransitionMatcher)this.engine.getMatcher((IQuerySpecification)this.cpsXformM2M.getCpsApplicationTransition(), this.hint)).getAllValuesOfcpsApp((Transition)cpsWaitTransition);
                Functions.Function1 _function_1 = it -> {
                    boolean hasMatch = ((CommunicatingAppInstancesMatcher)this.engine.getMatcher((IQuerySpecification)this.cpsXformM2M.getCommunicatingAppInstances(), this.hint)).hasMatch(cpsSendAppInstance, (ApplicationInstance)it);
                    return hasMatch;
                };
                Iterable communicatingWaitAppInstances = IterableExtensions.filter(cpsWaitAppInstances, (Functions.Function1)_function_1);
                Consumer<ApplicationInstance> _function_2 = cpsWaitAppInstance -> {
                    CPS2DeploymentTrace waitTransitionTrace = (CPS2DeploymentTrace)IterableExtensions.head((Iterable)Iterables.filter(((Cps2depTraceMatcher)this.engine.getMatcher((IQuerySpecification)this.cpsTraces.getCps2depTrace(), this.tracesHint)).getAllValuesOftrace((Identifiable)cpsWaitTransition, null), CPS2DeploymentTrace.class));
                    CPS2DeploymentTrace waitAppInstanceTrace = (CPS2DeploymentTrace)IterableExtensions.head((Iterable)Iterables.filter(((Cps2depTraceMatcher)this.engine.getMatcher((IQuerySpecification)this.cpsTraces.getCps2depTrace(), this.tracesHint)).getAllValuesOftrace((Identifiable)cpsWaitAppInstance, null), CPS2DeploymentTrace.class));
                    DeploymentApplication depWaitApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter((Iterable)waitAppInstanceTrace.getDeploymentElements(), DeploymentApplication.class));
                    Functions.Function1 _function_3 = it -> {
                        EObject _eContainer_1 = it.eContainer().eContainer();
                        return Objects.equal((Object)depWaitApp, (Object)_eContainer_1);
                    };
                    BehaviorTransition depWaitTransition = (BehaviorTransition)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)waitTransitionTrace.getDeploymentElements(), BehaviorTransition.class), (Functions.Function1)_function_3);
                    EList _trigger = depSendTransition.getTrigger();
                    _trigger.add((Object)depWaitTransition);
                };
                communicatingWaitAppInstances.forEach(_function_2);
            };
            cpsWaitTransitions.forEach(_function);
        }
        this.triggerTransformationPerformance.stop();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: mapAction");
        this.logger.trace((Object)_builder_1);
    }

    protected Iterable<Transition> getWaitTransitionsForSendTransition(Transition cpsSendTransition) {
        return Iterables.filter(((TriggerPairMatcher)this.engine.getMatcher((IQuerySpecification)this.cpsXformM2M.getTriggerPair(), this.hint)).getAllValuesOfcpsTarget(cpsSendTransition), Transition.class);
    }

    private DeploymentHost createDepHost(HostInstance cpsHost) {
        DeploymentHost _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: createDepHost(cpsHost = ");
        String _name = NamingUtil.name((EObject)cpsHost);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        DeploymentHost depHost = this.depFactory.createDeploymentHost();
        depHost.setIp(cpsHost.getNodeIp());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: createDepHost");
        this.logger.trace((Object)_builder_1);
        _xblockexpression = depHost;
        return _xblockexpression;
    }

    private DeploymentApplication createDepApplication(ApplicationInstance cpsAppInstance) {
        DeploymentApplication _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: createDepApplication(cpsAppInstance = ");
        String _name = NamingUtil.name((EObject)cpsAppInstance);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        DeploymentApplication depApp = this.depFactory.createDeploymentApplication();
        depApp.setId(cpsAppInstance.getIdentifier());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution: createDepApplication");
        this.logger.trace((Object)_builder_1);
        _xblockexpression = depApp;
        return _xblockexpression;
    }

    private DeploymentBehavior createDepBehavior(StateMachine cpsBehavior) {
        DeploymentBehavior _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: createDepBehavior(cpsBehavior = ");
        String _name = NamingUtil.name((EObject)cpsBehavior);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        DeploymentBehavior depBehavior = this.depFactory.createDeploymentBehavior();
        depBehavior.setDescription(cpsBehavior.getIdentifier());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: createDepBehavior");
        this.logger.trace((Object)_builder_1);
        _xblockexpression = depBehavior;
        return _xblockexpression;
    }

    private BehaviorState createDepState(State cpsState) {
        BehaviorState _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: createDepState(cpsState = ");
        String _name = NamingUtil.name((EObject)cpsState);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        BehaviorState depState = this.depFactory.createBehaviorState();
        depState.setDescription(cpsState.getIdentifier());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: createDepState");
        this.logger.trace((Object)_builder_1);
        _xblockexpression = depState;
        return _xblockexpression;
    }

    private BehaviorTransition createDepTransition(Transition cpsTransition) {
        BehaviorTransition _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: createDepTransition(cpsTransition = ");
        String _name = NamingUtil.name((EObject)cpsTransition);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        BehaviorTransition depTransition = this.depFactory.createBehaviorTransition();
        depTransition.setDescription(cpsTransition.getIdentifier());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: createDepTransition");
        this.logger.trace((Object)_builder_1);
        _xblockexpression = depTransition;
        return _xblockexpression;
    }

    private void clearModel() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: clearModel()");
        this.logger.trace((Object)_builder);
        this.mapping.getTraces().clear();
        this.mapping.getDeployment().getHosts().clear();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: clearModel");
        this.logger.trace((Object)_builder_1);
    }

    private void addTraceOneToN(Identifiable cpsElement, List<? extends DeploymentElement> depElements) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: addTraceOneToN(cpsElement = ");
        String _name = NamingUtil.name((EObject)cpsElement);
        _builder.append(_name);
        _builder.append(", depElements = [");
        boolean _hasElements = false;
        for (DeploymentElement deploymentElement : depElements) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _name_1 = NamingUtil.name((EObject)deploymentElement);
            _builder.append(_name_1);
        }
        _builder.append("])");
        this.logger.trace((Object)_builder);
        CPS2DeploymentTrace trace = this.traceTable.get(cpsElement);
        if (trace == null) {
            trace = this.tracFactory.createCPS2DeploymentTrace();
            this.traceTable.put(cpsElement, trace);
            EList eList = trace.getCpsElements();
            eList.add((Object)cpsElement);
        }
        EList eList = trace.getDeploymentElements();
        Iterables.addAll((Collection)eList, depElements);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Adding trace (");
        String _name_2 = NamingUtil.name((EObject)cpsElement);
        _builder_1.append(_name_2);
        _builder_1.append("->[");
        boolean _hasElements_1 = false;
        for (DeploymentElement deploymentElement : depElements) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder_1.appendImmediate((Object)", ", "");
            }
            String _name_3 = NamingUtil.name((EObject)deploymentElement);
            _builder_1.append(_name_3);
        }
        _builder_1.append("]) to traceability model.");
        this.logger.debug((Object)_builder_1);
        EList _traces = this.mapping.getTraces();
        _traces.add((Object)trace);
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("Execution ended: addTraceOneToN");
        this.logger.trace((Object)stringConcatenation);
    }

    private void addTrace(Identifiable cpsElement, DeploymentElement depElement) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: addTrace(cpsElement = ");
        String _name = NamingUtil.name((EObject)cpsElement);
        _builder.append(_name);
        _builder.append(", depElement = ");
        String _name_1 = NamingUtil.name((EObject)depElement);
        _builder.append(_name_1);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        CPS2DeploymentTrace trace = this.tracFactory.createCPS2DeploymentTrace();
        EList _cpsElements = trace.getCpsElements();
        _cpsElements.add((Object)cpsElement);
        EList _deploymentElements = trace.getDeploymentElements();
        _deploymentElements.add((Object)depElement);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Adding trace (");
        String _name_2 = NamingUtil.name((EObject)cpsElement);
        _builder_1.append(_name_2);
        _builder_1.append("->");
        String _name_3 = NamingUtil.name((EObject)depElement);
        _builder_1.append(_name_3);
        _builder_1.append(") to traceability model.");
        this.logger.debug((Object)_builder_1);
        EList _traces = this.mapping.getTraces();
        _traces.add((Object)trace);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("Execution ended: addTrace");
        this.logger.trace((Object)_builder_2);
    }
}

