/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.State;
import org.eclipse.viatra.examples.cps.deployment.BehaviorState;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.queries.MappedStateMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.queries.MonitoredStateMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules.AbstractRule;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class StateUpdate
extends AbstractRule<MonitoredStateMatch> {
    public StateUpdate(ViatraQueryEngine engine) {
        super(engine);
    }

    @Override
    public RuleSpecification<MonitoredStateMatch> getSpecification() {
        Job<MonitoredStateMatch> _appearedJob = this.getAppearedJob();
        Job<MonitoredStateMatch> _disappearedJob = this.getDisappearedJob();
        Job<MonitoredStateMatch> _updatedJob = this.getUpdatedJob();
        return Rules.newMatcherRuleSpecification((IQuerySpecification)this.cpsXformM2M.getMonitoredState(), (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{_appearedJob, _disappearedJob, _updatedJob})));
    }

    private Job<MonitoredStateMatch> getAppearedJob() {
        IMatchProcessor _function = match -> {
            String stateId = match.getState().getIdentifier();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Starting monitoring mapped state with ID: ");
            _builder.append(stateId);
            this.logger.debug((Object)_builder);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function);
    }

    private Job<MonitoredStateMatch> getDisappearedJob() {
        IMatchProcessor _function = match -> {
            String stateId = match.getState().getIdentifier();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Stopped monitoring mapped state with ID: ");
            _builder.append(stateId);
            this.logger.debug((Object)_builder);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function);
    }

    private Job<MonitoredStateMatch> getUpdatedJob() {
        IMatchProcessor _function = match -> {
            State state = match.getState();
            String stateId = state.getIdentifier();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Updating mapped state with ID: ");
            _builder.append(stateId);
            this.logger.debug((Object)_builder);
            Collection<MappedStateMatch> depStateMatches = this.cpsXformM2M.getMappedState(this.engine).getAllMatches(state, null, null, null);
            Consumer<MappedStateMatch> _function_1 = it -> {
                State initState;
                boolean _equals;
                boolean _notEquals;
                String oldDesc = it.getDepState().getDescription();
                boolean bl = _notEquals = !Objects.equal((Object)oldDesc, (Object)stateId);
                if (_notEquals) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("ID changed to ");
                    _builder_1.append(stateId);
                    this.logger.trace((Object)_builder_1);
                    BehaviorState _depState = it.getDepState();
                    _depState.setDescription(stateId);
                }
                if (_equals = Objects.equal((Object)state, (Object)(initState = it.getStateMachine().getInitial()))) {
                    BehaviorState _depState_1;
                    boolean _notEquals_1;
                    BehaviorState currentState = it.getDepBehavior().getCurrent();
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)currentState, (Object)(_depState_1 = it.getDepState()));
                    if (_notEquals_1) {
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("Current state changed to ");
                        _builder_2.append(stateId);
                        this.logger.trace((Object)_builder_2);
                        DeploymentBehavior _depBehavior = it.getDepBehavior();
                        _depBehavior.setCurrent(it.getDepState());
                    }
                }
            };
            depStateMatches.forEach(_function_1);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Updated mapped state with ID: ");
            _builder_1.append(stateId);
            this.logger.debug((Object)_builder_1);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function);
    }
}

