/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.rewriters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IConstraintFilter;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IVariableRenamer;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PBodyCopier;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.VariableMappingExpressionEvaluatorWrapper;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

class FlattenerCopier
extends PBodyCopier {
    private final Map<PositivePatternCall, CallInformation> calls;

    public FlattenerCopier(PQuery query, Map<PositivePatternCall, PBody> callsToFlatten) {
        super(query);
        this.calls = callsToFlatten.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new CallInformation((PBody)entry.getValue())));
    }

    protected void copyVariable(PositivePatternCall contextPatternCall, PVariable variable, String newName) {
        PVariable newPVariable = this.body.getOrCreateVariableByName(newName);
        this.calls.get((Object)contextPatternCall).variableMapping.put(variable, newPVariable);
        this.variableMapping.put(variable, newPVariable);
    }

    public void mergeBody(PositivePatternCall contextPatternCall, IVariableRenamer namingTool, IConstraintFilter filter) {
        PBody sourceBody = this.calls.get((Object)contextPatternCall).body;
        Set<PVariable> allVariables = sourceBody.getAllVariables();
        for (PVariable pVariable : allVariables) {
            if (!pVariable.isUnique()) continue;
            this.copyVariable(contextPatternCall, pVariable, namingTool.createVariableName(pVariable, sourceBody.getPattern()));
        }
        Set<PConstraint> constraints = sourceBody.getConstraints();
        for (PConstraint pConstraint : constraints) {
            if (pConstraint instanceof ExportedParameter || filter.filter(pConstraint)) continue;
            this.copyConstraint(pConstraint);
        }
    }

    @Override
    protected void copyPositivePatternCallConstraint(PositivePatternCall positivePatternCall) {
        if (!this.calls.containsKey(positivePatternCall)) {
            super.copyPositivePatternCallConstraint(positivePatternCall);
        } else {
            PBody calledBody = Objects.requireNonNull(this.calls.get((Object)positivePatternCall).body);
            Preconditions.checkArgument(positivePatternCall.getReferredQuery().equals(calledBody.getPattern()));
            List<PVariable> symbolicParameters = calledBody.getSymbolicParameterVariables();
            Object[] elements = positivePatternCall.getVariablesTuple().getElements();
            int i = 0;
            while (i < elements.length) {
                this.createEqualityConstraint((PVariable)elements[i], symbolicParameters.get(i), positivePatternCall);
                ++i;
            }
        }
    }

    private void createEqualityConstraint(PVariable pVariable1, PVariable pVariable2, PositivePatternCall contextPatternCall) {
        PVariable who = (PVariable)this.variableMapping.get(pVariable1);
        PVariable withWhom = this.calls.get((Object)contextPatternCall).variableMapping.get(pVariable2);
        this.addTrace(contextPatternCall, new Equality(this.body, who, withWhom));
    }

    @Override
    protected void copyExpressionEvaluationConstraint(ExpressionEvaluation expressionEvaluation) {
        Map<PVariable, PVariable> variableMapping = this.variableMapping.entrySet().stream().filter(input -> expressionEvaluation.getPSystem().getAllVariables().contains(input.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        PVariable mappedOutputVariable = variableMapping.get(expressionEvaluation.getOutputVariable());
        this.addTrace(expressionEvaluation, new ExpressionEvaluation(this.body, new VariableMappingExpressionEvaluatorWrapper(expressionEvaluation.getEvaluator(), variableMapping), mappedOutputVariable));
    }

    private static class CallInformation {
        final PBody body;
        final Map<PVariable, PVariable> variableMapping;

        private CallInformation(PBody body) {
            this.body = body;
            this.variableMapping = new HashMap<PVariable, PVariable>();
        }
    }
}

