/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.resolver;

import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.evm.specific.resolver.FixedPriorityConflictResolver;
import org.eclipse.viatra.transformation.evm.specific.resolver.FixedPriorityConflictSet;

public class InvertedDisappearancePriorityConflictResolver
extends FixedPriorityConflictResolver {
    @Override
    protected FixedPriorityConflictSet createReconfigurableConflictSet() {
        return new InvertedDisappearancePriorityConflictSet(this, this.priorities);
    }

    public static class InvertedDisappearancePriorityConflictSet
    extends FixedPriorityConflictSet {
        public InvertedDisappearancePriorityConflictSet(FixedPriorityConflictResolver resolver, Map<RuleSpecification<?>, Integer> priorities) {
            super(resolver, priorities);
        }

        @Override
        protected Integer getRulePriority(Activation<?> activation) {
            if (CRUDActivationStateEnum.DELETED.equals(activation.getState())) {
                return -1 * super.getRulePriority(activation);
            }
            return super.getRulePriority(activation);
        }

        @Override
        public boolean addActivation(Activation<?> activation) {
            Preconditions.checkArgument((activation != null ? 1 : 0) != 0, (String)"Activation cannot be null!");
            Integer rulePriority = this.getRulePriority(activation);
            super.removeActivation(activation, -1 * rulePriority);
            return super.addActivation(activation);
        }

        @Override
        public boolean removeActivation(Activation<?> activation) {
            Preconditions.checkArgument((activation != null ? 1 : 0) != 0, (String)"Activation cannot be null!");
            Integer rulePriority = this.getRulePriority(activation);
            boolean removedFromInverted = super.removeActivation(activation, -1 * rulePriority);
            boolean removed = super.removeActivation(activation, rulePriority);
            return removed || removedFromInverted;
        }
    }
}

