/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.rete.network.CommunicationTracker;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.MessageKind;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;

public class DefaultMailbox
implements Mailbox {
    protected Map<Tuple, Integer> queue;
    protected Map<Tuple, Integer> buffer;
    protected final Receiver receiver;
    protected final ReteContainer container;
    protected boolean delivering;
    protected final CommunicationTracker tracker;
    protected boolean fallThrough = false;

    public DefaultMailbox() {
        this(null, null);
    }

    public DefaultMailbox(Receiver receiver, ReteContainer container) {
        this.receiver = receiver;
        this.container = container;
        this.tracker = container == null ? null : container.getTracker();
        this.queue = new LinkedHashMap<Tuple, Integer>();
        this.buffer = new LinkedHashMap<Tuple, Integer>();
    }

    protected Map<Tuple, Integer> getActiveQueue() {
        if (this.delivering) {
            return this.buffer;
        }
        return this.queue;
    }

    protected Integer get(Tuple key) {
        return this.getActiveQueue().get(key);
    }

    protected boolean isEmpty() {
        return this.getActiveQueue().isEmpty();
    }

    protected Set<Tuple> keySet() {
        return this.getActiveQueue().keySet();
    }

    @Override
    public void postMessage(Direction direction, Tuple update) {
        if (this.fallThrough) {
            this.receiver.update(direction, update);
        } else {
            Map<Tuple, Integer> activeQueue = this.getActiveQueue();
            Integer count = activeQueue.get(update);
            if (count == null) {
                count = 0;
            }
            if ((count = direction == Direction.REVOKE ? Integer.valueOf(count - 1) : Integer.valueOf(count + 1)) == 0) {
                activeQueue.remove(update);
            } else {
                activeQueue.put(update, count);
            }
            if (this.container != null) {
                if (activeQueue.isEmpty()) {
                    this.tracker.notifyLostAllMessages(this, MessageKind.DEFAULT);
                } else {
                    this.tracker.notifyHasMessage(this, MessageKind.DEFAULT);
                }
            }
        }
    }

    @Override
    public void deliverAll(MessageKind kind) {
        this.delivering = true;
        for (Map.Entry<Tuple, Integer> entry : this.queue.entrySet()) {
            Direction direction;
            int count = entry.getValue();
            if (count < 0) {
                direction = Direction.REVOKE;
                count = -count;
            } else {
                direction = Direction.INSERT;
            }
            int i = 0;
            while (i < count) {
                this.receiver.update(direction, entry.getKey());
                ++i;
            }
        }
        this.delivering = false;
        Map<Tuple, Integer> tmpQueue = this.queue;
        this.queue = this.buffer;
        this.buffer = tmpQueue;
        this.buffer = new LinkedHashMap<Tuple, Integer>();
    }

    public String toString() {
        return "MBOX (" + this.receiver + ") " + this.queue;
    }

    @Override
    public Receiver getReceiver() {
        return this.receiver;
    }

    @Override
    public void clear() {
        this.queue.clear();
        this.buffer.clear();
    }

    public boolean isFallThrough() {
        return this.fallThrough;
    }

    public void setFallThrough(boolean fallThrough) {
        this.fallThrough = fallThrough;
    }
}

