/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleInstance;
import org.eclipse.viatra.transformation.evm.api.event.AbstractRuleInstanceBuilder;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.api.event.EventRealm;
import org.eclipse.viatra.transformation.evm.api.event.EventSourceSpecification;

public class RuleSpecification<EventAtom> {
    private final ActivationLifeCycle lifeCycle;
    private final Multimap<ActivationState, Job<EventAtom>> jobs;
    private final Set<ActivationState> enabledStates;
    private final EventSourceSpecification<EventAtom> sourceSpecification;
    private String name;

    public RuleSpecification(EventSourceSpecification<EventAtom> sourceSpecification, ActivationLifeCycle lifeCycle, Set<Job<EventAtom>> jobs) {
        Preconditions.checkArgument((sourceSpecification != null ? 1 : 0) != 0, (Object)"Cannot create rule specification with null source definition!");
        this.sourceSpecification = sourceSpecification;
        this.lifeCycle = ActivationLifeCycle.copyOf(lifeCycle);
        this.jobs = HashMultimap.create();
        HashSet<ActivationState> states = new HashSet<ActivationState>();
        if (jobs != null && !jobs.isEmpty()) {
            for (Job<EventAtom> job : jobs) {
                ActivationState state = job.getActivationState();
                this.jobs.put((Object)state, job);
                states.add(state);
            }
        }
        this.enabledStates = ImmutableSet.copyOf(states);
    }

    public RuleSpecification(EventSourceSpecification<EventAtom> sourceSpecification, ActivationLifeCycle lifeCycle, Set<Job<EventAtom>> jobs, String name) {
        this(sourceSpecification, lifeCycle, jobs);
        this.name = name;
    }

    protected RuleInstance<EventAtom> instantiateRule(EventRealm eventRealm, EventFilter<? super EventAtom> filter) {
        RuleInstance ruleInstance = new RuleInstance(this);
        AbstractRuleInstanceBuilder<? super EventAtom> builder = this.sourceSpecification.getRuleInstanceBuilder(eventRealm);
        builder.prepareRuleInstance(ruleInstance, filter);
        return ruleInstance;
    }

    public EventSourceSpecification<EventAtom> getSourceSpecification() {
        return this.sourceSpecification;
    }

    public EventFilter<EventAtom> createEmptyFilter() {
        return this.sourceSpecification.createEmptyFilter();
    }

    public ActivationLifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public Set<ActivationState> getEnabledStates() {
        return this.enabledStates;
    }

    public Collection<Job<EventAtom>> getJobs(ActivationState state) {
        return this.jobs.get((Object)state);
    }

    public Multimap<ActivationState, Job<EventAtom>> getJobs() {
        return this.jobs;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("%s{lifecycle=%s, jobs=%s}", this.getClass().getName(), this.lifeCycle, this.jobs);
    }
}

