/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.launcher;

import com.google.common.collect.Maps;
import java.util.HashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystemPackage;
import org.eclipse.viatra.examples.cps.deployment.DeploymentPackage;
import org.eclipse.viatra.examples.cps.traceability.TraceabilityPackage;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.BatchOptimized;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.BatchQueryLocalSearch;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.BatchQueryOnly;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.BatchSimple;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.BatchViatra;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.CPSTransformationWrapper;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.ExplicitTraceability;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.PartialBatch;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.QueryResultTraceability;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.ViatraTransformation;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchHints;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.IConstraintEvaluationContext;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.ICostFunction;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.impl.StatisticsBasedConstraintCostFunction;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.impl.VariableBindingBasedCostFunction;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteBackendFactory;

public enum TransformationType {
    BATCH_SIMPLE{

        @Override
        public CPSTransformationWrapper getWrapper() {
            return new BatchSimple();
        }
    }
    ,
    BATCH_OPTIMIZED{

        @Override
        public CPSTransformationWrapper getWrapper() {
            return new BatchOptimized();
        }
    }
    ,
    BATCH_VIATRA_QUERY_RETE{

        @Override
        public CPSTransformationWrapper getWrapper() {
            QueryEvaluationHint hint = new QueryEvaluationHint(null, (IQueryBackendFactory)new ReteBackendFactory());
            return new BatchQueryOnly(hint, hint);
        }
    }
    ,
    BATCH_VIATRA_QUERY_LOCAL_SEARCH{

        @Override
        public CPSTransformationWrapper getWrapper() {
            QueryEvaluationHint hint = LocalSearchHints.getDefaultFlatten().build();
            return new BatchQueryLocalSearch(hint, hint);
        }
    }
    ,
    BATCH_VIATRA_QUERY_LOCAL_SEARCH_TRACE_STATS{

        @Override
        public CPSTransformationWrapper getWrapper() {
            QueryEvaluationHint hint = LocalSearchHints.getDefaultFlatten().build();
            final HashMap substitutions = Maps.newHashMap();
            substitutions.put(new EClassTransitiveInstancesKey(TraceabilityPackage.Literals.CPS2_DEPLOYMENT_TRACE), new EClassTransitiveInstancesKey(CyberPhysicalSystemPackage.Literals.IDENTIFIABLE));
            substitutions.put(new EClassTransitiveInstancesKey(DeploymentPackage.Literals.DEPLOYMENT_ELEMENT), new EClassTransitiveInstancesKey(CyberPhysicalSystemPackage.Literals.IDENTIFIABLE));
            substitutions.put(new EStructuralFeatureInstancesKey((EStructuralFeature)TraceabilityPackage.Literals.CPS2_DEPLOYMENT_TRACE__CPS_ELEMENTS), new EClassTransitiveInstancesKey(CyberPhysicalSystemPackage.Literals.IDENTIFIABLE));
            substitutions.put(new EStructuralFeatureInstancesKey((EStructuralFeature)TraceabilityPackage.Literals.CPS2_DEPLOYMENT_TRACE__DEPLOYMENT_ELEMENTS), new EClassTransitiveInstancesKey(CyberPhysicalSystemPackage.Literals.IDENTIFIABLE));
            substitutions.put(new EStructuralFeatureInstancesKey((EStructuralFeature)TraceabilityPackage.Literals.CPS_TO_DEPLOYMENT__TRACES), new EClassTransitiveInstancesKey(CyberPhysicalSystemPackage.Literals.IDENTIFIABLE));
            QueryEvaluationHint traceHint = LocalSearchHints.getDefaultFlatten().setCostFunction((ICostFunction)new StatisticsBasedConstraintCostFunction(){

                public long countTuples(IConstraintEvaluationContext input, IInputKey supplierKey) {
                    EClass eclass;
                    if (supplierKey instanceof EClassTransitiveInstancesKey && TraceabilityPackage.Literals.CPS_TO_DEPLOYMENT.equals(eclass = (EClass)((EClassTransitiveInstancesKey)supplierKey).getEmfKey())) {
                        return 1L;
                    }
                    if (substitutions.containsKey(supplierKey)) {
                        return input.getRuntimeContext().countTuples((IInputKey)substitutions.get(supplierKey), null);
                    }
                    return input.getRuntimeContext().countTuples(supplierKey, null);
                }
            }).build();
            return new BatchQueryLocalSearch(hint, traceHint);
        }
    }
    ,
    BATCH_VIATRA_QUERY_LOCAL_SEARCH_NO_FLAT{

        @Override
        public CPSTransformationWrapper getWrapper() {
            QueryEvaluationHint hint = LocalSearchHints.getDefault().build();
            return new BatchQueryLocalSearch(hint, hint);
        }
    }
    ,
    BATCH_VIATRA_QUERY_LOCAL_SEARCH_DUMB_PLANNER{

        @Override
        public CPSTransformationWrapper getWrapper() {
            QueryEvaluationHint hint = LocalSearchHints.getDefaultFlatten().setCostFunction((ICostFunction)new VariableBindingBasedCostFunction()).build();
            return new BatchQueryLocalSearch(hint, hint);
        }
    }
    ,
    BATCH_VIATRA_QUERY_LOCAL_SEARCH_STATISTICS{

        @Override
        public CPSTransformationWrapper getWrapper() {
            QueryEvaluationHint hint = LocalSearchHints.getDefault().setUseBase(false).build();
            return new BatchQueryLocalSearch(hint, hint);
        }
    }
    ,
    BATCH_VIATRA_QUERY_LOCAL_SEARCH_WO_INDEXER{

        @Override
        public CPSTransformationWrapper getWrapper() {
            QueryEvaluationHint hint = LocalSearchHints.getDefaultNoBase().build();
            return new BatchQueryLocalSearch(hint, hint);
        }
    }
    ,
    BATCH_VIATRA_TRANSFORMATION{

        @Override
        public CPSTransformationWrapper getWrapper() {
            return new BatchViatra();
        }

        @Override
        public boolean isDebuggable() {
            return true;
        }
    }
    ,
    INCR_VIATRA_QUERY_RESULT_TRACEABILITY{

        @Override
        public CPSTransformationWrapper getWrapper() {
            return new QueryResultTraceability();
        }
    }
    ,
    INCR_VIATRA_EXPLICIT_TRACEABILITY{

        @Override
        public CPSTransformationWrapper getWrapper() {
            return new ExplicitTraceability();
        }
    }
    ,
    INCR_VIATRA_AGGREGATED{

        @Override
        public CPSTransformationWrapper getWrapper() {
            return new PartialBatch();
        }
    }
    ,
    INCR_VIATRA_TRANSFORMATION{

        @Override
        public CPSTransformationWrapper getWrapper() {
            return new ViatraTransformation();
        }

        @Override
        public boolean isDebuggable() {
            return true;
        }
    };


    private TransformationType() {
    }

    public abstract CPSTransformationWrapper getWrapper();

    public boolean isDebuggable() {
        return false;
    }

    /* synthetic */ TransformationType(String string, int n, TransformationType transformationType) {
        this();
    }
}

