/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.runtime.annotation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.query.patternlanguage.annotations.IPatternAnnotationAdditionalValidator;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.AnnotationExpressionValidator;
import org.eclipse.viatra.query.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Annotation;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Expression;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.ListValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.StringValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Variable;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.VariableReference;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.viatra.query.patternlanguage.typing.ITypeInferrer;
import org.eclipse.viatra.query.patternlanguage.validation.IIssueCallback;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;

public class ConstraintAnnotationValidator
implements IPatternAnnotationAdditionalValidator {
    private static final String VALIDATOR_BASE_CODE = "org.eclipse.viatra.query.livevalidation.";
    public static final String SEVERITY_ISSUE_CODE = "org.eclipse.viatra.query.livevalidation.severity";
    public static final String INVALID_SYMMETRIC_PARAMETERS = "org.eclipse.viatra.query.livevalidation.symmetric";
    public static final String INVALID_KEY_PARAMETERS = "org.eclipse.viatra.query.livevalidation.key";
    @Inject
    private AnnotationExpressionValidator expressionValidator;
    @Inject
    private ITypeInferrer typeInferrer;

    public void executeAdditionalValidation(Annotation annotation, IIssueCallback validator) {
        Pattern pattern = (Pattern)annotation.eContainer();
        this.validateMessage(annotation, validator, pattern);
        this.validateSeverity(annotation, validator);
        List<Variable> keyList = this.validateKeys(annotation, validator, pattern);
        this.validateSymmetry(annotation, validator, pattern, keyList);
    }

    private void validateSymmetry(Annotation annotation, IIssueCallback validator, Pattern pattern, List<Variable> keyList) {
        Collection symmetricLists = CorePatternLanguageHelper.getAnnotationParameters((Annotation)annotation, (String)"symmetric");
        for (ValueReference symmetry : symmetricLists) {
            List<Object> symmetryList = Lists.newArrayList();
            if (symmetry instanceof ListValue) {
                symmetryList = this.computeVariableListFromListValue(validator, pattern, symmetry, INVALID_SYMMETRIC_PARAMETERS);
            }
            ArrayList symmetricParameters = Lists.newArrayList();
            ArrayList symmetricKeys = Lists.newArrayList();
            ArrayList symmetricProperties = Lists.newArrayList();
            for (Variable variable : symmetryList) {
                String variableName = variable.getName();
                symmetricParameters.add(variableName);
                if (keyList.contains(variable)) {
                    symmetricKeys.add(variableName);
                    continue;
                }
                symmetricProperties.add(variableName);
            }
            if (!symmetricKeys.isEmpty() && !symmetricProperties.isEmpty()) {
                validator.error("Symmetric parameters " + ((Object)symmetricParameters).toString() + " contains both key and non-key parameters!", (EObject)symmetry, null, INVALID_SYMMETRIC_PARAMETERS, new String[0]);
            }
            if (symmetricParameters.size() >= 2) continue;
            validator.error("Symmetric parameters must have at least two values!", (EObject)symmetry, null, INVALID_SYMMETRIC_PARAMETERS, new String[0]);
        }
    }

    private List<Variable> validateKeys(Annotation annotation, IIssueCallback validator, Pattern pattern) {
        List<Object> keyList = Lists.newArrayList();
        ValueReference keyRef = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"key");
        if (keyRef instanceof ListValue) {
            keyList = this.computeVariableListFromListValue(validator, pattern, keyRef, INVALID_KEY_PARAMETERS);
        }
        if (keyList.isEmpty()) {
            validator.error("No key defined!", (EObject)keyRef, null, INVALID_KEY_PARAMETERS, new String[0]);
        } else {
            boolean atLeastOneEClassKey = Iterables.any((Iterable)keyList, (Predicate)new Predicate<Variable>(){

                public boolean apply(Variable key) {
                    IInputKey classifier = ConstraintAnnotationValidator.this.typeInferrer.getType((Expression)key);
                    return classifier instanceof EClassTransitiveInstancesKey;
                }
            });
            if (!atLeastOneEClassKey) {
                validator.warning("At least one key should be EClass to make location possible!", (EObject)keyRef, null, INVALID_KEY_PARAMETERS, new String[0]);
            }
        }
        return keyList;
    }

    private List<Variable> computeVariableListFromListValue(IIssueCallback validator, Pattern pattern, ValueReference listValue, String issueCode) {
        ArrayList variables = Lists.newArrayList();
        Iterable<VariableReference> variableReferenceList = this.transformVariableReferenceList(listValue);
        Iterable<StringValue> stringValueList = this.transformStringList(listValue);
        if (!Iterables.isEmpty(variableReferenceList) && !Iterables.isEmpty(stringValueList)) {
            validator.error("Must not mix string and variable values!", (EObject)listValue, null, issueCode, new String[0]);
        }
        for (StringValue stringValue : stringValueList) {
            Variable parameterByName = CorePatternLanguageHelper.getParameterByName((Pattern)pattern, (String)stringValue.getValue());
            if (parameterByName == null) {
                validator.error(String.valueOf(stringValue.getValue()) + " is not a pattern parameter!", (EObject)stringValue, null, issueCode, new String[0]);
                continue;
            }
            variables.add(parameterByName);
            validator.warning("Deprecated: remove quotes to use variable reference instead!", (EObject)stringValue, null, issueCode, new String[0]);
        }
        for (VariableReference variableReference : variableReferenceList) {
            if (variableReference.getVariable() == null) continue;
            variables.add(variableReference.getVariable());
        }
        return variables;
    }

    private Iterable<StringValue> transformStringList(ValueReference listParameter) {
        EList listValues = ((ListValue)listParameter).getValues();
        Iterable keyStringValues = Iterables.filter((Iterable)listValues, StringValue.class);
        return keyStringValues;
    }

    private Iterable<VariableReference> transformVariableReferenceList(ValueReference listParameter) {
        EList listValues = ((ListValue)listParameter).getValues();
        Iterable keyStringValues = Iterables.filter((Iterable)listValues, VariableValue.class);
        Iterable keyParamList = Iterables.transform((Iterable)keyStringValues, (Function)new Function<VariableValue, VariableReference>(){

            public VariableReference apply(VariableValue ref) {
                return ref.getValue();
            }
        });
        return keyParamList;
    }

    private void validateSeverity(Annotation annotation, IIssueCallback validator) {
        String value;
        ValueReference severityRef = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"severity");
        if (severityRef instanceof StringValue && !(value = ((StringValue)severityRef).getValue()).equals("error") && !value.equals("warning") && !value.equals("info")) {
            validator.error("Severity must be either 'error','warning' or 'info'.", (EObject)severityRef, null, SEVERITY_ISSUE_CODE, new String[0]);
        }
    }

    private void validateMessage(Annotation annotation, IIssueCallback validator, Pattern pattern) {
        ValueReference messageRef = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"message");
        if (messageRef instanceof StringValue) {
            String value = ((StringValue)messageRef).getValue();
            this.expressionValidator.validateStringExpression(value, pattern, messageRef, validator);
        }
    }
}

