/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckOperation;

public class StructuralFeatureCheck
extends CheckOperation {
    int sourcePosition;
    int targetPosition;
    EStructuralFeature feature;

    public StructuralFeatureCheck(int sourcePosition, int targetPosition, EStructuralFeature feature) {
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
        this.feature = feature;
    }

    @Deprecated
    protected boolean check(MatchingFrame frame) throws LocalSearchException {
        return this.check(frame, null);
    }

    @Override
    protected boolean check(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        EObject source;
        block4: {
            Preconditions.checkNotNull((Object)frame.getValue(this.sourcePosition), (String)"Invalid plan, variable %s unbound", (Object[])new Object[]{this.sourcePosition});
            Preconditions.checkNotNull((Object)frame.getValue(this.targetPosition), (String)"Invalid plan, variable %s unbound", (Object[])new Object[]{this.targetPosition});
            try {
                source = (EObject)frame.getValue(this.sourcePosition);
                if (this.feature.getEContainingClass().isSuperTypeOf(source.eClass())) break block4;
                return false;
            }
            catch (ClassCastException e) {
                throw new LocalSearchException("Invalid type of variable", e);
            }
        }
        Object target = frame.getValue(this.targetPosition);
        if (this.feature.isMany()) {
            return ((Collection)source.eGet(this.feature)).contains(target);
        }
        return target.equals(source.eGet(this.feature));
    }

    public String toString() {
        return "check     " + this.feature.getContainerClass().getSimpleName() + "." + this.feature.getName() + "(+" + this.sourcePosition + ", +" + this.targetPosition + ")";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.sourcePosition, (Object)this.targetPosition, (Object[])new Integer[0]);
    }
}

