/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.generator.dtos;

import com.google.common.base.Objects;
import org.eclipse.viatra.examples.cps.generator.exceptions.ModelGeneratorException;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class Percentage {
    private double fraction = 0.0;

    public Percentage(double percentage) throws ModelGeneratorException {
        if (!(percentage >= 0.0)) {
            throw new ModelGeneratorException("Percentage must be greater than or equal to zero");
        }
        this.fraction = percentage / 100.0;
    }

    public Percentage(double total, double piece) throws ModelGeneratorException {
        if (total < 0.0 || piece < 0.0) {
            throw new ModelGeneratorException("Total and piece must be greater than or equal to zero");
        }
        this.fraction = piece / total;
    }

    public double getFraction() {
        return this.fraction;
    }

    public double getPercentage() {
        return this.fraction * 100.0;
    }

    public static double value(int total, Percentage percentage) {
        try {
            if (total < 0) {
                throw new ModelGeneratorException("Total must be greater than or equal to zero");
            }
            boolean _equals = Objects.equal((Object)percentage, null);
            if (_equals) {
                throw new ModelGeneratorException("Total must be valid");
            }
            return (double)total * percentage.fraction;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

