/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.util.timeline;

import java.util.Collections;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.Signed;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;

public class SingletonTimeline<Timestamp extends Comparable<Timestamp>>
extends Timeline<Timestamp> {
    protected final Timestamp start;

    SingletonTimeline(Timestamp timestamp) {
        this.start = timestamp;
    }

    SingletonTimeline(Diff<Timestamp> diff) {
        if (diff.size() != 1 || ((Signed)diff.get(0)).getDirection() == Direction.DELETE) {
            throw new IllegalArgumentException("There is only a single (insert) timestamp in the singleton timestamp!");
        }
        this.start = ((Signed)diff.get(0)).getPayload();
    }

    @Override
    public Signed<Timestamp> getSigned(int index) {
        return new Signed<Timestamp>(Direction.INSERT, this.getUnsigned(index));
    }

    @Override
    public Timestamp getUnsigned(int index) {
        if (index != 0) {
            throw new IllegalArgumentException("There is only a single (insert) timestamp in the singleton timestamp!");
        }
        return this.start;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isPresentAtInfinity() {
        return true;
    }

    @Override
    public Iterable<Signed<Timestamp>> asChangeSequence() {
        return Collections.singletonList(this.getSigned(0));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

