/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.testing.ui.wizards;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.viatra.query.testing.snapshot.InputSpecification;
import org.eclipse.viatra.query.testing.snapshot.QuerySnapshot;
import org.eclipse.viatra.query.testing.snapshot.SnapshotFactory;
import org.eclipse.viatra.query.testing.ui.ViatraQueryTestingUIPlugin;

public class SnapshotModelWizard
extends Wizard
implements INewWizard {
    public static final String FILE_EXTENSION = "snapshot";
    protected SnapshotModelWizardNewFileCreationPage newFileCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle("Create new Query Snapshot");
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.newFileCreationPage.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSet.createResource(fileURI);
                            QuerySnapshot rootObject = SnapshotFactory.eINSTANCE.createQuerySnapshot();
                            rootObject.setInputSpecification(InputSpecification.RESOURCE_SET);
                            resource.getContents().add((Object)rootObject);
                            resource.save(new HashMap());
                        }
                        catch (Exception exception) {
                            ViatraQueryTestingUIPlugin.getDefault().log(exception);
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(() -> SnapshotModelWizard.lambda$0(activePart, (ISelection)targetSelection));
            }
            page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            return true;
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error opening Snapshot Editor", (String)exception.getMessage());
            return false;
        }
        catch (Exception exception) {
            ViatraQueryTestingUIPlugin.getDefault().log(exception);
            return false;
        }
    }

    public void addPages() {
        Object selectedElement;
        String defaultModelBaseFilename = "QuerySnapshot";
        this.newFileCreationPage = new SnapshotModelWizardNewFileCreationPage(this.selection);
        this.newFileCreationPage.setTitle("New Query Snapshot");
        this.newFileCreationPage.setDescription("Initializes an empty query snapshot file");
        this.newFileCreationPage.setFileName("QuerySnapshot.snapshot");
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String modelFilename = "QuerySnapshot.snapshot";
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = "QuerySnapshot" + i + "." + FILE_EXTENSION;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
    }

    private static /* synthetic */ void lambda$0(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        ((ISetSelectionTarget)iWorkbenchPart).selectReveal(iSelection);
    }

    public class SnapshotModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        public SnapshotModelWizardNewFileCreationPage(IStructuredSelection selection) {
            super(SnapshotModelWizardNewFileCreationPage.class.getName(), selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (!Objects.equals(extension, SnapshotModelWizard.FILE_EXTENSION)) {
                    this.setErrorMessage("Snapshot models have to have a file extension of 'snapshot'");
                    return false;
                }
                return true;
            }
            return false;
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

