/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.util;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.viatra.dse.api.DSEException;

public final class Hasher {
    private MessageDigest md;
    private static final int HEX = 16;
    public static final String SHA1_PROTOCOLL = "SHA-1";

    private Hasher(MessageDigest md) {
        this.md = md;
    }

    public String hash(String data) {
        this.md.update(data.getBytes(), 0, data.length());
        return new String(this.md.digest());
    }

    private String alternateHashBest(String data) {
        this.md.update(data.getBytes(), 0, data.length());
        return new String(this.md.digest());
    }

    private String alternateHashSecondBest(String data) {
        this.md.update(data.getBytes(), 0, data.length());
        return new BigInteger(1, this.md.digest()).toString(16);
    }

    private String alternateHashThirdBest(String data) {
        this.md.update(data.getBytes(), 0, data.length());
        byte[] array = this.md.digest();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            sb.append(Integer.toHexString(array[i]));
            ++i;
        }
        return sb.toString();
    }

    public static Hasher getHasher(String protocoll) {
        try {
            return new Hasher(MessageDigest.getInstance(protocoll));
        }
        catch (NoSuchAlgorithmException e) {
            throw new DSEException(e);
        }
    }
}

