/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.tuple;

import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileTuple;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class VolatileMaskedTuple
extends VolatileTuple {
    protected final TupleMask mask;
    protected ITuple source;

    public VolatileMaskedTuple(ITuple source, TupleMask mask) {
        this.source = source;
        this.mask = mask;
    }

    public VolatileMaskedTuple(TupleMask mask) {
        this(null, mask);
    }

    public void updateTuple(ITuple newSource) {
        this.source = newSource;
    }

    @Override
    public Object get(int index) {
        Preconditions.checkState(this.source != null, "Source tuple is not set.");
        return this.mask.getValue(this.source, index);
    }

    @Override
    public int getSize() {
        return this.mask.getSize();
    }
}

