/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.plan.IPlanDescriptor;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlanForBody;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;

public class PlanDescriptor
implements IPlanDescriptor {
    private final PQuery pquery;
    private final List<SearchPlanForBody> plan;
    private final Set<PParameter> adornment;
    private Set<IInputKey> iteratedKeys = null;

    public PlanDescriptor(PQuery pquery, Collection<SearchPlanForBody> plan, Set<PParameter> adornment) {
        this.pquery = pquery;
        this.plan = new ArrayList<SearchPlanForBody>(plan);
        this.adornment = adornment;
    }

    @Override
    public PQuery getQuery() {
        return this.pquery;
    }

    @Override
    public Collection<SearchPlanForBody> getPlan() {
        return this.plan;
    }

    @Override
    public Set<PParameter> getAdornment() {
        return this.adornment;
    }

    @Override
    public Set<IInputKey> getIteratedKeys() {
        if (this.iteratedKeys == null) {
            HashSet<IInputKey> keys = new HashSet<IInputKey>();
            for (SearchPlanForBody bodyPlan : this.plan) {
                for (ISearchOperation operation : bodyPlan.getCompiledOperations()) {
                    if (!(operation instanceof IIteratingSearchOperation)) continue;
                    keys.add(((IIteratingSearchOperation)operation).getIteratedInputKey());
                }
            }
            this.iteratedKeys = Collections.unmodifiableSet(keys);
        }
        return this.iteratedKeys;
    }

    public String toString() {
        return "Plan for " + this.pquery.getFullyQualifiedName() + "(" + this.adornment.stream().map(PParameter::getName).collect(Collectors.joining(",")) + "{" + this.plan.stream().map(Object::toString).collect(Collectors.joining("}\n{")) + "}";
    }
}

