/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.stopconditions;

import java.util.Collection;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.evolutionary.interfaces.IStopCondition;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class OneSurvivalStopCondition
implements IStopCondition {
    private int surviviedIterations;

    public OneSurvivalStopCondition(int surviviedIterations) {
        this.surviviedIterations = surviviedIterations;
    }

    @Override
    public void init(ThreadContext context) {
    }

    @Override
    public boolean checkStopCondition(Collection<TrajectoryFitness> survivedPopulation) {
        int eldestInstance = -1;
        for (TrajectoryFitness trajectory : survivedPopulation) {
            if (trajectory.rank != 1 || eldestInstance >= trajectory.survive) continue;
            eldestInstance = trajectory.survive;
        }
        return eldestInstance >= this.surviviedIterations;
    }
}

