/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.equinox.http.Http;
import org.eclipse.equinox.http.HttpMsg;

public class StaticDataReader {
    protected Http http;
    protected static final String defaultMimeType = "application/octet-stream";
    protected static final String defaultMimeTable = "mime.types";
    protected static final String defaultStatusCodes = "status.codes";
    protected Hashtable mimeTypes;
    protected Hashtable statusCodes;

    public StaticDataReader(Http http) {
        this.http = http;
        InputStream in = this.getClass().getResourceAsStream(defaultMimeTable);
        this.mimeTypes = this.parseMimeTypes(in);
        in = this.getClass().getResourceAsStream(defaultStatusCodes);
        this.statusCodes = this.parseStatusCodes(in);
    }

    public String computeMimeType(String filename) {
        int i = filename.lastIndexOf(46);
        if (i >= 0) {
            return this.getMimeType(filename.substring(i + 1));
        }
        return this.getMimeType(filename);
    }

    public String computeStatusPhrase(int statusCode) {
        String statusPhrase = (String)this.statusCodes.get(new Integer(statusCode));
        if (statusPhrase != null) {
            return statusPhrase;
        }
        return HttpMsg.HTTP_STATUS_CODE_NOT_FOUND;
    }

    private String getMimeType(String extension) {
        String type = (String)this.mimeTypes.get(extension.toLowerCase());
        if (type != null) {
            return type;
        }
        return defaultMimeType;
    }

    private Hashtable parseMimeTypes(InputStream in) {
        Hashtable<String, String> resultMimeTypes;
        block14: {
            resultMimeTypes = new Hashtable<String, String>();
            if (in != null) {
                try {
                    try {
                        String line;
                        BufferedReader rdr = new BufferedReader(new InputStreamReader(in, "ISO-8859-1"));
                        while ((line = rdr.readLine()) != null) {
                            if (line.length() == 0 || line.charAt(0) == '#') continue;
                            StringTokenizer tokens = new StringTokenizer(line);
                            String type = tokens.nextToken();
                            while (tokens.hasMoreTokens()) {
                                String ext = tokens.nextToken();
                                resultMimeTypes.put(ext.toLowerCase(), type);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.http.logError(HttpMsg.HTTP_DEFAULT_MIME_TABLE_ERROR, e);
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return resultMimeTypes;
    }

    private Hashtable parseStatusCodes(InputStream in) {
        Hashtable<Integer, String> resultStatusCodes;
        block13: {
            resultStatusCodes = new Hashtable<Integer, String>();
            if (in != null) {
                try {
                    try {
                        String line;
                        BufferedReader rdr = new BufferedReader(new InputStreamReader(in, "ISO-8859-1"));
                        while ((line = rdr.readLine()) != null) {
                            if (line.length() == 0 || line.charAt(0) == '#') continue;
                            int space = line.indexOf(32);
                            Integer status = new Integer(line.substring(0, space));
                            String statusPhrase = line.substring(space + 1);
                            resultStatusCodes.put(status, statusPhrase);
                        }
                    }
                    catch (Exception e) {
                        this.http.logError(HttpMsg.HTTP_STATUS_CODES_TABLE_ERROR, e);
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return resultStatusCodes;
    }
}

