/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.FactoryReg;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.Reference;
import org.eclipse.equinox.internal.ds.Resolver;
import org.eclipse.equinox.internal.ds.ServiceReg;
import org.eclipse.equinox.internal.ds.impl.ComponentFactoryImpl;
import org.eclipse.equinox.internal.ds.impl.ComponentInstanceImpl;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentInstance;

public class InstanceProcess {
    public static Resolver resolver;
    public static InstanceProcess staticRef;
    protected Hashtable factoryRegistrations;
    private Vector delayedBindList;
    static Hashtable buildingThreads;
    static Hashtable stackCounts;
    static int waitTime;
    boolean busyBuilding = false;
    Thread workingThread;
    Object lock = new Object();
    int lockCounter = 0;
    static /* synthetic */ Class class$0;

    static {
        buildingThreads = new Hashtable(7);
        stackCounts = new Hashtable(7);
        waitTime = Activator.getInteger("equinox.scr.waitTimeOnBlock", 10000);
    }

    InstanceProcess(Resolver resolver) {
        InstanceProcess.resolver = resolver;
        this.factoryRegistrations = new Hashtable(19);
        this.delayedBindList = new Vector(10);
        staticRef = this;
    }

    void dispose() {
        this.factoryRegistrations = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getLock() {
        Object object = this.lock;
        synchronized (object) {
            Thread currentThread = Thread.currentThread();
            if (!this.busyBuilding) {
                this.busyBuilding = true;
                ++this.lockCounter;
                this.workingThread = currentThread;
            } else if (this.workingThread == currentThread) {
                ++this.lockCounter;
            } else if (this.workingThread != currentThread) {
                long start = System.currentTimeMillis();
                long timeToWait = waitTime;
                boolean lockSucceeded = false;
                do {
                    try {
                        this.lock.wait(timeToWait);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.busyBuilding) continue;
                    this.busyBuilding = true;
                    ++this.lockCounter;
                    this.workingThread = currentThread;
                    lockSucceeded = true;
                    break;
                } while ((timeToWait = (long)waitTime + start - System.currentTimeMillis()) > 0L);
                if (!lockSucceeded) {
                    Activator.log(null, 2, NLS.bind((String)Messages.TIMEOUT_GETTING_LOCK, (Object)Integer.toString(waitTime)), new Exception("Debug stacktrace"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeLock() {
        Object object = this.lock;
        synchronized (object) {
            if (this.busyBuilding) {
                if (this.workingThread == Thread.currentThread()) {
                    --this.lockCounter;
                }
                if (this.lockCounter == 0) {
                    this.busyBuilding = false;
                    this.workingThread = null;
                    this.lock.notify();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void buildComponents(Vector list, boolean security) {
        scp = null;
        factoryPid = null;
        if (list != null) {
            this.getLock();
            listToBuild = new Vector<ServiceComponentProp>();
            i = 0;
            while (i < list.size()) {
                scp = (ServiceComponentProp)list.elementAt(i);
                if (scp.getState() == 4) {
                    scp.setState(8);
                    listToBuild.addElement(scp);
                }
                ++i;
            }
            this.freeLock();
            i = 0;
            while (i < listToBuild.size()) {
                block36: {
                    scp = (ServiceComponentProp)listToBuild.elementAt(i);
                    this.getLock();
                    if (scp.getState() != 8) {
                        this.freeLock();
                    } else {
                        block34: {
                            block35: {
                                start = 0L;
                                successfullyBuilt = true;
                                if (Activator.PERF) {
                                    start = System.currentTimeMillis();
                                    Activator.log.info("[DS perf] Start building component " + scp);
                                }
                                sc = scp.serviceComponent;
                                if (sc.immediate || sc.factory == null && Activator.INSTANTIATE_ALL) {
                                    block33: {
                                        if (Activator.DEBUG) {
                                            Activator.log.debug("InstanceProcess.buildComponents(): building immediate component " + scp.name, null);
                                        }
                                        if (scp.instances.isEmpty()) {
                                            try {
                                                this.buildComponent(null, scp, null, security);
                                            }
                                            catch (Throwable e) {
                                                InstanceProcess.resolver.reorderSCP(scp);
                                                successfullyBuilt = false;
                                                if (e instanceof ComponentException) break block33;
                                                Activator.log(null, 1, NLS.bind((String)Messages.CANNOT_BUILD_COMPONENT, (Object)scp), e);
                                            }
                                        }
                                    }
                                    if (successfullyBuilt) {
                                        if (sc.serviceInterfaces != null) {
                                            this.registerService(scp, sc.serviceFactory, null);
                                        }
                                        scp.setState(16);
                                    }
                                    break block34;
                                }
                                if (sc.factory == null || !scp.isComponentFactory()) break block35;
                                if (Activator.DEBUG) {
                                    Activator.log.debug("InstanceProcess.buildComponents(): building component factory " + scp.name, null);
                                }
                                try {
                                    config = Activator.getConfiguration(sc.getConfigurationPID());
                                    if (config != null) {
                                        factoryPid = config.getFactoryPid();
                                    }
                                }
                                catch (Exception e) {
                                    Activator.log(null, 1, NLS.bind((String)Messages.CANNOT_GET_CONFIGURATION, (Object)sc.getConfigurationPID()), e);
                                }
                                if (factoryPid != null) {
                                    toDisable = new Vector<ServiceComponent>(1);
                                    toDisable.addElement(sc);
                                    InstanceProcess.resolver.disableComponents(toDisable, 0);
                                    successfullyBuilt = false;
                                    throw new ComponentException(Messages.INCOMPATIBLE_COMBINATION);
                                }
                                scp.setState(64);
                                this.registerComponentFactory(scp);
                                if (!successfullyBuilt) {
                                    scp.setState(4);
                                }
                                this.freeLock();
                                ** if (!Activator.PERF) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    start = System.currentTimeMillis() - start;
                                    Activator.log.info("[DS perf] The component " + scp + " is built for " + Long.toString(start) + "ms");
                                }
lbl-1000:
                                // 2 sources

                                {
                                    break block36;
                                }
                            }
                            try {
                                try {
                                    if (sc.provides != null) {
                                        scp.setState(32);
                                        this.registerService(scp, sc.serviceFactory, null);
                                    }
                                }
                                catch (Throwable t) {
                                    Activator.log(null, 1, NLS.bind((String)Messages.EXCEPTION_BUILDING_COMPONENT, (Object)scp.serviceComponent), t);
                                    if (!successfullyBuilt) {
                                        scp.setState(4);
                                    }
                                    this.freeLock();
                                    if (Activator.PERF) {
                                        start = System.currentTimeMillis() - start;
                                        Activator.log.info("[DS perf] The component " + scp + " is built for " + Long.toString(start) + "ms");
                                    }
                                    break block36;
                                }
                            }
                            catch (Throwable var12_14) {
                                if (!successfullyBuilt) {
                                    scp.setState(4);
                                }
                                this.freeLock();
                                if (Activator.PERF) {
                                    start = System.currentTimeMillis() - start;
                                    Activator.log.info("[DS perf] The component " + scp + " is built for " + Long.toString(start) + "ms");
                                }
                                throw var12_14;
                            }
                        }
                        if (!successfullyBuilt) {
                            scp.setState(4);
                        }
                        this.freeLock();
                        if (Activator.PERF) {
                            start = System.currentTimeMillis() - start;
                            Activator.log.info("[DS perf] The component " + scp + " is built for " + Long.toString(start) + "ms");
                        }
                    }
                }
                ++i;
            }
        }
    }

    void disposeInstances(Vector scpList, int deactivateReason) {
        if (scpList != null) {
            int i = 0;
            while (i < scpList.size()) {
                block13: {
                    ServiceComponentProp scp = (ServiceComponentProp)scpList.elementAt(i);
                    this.getLock();
                    if (scp.isUnsatisfied()) {
                        this.freeLock();
                    } else {
                        long start = 0L;
                        try {
                            try {
                                scp.setState(128);
                                if (Activator.PERF) {
                                    start = System.currentTimeMillis();
                                    Activator.log.info("[DS perf] Start disposing component " + scp);
                                }
                                this.disposeInstances(scp, deactivateReason);
                            }
                            catch (Throwable t) {
                                Activator.log(null, 1, NLS.bind((String)Messages.ERROR_DISPOSING_INSTANCES, (Object)scp), t);
                                resolver.componentDisposed(scp);
                                this.freeLock();
                                if (Activator.PERF) {
                                    start = System.currentTimeMillis() - start;
                                    Activator.log.info("[DS perf] The component " + scp + " is disposed for " + Long.toString(start) + "ms");
                                }
                                break block13;
                            }
                        }
                        catch (Throwable throwable) {
                            resolver.componentDisposed(scp);
                            this.freeLock();
                            if (Activator.PERF) {
                                start = System.currentTimeMillis() - start;
                                Activator.log.info("[DS perf] The component " + scp + " is disposed for " + Long.toString(start) + "ms");
                            }
                            throw throwable;
                        }
                        resolver.componentDisposed(scp);
                        this.freeLock();
                        if (Activator.PERF) {
                            start = System.currentTimeMillis() - start;
                            Activator.log.info("[DS perf] The component " + scp + " is disposed for " + Long.toString(start) + "ms");
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void disposeInstances(ServiceComponentProp scp, int deactivateReason) {
        if (scp.isComponentFactory()) {
            if (Activator.DEBUG) {
                Activator.log.debug("InstanceProcess.disposeInstances(): disposing component factory " + scp.name, null);
            }
            ServiceRegistration reg = (ServiceRegistration)this.factoryRegistrations.remove(scp);
            try {
                if (reg != null) {
                    reg.unregister();
                }
            }
            catch (IllegalStateException illegalStateException) {
                Activator.log(null, 2, NLS.bind((String)Messages.FACTORY_REGISTRATION_ALREADY_DISPOSED, (Object)scp.name), null);
            }
        }
        ServiceComponent sc = scp.serviceComponent;
        if (sc.provides == null) {
            if (Activator.DEBUG) {
                Activator.log.debug("InstanceProcess.disposeInstances(): disposing non-provider component " + scp.name, null);
            }
            scp.dispose(deactivateReason);
        } else {
            if (Activator.DEBUG) {
                Activator.log.debug("InstanceProcess.disposeInstances(): unregistering component " + scp.name, null);
            }
            if (scp.registration != null) {
                try {
                    ServiceRegistration reg = scp.registration;
                    scp.setRegistration(null);
                    reg.unregister();
                }
                catch (IllegalStateException illegalStateException) {
                    Activator.log(null, 2, NLS.bind((String)Messages.REGISTRATION_ALREADY_DISPOSED, (Object)scp.name), null);
                }
            } else if (Activator.DEBUG) {
                Activator.log.debug("InstanceProcess.disposeInstances(): cannot find registrations for " + scp.name, null);
            }
            scp.dispose(deactivateReason);
        }
    }

    private void registerComponentFactory(ServiceComponentProp scp) {
        if (this.factoryRegistrations.get(scp) != null) {
            return;
        }
        ComponentFactoryImpl factory = new ComponentFactoryImpl(scp);
        ServiceComponent sc = scp.serviceComponent;
        BundleContext bc = scp.bc;
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("component.name", sc.name);
        properties.put("component.factory", sc.factory);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.component.ComponentFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceRegistration reg = bc.registerService(clazz.getName(), (Object)factory, properties);
        this.factoryRegistrations.put(scp, reg);
    }

    final Vector dynamicBind(Vector refList) {
        if (refList == null || refList.isEmpty()) {
            return null;
        }
        Vector<Reference> unboundRefs = null;
        int i = 0;
        while (i < refList.size()) {
            Reference ref = (Reference)refList.elementAt(i);
            ServiceComponentProp scp = ref.scp;
            Vector instances = scp.instances;
            if (instances != null) {
                int j = 0;
                while (j < instances.size()) {
                    ComponentInstance compInstance = (ComponentInstance)instances.elementAt(j);
                    if (compInstance != null) {
                        try {
                            scp.bindReference(ref, compInstance);
                        }
                        catch (ClassCircularityError cce) {
                            if (unboundRefs == null) {
                                unboundRefs = new Vector<Reference>(1);
                            }
                            unboundRefs.add(ref);
                            Activator.log(scp.bc, 1, NLS.bind((String)Messages.ERROR_BINDING_REFERENCE, (Object)ref.reference), cce);
                        }
                        catch (Throwable t) {
                            Activator.log(scp.bc, 1, NLS.bind((String)Messages.ERROR_BINDING_REFERENCE, (Object)ref.reference), t);
                        }
                    }
                    ++j;
                }
            } else if (Activator.DEBUG) {
                Activator.log.debug("InstanceProcess.dynamicBind(): null instances for component " + scp.name, null);
            }
            ++i;
        }
        return unboundRefs;
    }

    final void dynamicUnBind(Hashtable serviceTable) {
        try {
            if (serviceTable == null || serviceTable.isEmpty()) {
                return;
            }
            Enumeration e = serviceTable.keys();
            while (e.hasMoreElements()) {
                Reference ref = (Reference)e.nextElement();
                Hashtable serviceSubTable = (Hashtable)serviceTable.get(ref);
                Enumeration sub = serviceSubTable.keys();
                while (sub.hasMoreElements()) {
                    ServiceComponentProp scp = (ServiceComponentProp)sub.nextElement();
                    ServiceReference serviceReference = (ServiceReference)serviceSubTable.get(scp);
                    Vector instances = scp.instances;
                    int i = 0;
                    while (i < instances.size()) {
                        ComponentInstance compInstance = (ComponentInstance)instances.elementAt(i);
                        if (compInstance != null) {
                            try {
                                scp.unbindDynamicReference(ref, compInstance, serviceReference);
                            }
                            catch (Throwable t) {
                                Activator.log(null, 1, NLS.bind((String)Messages.ERROR_UNBINDING_REFERENCE, (Object)ref.reference, (Object)compInstance.getInstance()), t);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Throwable e) {
            Activator.log(null, 1, Messages.UNEXPECTED_ERROR, e);
        }
    }

    final void referencePropertiesUpdated(Hashtable serviceReferenceTable) {
        Enumeration e = serviceReferenceTable.keys();
        while (e.hasMoreElements()) {
            Reference ref = (Reference)e.nextElement();
            Hashtable serviceSubTable = (Hashtable)serviceReferenceTable.get(ref);
            Enumeration sub = serviceSubTable.keys();
            while (sub.hasMoreElements()) {
                ServiceComponentProp scp = (ServiceComponentProp)sub.nextElement();
                ServiceReference serviceReference = (ServiceReference)serviceSubTable.get(scp);
                Vector instances = scp.instances;
                int i = 0;
                while (i < instances.size()) {
                    ComponentInstance compInstance = (ComponentInstance)instances.elementAt(i);
                    if (compInstance != null) {
                        try {
                            scp.updatedReference(ref, compInstance, serviceReference);
                        }
                        catch (Throwable t) {
                            Activator.log(null, 1, NLS.bind((String)Messages.ERROR_UPDATING_REFERENCE, (Object)ref.reference, (Object)compInstance.getInstance()), t);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private void registerService(ServiceComponentProp scp, boolean factory, ComponentInstanceImpl ci) {
        ServiceRegistration reg = null;
        if (scp.registration != null) {
            return;
        }
        Object service = factory ? new FactoryReg(scp) : new ServiceReg(scp, ci);
        reg = scp.bc.registerService(scp.serviceComponent.provides, service, (Dictionary)scp.getPublicServiceProperties());
        if (Activator.DEBUG) {
            Activator.log.debug("InstanceProcess.registerService(): " + scp.name + " registered as " + (factory ? "*factory*" : "*service*"), null);
        }
        if (scp.isUnsatisfied()) {
            try {
                reg.unregister();
                if (Activator.DEBUG) {
                    Activator.log.debug("InstanceProcess.registerService(): The service of component " + scp.name + " was unregistered because the component is already disposed!", null);
                }
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            scp.setRegistration(reg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentInstanceImpl buildComponent(Bundle usingBundle, ServiceComponentProp scp, Object instance, boolean security) throws ComponentException {
        ServiceComponentProp serviceComponentProp;
        ComponentInstanceImpl componentInstanceImpl;
        Counter counter;
        if (Activator.DEBUG) {
            Activator.log.debug("InstanceProcess.buildComponent(): building component " + scp.name, null);
        }
        this.getLock();
        Thread curThread = Thread.currentThread();
        ServiceComponentProp serviceComponentProp2 = scp;
        synchronized (serviceComponentProp2) {
            Thread theSCPThread = (Thread)buildingThreads.get(scp);
            if (theSCPThread != null && curThread != theSCPThread && !scp.isKindOfFactory()) {
                long start = System.currentTimeMillis();
                long timeToWait = waitTime;
                do {
                    try {
                        scp.wait(timeToWait);
                    }
                    catch (InterruptedException interruptedException) {}
                } while (buildingThreads.get(scp) != null && (timeToWait = (long)waitTime + start - System.currentTimeMillis()) > 0L);
                if (buildingThreads.get(scp) != null) {
                    this.freeLock();
                    if (!scp.instances.isEmpty()) {
                        Activator.log(null, 2, Messages.RETURNING_NOT_FULLY_ACTIVATED_INSTANCE, new Exception("Debug callstack"));
                        return (ComponentInstanceImpl)scp.instances.firstElement();
                    }
                    throw new RuntimeException(NLS.bind((String)Messages.INSTANCE_CREATION_TOOK_LONGER, (Object)scp, (Object)Integer.toString(waitTime)));
                }
            }
            buildingThreads.put(scp, curThread);
            counter = (Counter)stackCounts.get(curThread);
            if (counter == null) {
                counter = new Counter();
                stackCounts.put(curThread, counter);
            }
            ++counter.count;
        }
        long start = 0L;
        try {
            if (Activator.PERF) {
                start = System.currentTimeMillis();
                Activator.log.info("[DS perf] Start building instance of component " + scp);
            }
            ComponentInstanceImpl componentInstance = null;
            try {
                try {
                    componentInstance = scp.build(usingBundle, instance, security);
                }
                catch (ClassCircularityError e) {
                    this.processSCPInClassCircularityError(scp);
                    throw new ComponentException(NLS.bind((String)Messages.ERROR_BUILDING_COMPONENT_INSTANCE, (Object)scp.serviceComponent), (Throwable)e);
                }
                catch (ComponentException e) {
                    Throwable cause;
                    Activator.log(null, 1, e.getMessage(), e.getCause());
                    Throwable t = e.getCause();
                    if (t instanceof InvocationTargetException && (cause = t.getCause()) instanceof ClassCircularityError) {
                        this.processSCPInClassCircularityError(scp);
                    }
                    throw e;
                }
                catch (Throwable t) {
                    Activator.log(null, 1, NLS.bind((String)Messages.ERROR_BUILDING_COMPONENT_INSTANCE, (Object)scp.serviceComponent), t);
                    throw new ComponentException(NLS.bind((String)Messages.ERROR_BUILDING_COMPONENT_INSTANCE, (Object)scp.serviceComponent), t);
                }
            }
            finally {
                --counter.count;
                if (Activator.PERF) {
                    start = System.currentTimeMillis() - start;
                    Activator.log.info("[DS perf] The instance of component " + scp + " is built for " + Long.toString(start) + "ms");
                }
            }
            if (counter.count == 0 && !this.delayedBindList.isEmpty()) {
                InstanceProcess.resolver.mgr.enqueueWork(resolver, 2, this.delayedBindList.clone(), security);
                this.delayedBindList.removeAllElements();
            }
            componentInstanceImpl = componentInstance;
            serviceComponentProp = scp;
        }
        catch (Throwable throwable) {
            ServiceComponentProp serviceComponentProp3 = scp;
            synchronized (serviceComponentProp3) {
                if (counter.count == 0) {
                    stackCounts.remove(curThread);
                }
                buildingThreads.remove(scp);
                scp.notify();
            }
            this.freeLock();
            throw throwable;
        }
        synchronized (serviceComponentProp) {
            if (counter.count == 0) {
                stackCounts.remove(curThread);
            }
            buildingThreads.remove(scp);
            scp.notify();
        }
        this.freeLock();
        return componentInstanceImpl;
    }

    private void processSCPInClassCircularityError(ServiceComponentProp currentScp) {
        Vector<ServiceComponent> component = new Vector<ServiceComponent>(1);
        component.add(currentScp.serviceComponent);
        InstanceProcess.resolver.mgr.enqueueWork(InstanceProcess.resolver.mgr, InstanceProcess.resolver.mgr.ENABLE_COMPONENTS, component, false);
    }

    public void modifyComponent(ServiceComponentProp scp, Dictionary newProps) throws ComponentException {
        if (Activator.DEBUG) {
            Activator.log.debug("Modifying component " + scp.name, null);
        }
        this.getLock();
        long start = 0L;
        try {
            if (!scp.isBuilt()) {
                return;
            }
            if (Activator.PERF) {
                start = System.currentTimeMillis();
                Activator.log.info("[DS perf] Modifying component " + scp.name);
            }
            try {
                try {
                    scp.modify(newProps);
                }
                catch (ComponentException e) {
                    Activator.log(null, 1, e.getMessage(), e.getCause());
                    throw e;
                }
                catch (Throwable t) {
                    Activator.log(null, 1, NLS.bind((String)Messages.ERROR_MODIFYING_COMPONENT, (Object)scp.serviceComponent), t);
                    throw new ComponentException(NLS.bind((String)Messages.ERROR_MODIFYING_COMPONENT, (Object)scp.serviceComponent), t);
                }
            }
            finally {
                if (Activator.PERF) {
                    start = System.currentTimeMillis() - start;
                    Activator.log.info("[DS perf] Component " + scp + " modified for " + Long.toString(start) + "ms");
                }
            }
        }
        finally {
            this.freeLock();
        }
    }

    public Object getService(Reference reference, ServiceReference serviceReference) {
        if (this.checkCanCauseCycle(reference, serviceReference)) {
            if (Activator.DEBUG) {
                Activator.log.debug("InstanceProcess.getService(): cannot get service because of circularity! Reference is: " + reference.reference.name + " ; The service reference is " + serviceReference, null);
            }
            return null;
        }
        Object serviceObject = reference.scp.bc.getService(serviceReference);
        if (serviceObject == null && Activator.DEBUG) {
            Activator.log.debug("[SCR] Returned service object by the bundle context is null. The reference is " + reference.reference.name + "; The ServiceReference is " + serviceReference, null);
        }
        return serviceObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCanCauseCycle(Reference reference, ServiceReference serviceReference) {
        int i;
        ServiceComponentProp consumerSCP = reference.scp;
        if (buildingThreads.isEmpty()) {
            return false;
        }
        String producerComponentName = (String)serviceReference.getProperty("component.name");
        if (producerComponentName == null) {
            return false;
        }
        if (consumerSCP.getDelayActivateSCPNames() == null || !consumerSCP.getDelayActivateSCPNames().contains(producerComponentName)) {
            return false;
        }
        ServiceComponentProp producerSCP = null;
        Object object = resolver.getSyncLock();
        synchronized (object) {
            i = 0;
            while (i < InstanceProcess.resolver.scpEnabled.size()) {
                ServiceComponentProp scp = (ServiceComponentProp)InstanceProcess.resolver.scpEnabled.elementAt(i);
                if (producerComponentName.equals(scp.serviceComponent.name)) {
                    producerSCP = scp;
                    break;
                }
                ++i;
            }
        }
        if (producerSCP != null) {
            if (producerSCP.serviceComponent.serviceFactory) {
                if (!producerSCP.instances.isEmpty()) {
                    Bundle bundle = consumerSCP.bc.getBundle();
                    i = 0;
                    while (i < producerSCP.instances.size()) {
                        ComponentInstanceImpl producerComponentInstance = (ComponentInstanceImpl)producerSCP.instances.elementAt(i);
                        if (producerComponentInstance.getComponentContext().getUsingBundle().equals(bundle)) {
                            return false;
                        }
                        ++i;
                    }
                }
            } else if (!producerSCP.instances.isEmpty()) {
                return false;
            }
        }
        if (reference.reference.bind != null && reference.policy == 1) {
            this.delayedBindList.addElement(reference);
        }
        return true;
    }

    static class Counter {
        int count = 0;

        Counter() {
        }
    }
}

