/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.pool;

import org.eclipse.equinox.internal.util.pool.ObjectCreator;

public class ObjectPool {
    private Class template;
    protected Object[][] buff;
    protected int nextFree;
    protected int size;
    protected int minimumFill;
    protected int factor;
    protected int minfSize;
    protected int minffactor;
    protected boolean dontExtend;
    protected ObjectCreator oc;

    public Object getInstance() throws Exception {
        return this.oc != null ? this.oc.getInstance() : this.template.newInstance();
    }

    public ObjectPool(ObjectCreator oc, int size, int factor) {
        this(null, oc, size, factor, size * factor);
    }

    public ObjectPool(Class template, int size, int factor) {
        this(template, null, size, factor, size * factor);
    }

    public ObjectPool(Class template, int size, int factor, int minimumFill) {
        minimumFill = minimumFill > size * factor ? size * factor : minimumFill;
        this(template, null, size, factor, minimumFill);
    }

    public ObjectPool(ObjectCreator oc, int size, int factor, int minimumFill) {
        minimumFill = minimumFill > size * factor ? size * factor : minimumFill;
        this(null, oc, size, factor, minimumFill);
    }

    protected ObjectPool(Class template, ObjectCreator oc, int size, int factor, int minimumFill) {
        this.dontExtend = false;
        if (size <= 1 || factor < 1) {
            throw new IllegalArgumentException(String.valueOf(size) + " is less or equal to 1");
        }
        this.minimumFill = minimumFill < 1 ? 1 : minimumFill;
        this.oc = oc;
        if (template != null) {
            try {
                template.getConstructor(new Class[0]);
                this.template = template;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException(template + " don't have default constructor!");
            }
        }
        this.buff = new Object[size][];
        this.size = size;
        this.factor = factor;
        this.minfSize = this.minimumFill / factor;
        this.minffactor = this.minimumFill % factor;
        if (minimumFill <= 1) {
            this.nextFree = -1;
        } else {
            int i = 0;
            while (i < (this.minfSize == 0 ? 1 : this.minfSize)) {
                this.buff[i] = new Object[factor];
                ++i;
            }
            this.fill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill() {
        int i = 0;
        Object[][] objectArray = this.buff;
        synchronized (this.buff) {
            while (i < this.minfSize) {
                this.put(i, this.factor);
                ++i;
            }
            if (this.minffactor > 0) {
                this.put(i, this.minffactor);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.nextFree = this.minimumFill - 1;
            return;
        }
    }

    private void put(int i, int count) {
        int j = 0;
        while (j < count) {
            try {
                if (this.buff[i] == null) {
                    this.buff[i] = new Object[this.factor];
                }
                this.buff[i][j] = this.getInstance();
                this.nextFree = i * j;
            }
            catch (Throwable t) {
                throw new RuntimeException("buffer fill failed: " + t);
            }
            ++j;
        }
    }

    public void clear() {
        this.dontExtend = true;
        this.shrink(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shrink(int count) {
        Object[][] objectArray = this.buff;
        synchronized (this.buff) {
            while (this.nextFree > count) {
                this.buff[this.nextFree / this.factor][this.nextFree % this.factor] = null;
                --this.nextFree;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void shrink() {
        this.dontExtend = true;
        this.shrink(this.minimumFill);
        this.dontExtend = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        Object tmp = null;
        Object[][] objectArray = this.buff;
        synchronized (this.buff) {
            if (this.nextFree < 0) {
                if (this.dontExtend) {
                    throw new RuntimeException();
                }
                if (this.minimumFill <= 1) {
                    try {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return this.getInstance();
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("buffer fill failed: " + e);
                    }
                }
                this.fill();
            }
            tmp = this.buff[this.nextFree / this.factor][this.nextFree % this.factor];
            this.buff[this.nextFree / this.factor][this.nextFree % this.factor] = null;
            --this.nextFree;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseObject(Object obj) {
        if (this.dontExtend) {
            return false;
        }
        Object[][] objectArray = this.buff;
        synchronized (this.buff) {
            block6: {
                int tmp = this.nextFree + 1;
                int telement = tmp / this.factor;
                if (telement >= this.size) break block6;
                if (this.buff[telement] == null) {
                    this.buff[telement] = new Object[this.factor];
                }
                this.buff[telement][tmp % this.factor] = obj;
                this.nextFree = tmp;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }
}

