/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.framework.internal;

import java.util.HashMap;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.osgi.framework.Bundle;
import org.osgi.jmx.framework.PackageStateMBean;

public final class OSGiPackage {
    private Long[] exportingBundles;
    private Long[] importingBundles;
    private String name;
    private boolean removalPending;
    private String version;

    public OSGiPackage(String name, String version, boolean removalPending, Bundle[] exportingBundles, Bundle[] importingBundles) {
        this.name = name;
        this.version = version;
        this.removalPending = removalPending;
        this.exportingBundles = OSGiPackage.bundleIds(exportingBundles);
        this.importingBundles = OSGiPackage.bundleIds(importingBundles);
    }

    private static Long[] bundleIds(Bundle[] bundles) {
        if (bundles == null) {
            return new Long[0];
        }
        Long[] ids = new Long[bundles.length];
        int i = 0;
        while (i < bundles.length) {
            ids[i] = bundles[i].getBundleId();
            ++i;
        }
        return ids;
    }

    public static TabularData tableFrom(Set<OSGiPackage> packages) {
        TabularDataSupport table = new TabularDataSupport(PackageStateMBean.PACKAGES_TYPE);
        for (OSGiPackage pkg : packages) {
            table.put(pkg.asCompositeData());
        }
        return table;
    }

    private CompositeData asCompositeData() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Name", this.name);
        items.put("Version", this.version);
        items.put("RemovalPending", this.removalPending);
        items.put("ExportingBundles", this.exportingBundles);
        items.put("ImportingBundles", this.importingBundles);
        try {
            return new CompositeDataSupport(PackageStateMBean.PACKAGE_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form package open data", e);
        }
    }
}

