/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.Reference;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.SCRUtil;
import org.eclipse.equinox.internal.ds.impl.ReadOnlyDictionary;
import org.eclipse.equinox.internal.ds.model.ComponentReference;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.eclipse.equinox.internal.util.io.Externalizable;
import org.eclipse.equinox.internal.util.io.ExternalizableDictionary;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentInstance;

public class ServiceComponent
implements Externalizable,
Component {
    public static final int NAMESPACE_1_0 = 0;
    public static final int NAMESPACE_1_1 = 1;
    public static final int NAMESPACE_1_2 = 2;
    public static final String CONF_POLICY_OPTIONAL = "optional";
    public static final String CONF_POLICY_REQUIRE = "require";
    public static final String CONF_POLICY_IGNORE = "ignore";
    public Vector componentProps = null;
    public String name;
    public String factory;
    String implementation;
    Properties properties;
    String configurationPolicy = "optional";
    String activateMethodName = "activate";
    String deactivateMethodName = "deactivate";
    public String modifyMethodName = "";
    public String configurationPID;
    public Vector serviceInterfaces;
    public String[] provides;
    public boolean serviceFactory = false;
    public Vector references;
    public boolean autoenable = true;
    public boolean immediate = false;
    public int namespace = 0;
    private boolean activateCached = false;
    private boolean deactivateCached = false;
    private boolean modifyCached = false;
    private Method activateMethod;
    private Method deactivateMethod;
    private Method modifyMethod;
    public boolean enabled;
    public Bundle bundle;
    public BundleContext bc;
    boolean activateMethodDeclared = false;
    boolean deactivateMethodDeclared = false;
    int state = 4;
    public HashSet componentIssues = new HashSet(1, 1.0f);
    private ReadOnlyDictionary readOnlyProps;
    private static final Class[] ACTIVATE_METHODS_PARAMETERS;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.component.ComponentContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        ACTIVATE_METHODS_PARAMETERS = classArray;
    }

    public String getComponentIssues() {
        if (!this.componentIssues.isEmpty()) {
            String result = "";
            Object[] issues = this.componentIssues.toArray();
            int i = 0;
            while (i < issues.length) {
                result = String.valueOf(result) + issues[i] + "\n";
                ++i;
            }
            return result;
        }
        return null;
    }

    private final Method getMethod(Object instance, String methodName, boolean isActivate) throws Exception {
        int modifiers;
        if (Activator.DEBUG) {
            Activator.log.debug("ServiceComponent.getMethod(): " + methodName, null);
        }
        Method method = null;
        int methodPriority = Integer.MAX_VALUE;
        Class<?> clazz = instance != null ? instance.getClass() : null;
        while (method == null && clazz != null) {
            block29: {
                block25: {
                    if (!this.isNamespaceAtLeast11()) break block25;
                    Method[] methods = clazz.getDeclaredMethods();
                    int i = 0;
                    while (i < methods.length) {
                        block26: {
                            int prio;
                            if (!methods[i].getName().equals(methodName)) break block26;
                            Class[] params = methods[i].getParameterTypes();
                            boolean accepted = true;
                            int j = 0;
                            while (j < params.length) {
                                block27: {
                                    block28: {
                                        Class<?> clazz2 = params[j];
                                        Class<?> clazz3 = class$0;
                                        if (clazz3 == null) {
                                            try {
                                                clazz3 = Class.forName("org.osgi.service.component.ComponentContext");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (clazz2 == clazz3) break block27;
                                        Class<?> clazz4 = params[j];
                                        Class<?> clazz5 = class$1;
                                        if (clazz5 == null) {
                                            try {
                                                clazz5 = Class.forName("org.osgi.framework.BundleContext");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (clazz4 == clazz5) break block27;
                                        Class clazz6 = params[j];
                                        Class<?> clazz7 = class$2;
                                        if (clazz7 == null) {
                                            try {
                                                clazz7 = Class.forName("java.util.Map");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (clazz6 == clazz7) break block27;
                                        if (isActivate) break block28;
                                        Class clazz8 = params[j];
                                        Class<?> clazz9 = class$3;
                                        if (clazz9 == null) {
                                            try {
                                                clazz9 = Class.forName("java.lang.Integer");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (clazz8 == clazz9 || params[j] == Integer.TYPE) break block27;
                                    }
                                    accepted = false;
                                    break;
                                }
                                ++j;
                            }
                            if (accepted && SCRUtil.checkMethodAccess(instance.getClass(), clazz, methods[i], true) && (prio = this.getMethodPriority(params)) < methodPriority) {
                                method = methods[i];
                                methodPriority = prio;
                            }
                        }
                        ++i;
                    }
                    break block29;
                }
                try {
                    method = clazz.getDeclaredMethod(methodName, ACTIVATE_METHODS_PARAMETERS);
                    if (method != null && !SCRUtil.checkMethodAccess(instance.getClass(), clazz, method, false)) {
                        Activator.log(this.bc, 2, NLS.bind((String)Messages.METHOD_UNACCESSABLE, (Object)methodName, clazz), null);
                        this.componentIssues.add(NLS.bind((String)Messages.METHOD_UNACCESSABLE, (Object)methodName, clazz));
                        method = null;
                        break;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            if (method != null) break;
            clazz = clazz.getSuperclass();
        }
        if (method != null && !Modifier.isPublic(modifiers = method.getModifiers())) {
            SCRUtil.setAccessible(method);
        }
        return method;
    }

    private int getMethodPriority(Class[] params) {
        int priority = Integer.MAX_VALUE;
        if (params.length == 1) {
            Class clazz = params[0];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.osgi.service.component.ComponentContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                priority = 0;
            } else {
                Class clazz3 = params[0];
                Class<?> clazz4 = class$1;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$1 = Class.forName("org.osgi.framework.BundleContext");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3 == clazz4) {
                    priority = 1;
                } else {
                    Class clazz5 = params[0];
                    Class<?> clazz6 = class$2;
                    if (clazz6 == null) {
                        try {
                            clazz6 = class$2 = Class.forName("java.util.Map");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz5 == clazz6) {
                        priority = 2;
                    } else if (params[0] == Integer.TYPE) {
                        priority = 3;
                    } else {
                        Class clazz7 = params[0];
                        Class<?> clazz8 = class$3;
                        if (clazz8 == null) {
                            try {
                                clazz8 = class$3 = Class.forName("java.lang.Integer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz7 == clazz8) {
                            priority = 4;
                        }
                    }
                }
            }
        } else if (params.length >= 2) {
            priority = 5;
        } else if (params.length == 0) {
            priority = 6;
        }
        return priority;
    }

    void activate(Object instance, ComponentContext context) throws ComponentException {
        block31: {
            try {
                if (this.isNamespaceAtLeast11()) {
                    if (!this.activateCached) {
                        this.activateCached = true;
                        this.activateMethod = this.getMethod(instance, this.activateMethodName, true);
                    }
                    if (this.activateMethod != null) {
                        Class<?>[] paramTypes = this.activateMethod.getParameterTypes();
                        Object[] params = null;
                        params = paramTypes.length == 1 ? SCRUtil.getObjectArray() : new Object[paramTypes.length];
                        int i = 0;
                        while (i < params.length) {
                            Class<?> clazz = paramTypes[i];
                            Class<?> clazz2 = class$0;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = Class.forName("org.osgi.service.component.ComponentContext");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz == clazz2) {
                                params[i] = context;
                            } else {
                                Class<?> clazz3 = paramTypes[i];
                                Class<?> clazz4 = class$1;
                                if (clazz4 == null) {
                                    try {
                                        clazz4 = Class.forName("org.osgi.framework.BundleContext");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz3 == clazz4) {
                                    params[i] = context.getBundleContext();
                                } else {
                                    Class<?> clazz5 = paramTypes[i];
                                    Class<?> clazz6 = class$2;
                                    if (clazz6 == null) {
                                        try {
                                            clazz6 = Class.forName("java.util.Map");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (clazz5 == clazz6) {
                                        params[i] = context.getProperties();
                                    }
                                }
                            }
                            ++i;
                        }
                        try {
                            this.activateMethod.invoke(instance, params);
                            break block31;
                        }
                        finally {
                            if (params.length == 1) {
                                SCRUtil.release(params);
                            }
                        }
                    }
                    if (this.activateMethodName != "activate") {
                        this.componentIssues.add("Can not activate instance of component " + this.implementation + ". The specified activate method [" + this.activateMethodName + "] was not found.");
                        throw new ComponentException(NLS.bind((String)Messages.SPECIFIED_ACTIVATE_METHOD_NOT_FOUND, (Object)instance, (Object)this));
                    }
                    break block31;
                }
                if (!this.activateCached) {
                    this.activateCached = true;
                    this.activateMethod = this.getMethod(instance, "activate", true);
                }
                if (this.activateMethod == null) break block31;
                Object[] params = SCRUtil.getObjectArray();
                params[0] = context;
                try {
                    this.activateMethod.invoke(instance, params);
                }
                finally {
                    SCRUtil.release(params);
                }
            }
            catch (Throwable t) {
                if (t instanceof ComponentException) {
                    throw (ComponentException)t;
                }
                String cause = t.toString();
                if (t instanceof InvocationTargetException) {
                    cause = t.getCause().toString();
                }
                this.componentIssues.add("Can not activate instance of component " + this.implementation + ". The activation throws: " + cause);
                throw new ComponentException(NLS.bind((String)Messages.EXCEPTION_ACTIVATING_INSTANCE, (Object)instance, (Object)this.name), t);
            }
        }
    }

    void modified(Object instance, ComponentContext context) throws ComponentException {
        block26: {
            try {
                if (!this.isNamespaceAtLeast11()) break block26;
                if (!this.modifyCached) {
                    this.modifyCached = true;
                    if (this.modifyMethodName != "") {
                        this.modifyMethod = this.getMethod(instance, this.modifyMethodName, true);
                    }
                }
                if (this.modifyMethod != null) {
                    Class<?>[] paramTypes = this.modifyMethod.getParameterTypes();
                    Object[] params = null;
                    params = paramTypes.length == 1 ? SCRUtil.getObjectArray() : new Object[paramTypes.length];
                    int i = 0;
                    while (i < params.length) {
                        Class<?> clazz = paramTypes[i];
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("org.osgi.service.component.ComponentContext");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz == clazz2) {
                            params[i] = context;
                        } else {
                            Class<?> clazz3 = paramTypes[i];
                            Class<?> clazz4 = class$1;
                            if (clazz4 == null) {
                                try {
                                    clazz4 = Class.forName("org.osgi.framework.BundleContext");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz3 == clazz4) {
                                params[i] = context.getBundleContext();
                            } else {
                                Class<?> clazz5 = paramTypes[i];
                                Class<?> clazz6 = class$2;
                                if (clazz6 == null) {
                                    try {
                                        clazz6 = Class.forName("java.util.Map");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz5 == clazz6) {
                                    params[i] = context.getProperties();
                                }
                            }
                        }
                        ++i;
                    }
                    try {
                        this.modifyMethod.invoke(instance, params);
                        break block26;
                    }
                    finally {
                        if (params.length == 1) {
                            SCRUtil.release(params);
                        }
                    }
                }
                if (this.modifyMethodName != "") {
                    throw new ComponentException(NLS.bind((String)Messages.CANNOT_MODIFY_INSTANCE__MODIFY_METHOD_NOT_FOUND, (Object)instance, (Object)this));
                }
            }
            catch (Throwable t) {
                if (t instanceof ComponentException) {
                    throw (ComponentException)t;
                }
                Activator.log(this.bc, 1, NLS.bind((String)Messages.EXCEPTION_MODIFYING_COMPONENT, (Object)instance, (Object)this), t);
            }
        }
    }

    void deactivate(Object instance, ComponentContext context, int deactivateReason) {
        block36: {
            try {
                if (this.isNamespaceAtLeast11()) {
                    if (!this.deactivateCached) {
                        this.deactivateCached = true;
                        this.deactivateMethod = this.getMethod(instance, this.deactivateMethodName, false);
                    }
                    if (this.deactivateMethod != null) {
                        Class<?>[] paramTypes = this.deactivateMethod.getParameterTypes();
                        Object[] params = null;
                        params = paramTypes.length == 1 ? SCRUtil.getObjectArray() : new Object[paramTypes.length];
                        int i = 0;
                        while (i < params.length) {
                            Class<?> clazz = paramTypes[i];
                            Class<?> clazz2 = class$0;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = Class.forName("org.osgi.service.component.ComponentContext");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz == clazz2) {
                                params[i] = context;
                            } else {
                                Class<?> clazz3 = paramTypes[i];
                                Class<?> clazz4 = class$1;
                                if (clazz4 == null) {
                                    try {
                                        clazz4 = Class.forName("org.osgi.framework.BundleContext");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz3 == clazz4) {
                                    params[i] = context.getBundleContext();
                                } else {
                                    Class<?> clazz5 = paramTypes[i];
                                    Class<?> clazz6 = class$2;
                                    if (clazz6 == null) {
                                        try {
                                            clazz6 = Class.forName("java.util.Map");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (clazz5 == clazz6) {
                                        params[i] = context.getProperties();
                                    } else if (paramTypes[i] == Integer.TYPE) {
                                        params[i] = new Integer(deactivateReason);
                                    } else {
                                        Class<?> clazz7 = paramTypes[i];
                                        Class<?> clazz8 = class$3;
                                        if (clazz8 == null) {
                                            try {
                                                clazz8 = Class.forName("java.lang.Integer");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (clazz7 == clazz8) {
                                            params[i] = new Integer(deactivateReason);
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                        try {
                            this.deactivateMethod.invoke(instance, params);
                            break block36;
                        }
                        finally {
                            if (params.length == 1) {
                                SCRUtil.release(params);
                            }
                        }
                    }
                    if (this.deactivateMethodName != "deactivate") {
                        Activator.log(this.bc, 1, NLS.bind((String)Messages.SPECIFIED_DEACTIVATE_METHOD_NOT_FOUND, (Object)instance, (Object)this), null);
                    }
                    break block36;
                }
                if (!this.deactivateCached) {
                    this.deactivateCached = true;
                    this.deactivateMethod = this.getMethod(instance, "deactivate", false);
                }
                if (this.deactivateMethod == null) break block36;
                Object[] params = SCRUtil.getObjectArray();
                params[0] = context;
                try {
                    this.deactivateMethod.invoke(instance, params);
                }
                finally {
                    SCRUtil.release(params);
                }
            }
            catch (Throwable t) {
                Activator.log(this.bc, 1, NLS.bind((String)Messages.ERROR_DEACTIVATING_INSTANCE, (Object)this), t);
            }
        }
    }

    void validate(int line, int _namespace) {
        this.namespace = _namespace;
        if (this.name == null) {
            if (this.isNamespaceAtLeast11()) {
                this.name = this.implementation;
            } else {
                throw new IllegalArgumentException(NLS.bind((String)Messages.NO_NAME_ATTRIBUTE, (Object)Integer.toString(line)));
            }
        }
        if (this.isNamespaceAtLeast11() && this.configurationPolicy != CONF_POLICY_OPTIONAL && this.configurationPolicy != CONF_POLICY_REQUIRE && this.configurationPolicy != CONF_POLICY_IGNORE) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.INCORRECT_ACTIVATION_POLICY, (Object)this.name, (Object)Integer.toString(line)));
        }
        if (this.isNamespaceAtLeast12() && this.configurationPID == null) {
            this.configurationPID = this.name;
        }
        if (this.implementation == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.NO_IMPLEMENTATION_ATTRIBUTE, (Object)this.name, (Object)Integer.toString(line)));
        }
        if (this.factory != null && this.serviceFactory) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.INVALID_COMPONENT_FACTORY_AND_SERVICE_FACTORY, (Object)this.name));
        }
        if (this.immediate) {
            if (this.serviceFactory) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.INVALID_COMPONENT_IMMEDIATE_AND_SERVICE_FACTORY, (Object)this.name));
            }
            if (this.factory != null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.INVALID_COMPONENT_IMMEDIATE_AND_FACTORY, (Object)this.name));
            }
        } else if (this.serviceInterfaces == null && this.factory == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.INVALID_COMPONENT_NO_SERVICES_NO_IMMEDIATE, (Object)this.name));
        }
        if (this.references != null) {
            int i = 0;
            while (i < this.references.size()) {
                ComponentReference r = (ComponentReference)this.references.elementAt(i);
                if (r.name == null) {
                    if (this.isNamespaceAtLeast11()) {
                        r.name = r.interfaceName;
                    } else {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.COMPONENT_HAS_ILLEGAL_REFERENCE, (Object[])new Object[]{this.name, Integer.toString(line), r}));
                    }
                }
                if (r.interfaceName == null || r.name.length() == 0 || r.interfaceName.length() == 0) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.COMPONENT_HAS_ILLEGAL_REFERENCE, (Object[])new Object[]{this.name, Integer.toString(line), r}));
                }
                int j = i + 1;
                while (j < this.references.size()) {
                    ComponentReference ref2 = (ComponentReference)this.references.elementAt(j);
                    if (r.name.equals(ref2.name)) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.DUPLICATED_REFERENCE_NAMES, (Object)this.name, (Object)Integer.toString(line)));
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.serviceInterfaces != null && !this.serviceInterfaces.isEmpty()) {
            this.provides = new String[this.serviceInterfaces.size()];
            this.serviceInterfaces.copyInto(this.provides);
        }
        this.enabled = this.autoenable;
    }

    final Object createInstance() throws Exception {
        try {
            return this.bundle.loadClass(this.implementation).newInstance();
        }
        catch (Throwable t) {
            throw new ComponentException(NLS.bind((String)Messages.EXCEPTION_CREATING_COMPONENT_INSTANCE, (Object)this), t);
        }
    }

    public final void dispose() {
        this.deactivateCached = false;
        this.activateCached = false;
        this.deactivateMethod = null;
        this.activateMethod = null;
        this.enabled = false;
        this.bundle = null;
        if (this.references != null) {
            int i = 0;
            while (i < this.references.size()) {
                ComponentReference ref = (ComponentReference)this.references.elementAt(i);
                ref.dispose();
                ++i;
            }
            this.references.removeAllElements();
            this.references = null;
        }
        if (this.properties != null) {
            this.properties.clear();
            this.properties = null;
        }
        if (this.serviceInterfaces != null) {
            this.serviceInterfaces.removeAllElements();
            this.serviceInterfaces = null;
        }
    }

    public boolean provides(String interfaceName) {
        return this.serviceInterfaces != null && this.serviceInterfaces.contains(interfaceName);
    }

    public String getConfigurationPID() {
        if (this.isNamespaceAtLeast12()) {
            return this.configurationPID;
        }
        return this.name;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Component[");
        buffer.append("\n\tname = ").append(this.name);
        if (this.isNamespaceAtLeast11()) {
            buffer.append("\n\tactivate = ").append(this.activateMethodName);
            buffer.append("\n\tdeactivate = ").append(this.deactivateMethodName);
            buffer.append("\n\tmodified = ").append(this.modifyMethodName);
            buffer.append("\n\tconfiguration-policy = ").append(this.configurationPolicy);
        }
        if (this.isNamespaceAtLeast12()) {
            buffer.append("\n\tconfiguration-pid = ").append(this.configurationPID);
        }
        buffer.append("\n\tfactory = ").append(this.factory);
        buffer.append("\n\tautoenable = ").append(this.autoenable);
        buffer.append("\n\timmediate = ").append(this.immediate);
        buffer.append("\n\timplementation = ").append(this.implementation);
        buffer.append("\n\tstate = ").append(SCRUtil.getStateStringRepresentation(this.state));
        StringBuffer buf = new StringBuffer(200);
        if (this.properties != null) {
            buf.append('{');
            Enumeration<Object> keys = this.properties.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                buf.append(key).append('=').append(SCRUtil.getStringRepresentation(this.properties.get(key)));
                if (!keys.hasMoreElements()) continue;
                buf.append(", ");
            }
            buf.append('}');
        }
        buffer.append("\n\tproperties = ").append(buf.toString());
        buffer.append("\n\tserviceFactory = ").append(this.serviceFactory);
        buffer.append("\n\tserviceInterface = ").append(this.serviceInterfaces);
        if (this.references == null) {
            buffer.append("\n\treferences = ").append("null");
        } else {
            buffer.append("\n\treferences = {");
            int i = 0;
            while (i < this.references.size()) {
                buffer.append("\n\t\t").append(this.references.elementAt(i));
                ++i;
            }
            buffer.append("\n\t}");
        }
        buffer.append("\n\tlocated in bundle = ").append(this.bundle);
        buffer.append("\n]");
        return buffer.toString();
    }

    public synchronized void writeObject(OutputStream s) throws Exception {
        try {
            DataOutputStream out = s instanceof DataOutputStream ? (DataOutputStream)s : new DataOutputStream(s);
            out.writeUTF(this.name);
            out.writeUTF(this.implementation);
            out.writeBoolean(this.serviceFactory);
            out.writeBoolean(this.autoenable);
            out.writeBoolean(this.immediate);
            boolean flag = this.factory != null;
            out.writeBoolean(flag);
            if (flag) {
                out.writeUTF(this.factory);
            }
            int count = this.serviceInterfaces == null ? 0 : this.serviceInterfaces.size();
            out.writeInt(count);
            int i = 0;
            while (i < count) {
                out.writeUTF(this.serviceInterfaces.elementAt(i).toString());
                ++i;
            }
            count = this.references == null ? 0 : this.references.size();
            out.writeInt(count);
            i = 0;
            while (i < count) {
                ComponentReference ref = (ComponentReference)this.references.elementAt(i);
                ref.writeObject(out);
                ++i;
            }
            flag = this.properties != null && !this.properties.isEmpty();
            out.writeBoolean(flag);
            if (flag) {
                ExternalizableDictionary dictionary = new ExternalizableDictionary();
                dictionary.copyFrom(this.properties);
                dictionary.writeObject(out);
            }
            out.writeInt(this.namespace);
            if (this.isNamespaceAtLeast11()) {
                if (this.configurationPolicy == CONF_POLICY_OPTIONAL) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeUTF(this.configurationPolicy);
                }
                if (!this.activateMethodDeclared) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeUTF(this.activateMethodName);
                }
                if (!this.deactivateMethodDeclared) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeUTF(this.deactivateMethodName);
                }
                if (this.modifyMethodName == "") {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeUTF(this.modifyMethodName);
                }
            }
            if (this.isNamespaceAtLeast12()) {
                if (this.configurationPID == this.name) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeUTF(this.configurationPID);
                }
            }
        }
        catch (Exception e) {
            Activator.log(null, 1, Messages.ERROR_WRITING_OBJECT, e);
            throw e;
        }
    }

    public synchronized void readObject(InputStream s) throws Exception {
        try {
            int i;
            int count;
            DataInputStream in = s instanceof DataInputStream ? (DataInputStream)s : new DataInputStream(s);
            this.name = in.readUTF();
            this.implementation = in.readUTF();
            this.serviceFactory = in.readBoolean();
            this.autoenable = in.readBoolean();
            this.immediate = in.readBoolean();
            boolean flag = in.readBoolean();
            if (flag) {
                this.factory = in.readUTF();
            }
            if ((count = in.readInt()) > 0) {
                this.serviceInterfaces = new Vector(count);
                this.provides = new String[count];
                i = 0;
                while (i < count) {
                    String entry = in.readUTF();
                    this.serviceInterfaces.addElement(entry);
                    this.provides[i] = entry;
                    ++i;
                }
            }
            if ((count = in.readInt()) > 0) {
                this.references = new Vector(count);
                i = 0;
                while (i < count) {
                    ComponentReference ref = new ComponentReference(this);
                    ref.readObject(in);
                    ++i;
                }
            }
            if (flag = in.readBoolean()) {
                ExternalizableDictionary dictionary = new ExternalizableDictionary();
                dictionary.readObject(in);
                Properties props = new Properties();
                Enumeration keys = dictionary.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    props.put(key, dictionary.get(key));
                }
                this.properties = props;
            }
            this.namespace = in.readInt();
            if (this.isNamespaceAtLeast11()) {
                flag = in.readBoolean();
                if (flag) {
                    this.configurationPolicy = in.readUTF();
                    this.configurationPolicy = this.configurationPolicy.equals(CONF_POLICY_IGNORE) ? CONF_POLICY_IGNORE : CONF_POLICY_REQUIRE;
                }
                if (flag = in.readBoolean()) {
                    this.activateMethodName = in.readUTF();
                    this.activateMethodDeclared = true;
                }
                if (flag = in.readBoolean()) {
                    this.deactivateMethodName = in.readUTF();
                    this.deactivateMethodDeclared = true;
                }
                if (flag = in.readBoolean()) {
                    this.modifyMethodName = in.readUTF();
                }
            }
            if (this.isNamespaceAtLeast12()) {
                flag = in.readBoolean();
                this.configurationPID = flag ? in.readUTF() : this.name;
            }
        }
        catch (Exception e) {
            Activator.log(null, 1, Messages.ERROR_READING_OBJECT, e);
            throw e;
        }
    }

    public ServiceComponentProp getComponentPropByPID(String pid) {
        if (this.componentProps != null) {
            int i = 0;
            while (i < this.componentProps.size()) {
                ServiceComponentProp scp = (ServiceComponentProp)this.componentProps.elementAt(i);
                if (scp.getProperties() != null && pid.equals(scp.getProperties().get("service.pid"))) {
                    return scp;
                }
                ++i;
            }
        }
        return null;
    }

    public void addServiceComponentProp(ServiceComponentProp scp) {
        if (this.componentProps == null) {
            this.componentProps = new Vector(1);
        }
        this.componentProps.addElement(scp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceComponentProp getServiceComponentProp() {
        if (this.componentProps != null) {
            Vector vector = this.componentProps;
            synchronized (vector) {
                if (!this.componentProps.isEmpty()) {
                    return (ServiceComponentProp)this.componentProps.elementAt(0);
                }
            }
        }
        return null;
    }

    public boolean isNamespaceAtLeast11() {
        return this.namespace >= 1;
    }

    public boolean isNamespaceAtLeast12() {
        return this.namespace >= 2;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public String getConfigurationPolicy() {
        return this.configurationPolicy;
    }

    public void disable() {
        if (this.getState() == 256) {
            throw new IllegalStateException(Messages.COMPONENT_DISPOSED);
        }
        if (this.getState() != 1) {
            InstanceProcess.resolver.mgr.disableComponent(this.name, this.bundle);
        }
    }

    public void enable() {
        if (this.getState() == 256) {
            throw new IllegalStateException(Messages.COMPONENT_DISPOSED);
        }
        if (this.getState() == 1) {
            InstanceProcess.resolver.mgr.enableComponent(this.name, this.bundle);
        }
    }

    public String getActivate() {
        return this.activateMethodName;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String getClassName() {
        return this.implementation;
    }

    public ComponentInstance getComponentInstance() {
        Vector instances;
        if (this.componentProps != null && !this.componentProps.isEmpty() && !(instances = ((ServiceComponentProp)this.componentProps.elementAt((int)0)).instances).isEmpty()) {
            return (ComponentInstance)instances.elementAt(0);
        }
        return null;
    }

    public String getDeactivate() {
        return this.deactivateMethodName;
    }

    public String getFactory() {
        return this.factory;
    }

    public long getId() {
        if (this.componentProps != null && !this.componentProps.isEmpty()) {
            return (Long)((ServiceComponentProp)this.componentProps.elementAt((int)0)).properties.get("component.id");
        }
        return -1L;
    }

    public String getModified() {
        if (!this.isNamespaceAtLeast11()) {
            return null;
        }
        return this.modifyMethodName;
    }

    public String getName() {
        return this.name;
    }

    public Dictionary getProperties() {
        if (this.readOnlyProps == null) {
            this.readOnlyProps = new ReadOnlyDictionary(this.properties);
        } else {
            this.readOnlyProps.updateDelegate(this.properties);
        }
        return this.readOnlyProps;
    }

    public Reference[] getReferences() {
        if (this.references != null && !this.references.isEmpty()) {
            Object[] res = new Reference[this.references.size()];
            this.references.copyInto(res);
            return res;
        }
        return null;
    }

    public String[] getServices() {
        return this.provides;
    }

    public int getState() {
        if (this.componentProps != null && !this.componentProps.isEmpty()) {
            return ((ServiceComponentProp)this.componentProps.elementAt(0)).getState();
        }
        return this.state;
    }

    public boolean isActivateDeclared() {
        if (!this.isNamespaceAtLeast11()) {
            return false;
        }
        return this.activateMethodDeclared;
    }

    public boolean isDeactivateDeclared() {
        if (!this.isNamespaceAtLeast11()) {
            return false;
        }
        return this.deactivateMethodDeclared;
    }

    public boolean isDefaultEnabled() {
        return this.autoenable;
    }

    public boolean isServiceFactory() {
        return this.serviceFactory;
    }

    public void setState(int newState) {
        this.state = newState;
    }
}

