/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.common.component;

import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.ObserverMethod;
import org.apache.webbeans.component.creation.AbstractInjectedTargetBeanCreator;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.ejb.common.component.EjbBeanCreator;
import org.apache.webbeans.ejb.common.util.EjbValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbBeanCreatorImpl<T>
extends AbstractInjectedTargetBeanCreator<T>
implements EjbBeanCreator<T> {
    public EjbBeanCreatorImpl(BaseEjbBean<T> ejbBean) {
        super(ejbBean);
    }

    public void checkCreateConditions() {
        EjbValidator.validateDecoratorOrInterceptor(this.getBean().getReturnType());
    }

    public void defineScopeType(String errorMessage, boolean allowLazyInit) {
        super.defineScopeType(errorMessage, allowLazyInit);
        EjbValidator.validateEjbScopeType(this.getBean());
        EjbValidator.validateGenericBeanType(this.getBean().getReturnType(), this.getBean().getScope());
    }

    public void defineApiType() {
        if (this.isDefaultMetaDataProvider()) {
            List<Class<?>> businessLocals = this.getBean().getBusinessLocalInterfaces();
            for (Class<?> clazz : businessLocals) {
                this.getBean().addApiType(clazz);
            }
            this.getBean().addApiType(Object.class);
            if (this.getBean().needsBeanLocalViewAddedToTypes()) {
                Class clazz = this.getBean().getBeanClass();
                while (!clazz.equals(Object.class)) {
                    this.getBean().addApiType(clazz);
                    clazz = clazz.getSuperclass();
                }
            }
        } else {
            Set types = this.getAnnotatedType().getTypeClosure();
            this.getBean().getTypes().addAll(types);
        }
    }

    public Set<ObserverMethod<?>> defineObserverMethods() {
        Set observerMethods = super.defineObserverMethods();
        EjbValidator.validateObserverMethods(this.getBean(), observerMethods);
        return observerMethods;
    }

    public BaseEjbBean<T> getBean() {
        return (BaseEjbBean)((Object)BaseEjbBean.class.cast(super.getBean()));
    }
}

