/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.useradmin.internal;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.osgi.jmx.service.useradmin.UserAdminMBean;
import org.osgi.service.useradmin.Authorization;

public final class OSGiAuthorization {
    private String name;
    private String[] roles;

    public OSGiAuthorization(CompositeData data) {
        if (data != null) {
            this.name = (String)data.get("Name");
            this.roles = (String[])data.get("Roles");
        }
    }

    public OSGiAuthorization(Authorization authorization) {
        this(authorization.getName(), authorization.getRoles());
    }

    public OSGiAuthorization(String name, String[] roles) {
        this.name = name;
        this.roles = roles;
    }

    public CompositeData asCompositeData() throws OpenDataException {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Name", this.name);
        items.put("Roles", this.roles);
        return new CompositeDataSupport(UserAdminMBean.AUTORIZATION_TYPE, items);
    }

    public String getName() {
        return this.name;
    }

    public String[] getRoles() {
        return this.roles;
    }
}

