/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.equinox.http.Http;
import org.eclipse.equinox.http.HttpDate;
import org.eclipse.equinox.http.HttpMsg;
import org.eclipse.equinox.http.Tokenizer;
import org.eclipse.equinox.http.URI;
import org.eclipse.equinox.http.servlet.HttpServletResponseImpl;
import org.eclipse.equinox.http.servlet.HttpSessionImpl;
import org.eclipse.equinox.http.servlet.ServletContextImpl;
import org.eclipse.equinox.http.servlet.ServletInputStreamImpl;
import org.eclipse.equinox.socket.SocketInterface;
import org.eclipse.osgi.util.NLS;

public class HttpServletRequestImpl
implements HttpServletRequest {
    protected Http http;
    protected HttpServletResponseImpl response;
    protected SocketInterface socket;
    protected ServletInputStreamImpl servletInputStream;
    protected String scheme;
    protected String authType = null;
    protected String remoteUser = null;
    protected int contentLength = -2;
    protected String contentType = null;
    protected String serverName = null;
    protected Hashtable parameters = null;
    protected Hashtable attributes = null;
    protected BufferedReader reader = null;
    protected ServletInputStream inputstream = null;
    protected Cookie[] cookies;
    protected String method = null;
    protected String reqURI = null;
    protected String protocol = null;
    protected String servletPath = null;
    protected String pathInfo = null;
    protected String queryString = null;
    protected String charset = null;
    protected Hashtable headers = null;
    protected HttpSessionImpl session;
    protected String requestedSessionId = null;
    protected ServletContextImpl servletContext;
    protected boolean parsedQueryData = false;

    public HttpServletRequestImpl(SocketInterface socket, Http http, HttpServletResponseImpl response) throws IOException {
        this.response = response;
        this.socket = socket;
        this.http = http;
        this.scheme = socket.getScheme();
        this.servletInputStream = new ServletInputStreamImpl(socket.getInputStream());
        response.setRequest(this);
        this.parseHeaders();
    }

    public void init(String servletPathParam, ServletContextImpl servletContextParam) {
        Object obj;
        this.servletPath = servletPathParam;
        this.servletContext = servletContextParam;
        String tempPathInfo = this.reqURI.substring(servletPathParam.length());
        if (tempPathInfo.length() != 0 && !tempPathInfo.equals("/")) {
            this.pathInfo = tempPathInfo;
        }
        if (this.authType == null && (obj = this.getAttribute("org.osgi.service.http.authentication.type")) instanceof String) {
            this.authType = (String)obj;
        }
        if (this.remoteUser == null && (obj = this.getAttribute("org.osgi.service.http.authentication.remote.user")) instanceof String) {
            this.remoteUser = (String)obj;
        }
    }

    public Object getAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        if (this.attributes != null) {
            return this.attributes.keys();
        }
        return new Vector(0).elements();
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCharacterEncoding() {
        if (this.contentType == null) {
            this.getContentType();
        }
        return this.charset;
    }

    public int getContentLength() {
        if (this.contentLength == -2) {
            this.contentLength = this.getIntHeaderUpper("CONTENT-LENGTH");
        }
        return this.contentLength;
    }

    public String getContentType() {
        if (this.contentType == null) {
            int index;
            this.contentType = this.getHeaderUpper("CONTENT-TYPE");
            if (this.contentType != null && (index = this.contentType.indexOf(59, 0)) >= 0) {
                char c;
                Tokenizer tokenizer = new Tokenizer(this.contentType);
                tokenizer.getToken(";");
                tokenizer.getChar();
                do {
                    String attribute = tokenizer.getToken("=");
                    c = tokenizer.getChar();
                    if (c != '=') break;
                    String value = tokenizer.getString(";");
                    c = tokenizer.getChar();
                    if (!"charset".equalsIgnoreCase(attribute)) continue;
                    this.charset = value;
                } while (c != '\u0000');
            }
        }
        return this.contentType;
    }

    public Cookie[] getCookies() {
        this.parseCookies();
        return (Cookie[])this.cookies.clone();
    }

    public long getDateHeader(String name) {
        String date = this.getHeader(name);
        if (date != null) {
            HttpDate d = new HttpDate(date);
            if (d.isValid()) {
                return d.getAsLong();
            }
            throw new IllegalArgumentException();
        }
        return -1L;
    }

    public String getHeader(String name) {
        return (String)this.headers.get(name.toUpperCase());
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    protected String getHeaderUpper(String name) {
        return (String)this.headers.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletInputStream getInputStream() {
        if (this.inputstream == null) {
            HttpServletRequestImpl httpServletRequestImpl = this;
            synchronized (httpServletRequestImpl) {
                if (this.inputstream == null) {
                    if (this.reader != null) {
                        throw new IllegalStateException();
                    }
                    this.inputstream = this.servletInputStream.getServletInputStream(this.getContentLength());
                }
            }
        }
        return this.inputstream;
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    protected int getIntHeaderUpper(String name) {
        String value = this.getHeaderUpper(name);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    public String getMethod() {
        return this.method;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        if (!this.parsedQueryData) {
            this.parseQueryData();
        }
        if (this.parameters != null) {
            return this.parameters.keys();
        }
        return new Vector(0).elements();
    }

    public String[] getParameterValues(String name) {
        if (!this.parsedQueryData) {
            this.parseQueryData();
        }
        if (this.parameters != null) {
            return (String[])this.parameters.get(name);
        }
        return null;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.servletContext.getRealPath(this.getPathInfo());
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQueryString() {
        return this.queryString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedReader getReader() {
        if (this.reader == null) {
            HttpServletRequestImpl httpServletRequestImpl = this;
            synchronized (httpServletRequestImpl) {
                if (this.reader == null) {
                    if (this.inputstream != null) {
                        throw new IllegalStateException();
                    }
                    this.reader = new BufferedReader(new InputStreamReader((InputStream)this.servletInputStream.getServletInputStream(this.getContentLength())));
                }
            }
        }
        return this.reader;
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public String getRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public String getRemoteHost() {
        return this.socket.getInetAddress().getHostName();
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getRequestedSessionId() {
        this.parseCookies();
        if (this.requestedSessionId == null) {
            String sessionCookieName = "org.eclipse.equinox.http.session";
            int numCookies = this.cookies.length;
            int i = 0;
            while (i < numCookies) {
                Cookie cookie = this.cookies[i];
                if (sessionCookieName.equals(cookie.getName())) {
                    this.requestedSessionId = cookie.getValue();
                    break;
                }
                ++i;
            }
        }
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.reqURI;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        if (this.serverName == null) {
            int n;
            String value = this.getHeaderUpper("HOST");
            this.serverName = value != null ? ((n = value.indexOf(58)) < 0 ? value : value.substring(0, n).trim()) : this.socket.getLocalAddress().getHostName();
        }
        return this.serverName;
    }

    public int getServerPort() {
        return this.socket.getLocalPort();
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public synchronized HttpSession getSession(boolean create) {
        if (this.session != null) {
            if (this.session.isValid(false)) {
                return this.session;
            }
            this.session = null;
        } else {
            String sessionId = this.getRequestedSessionId();
            if (sessionId != null) {
                this.session = this.http.getSession(sessionId);
                if (this.session != null) {
                    return this.session;
                }
            }
        }
        if (create) {
            this.session = new HttpSessionImpl(this.http);
            this.response.addCookie(this.session.getCookie());
            return this.session;
        }
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.getRequestedSessionId() != null;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        HttpSession currentSession = this.getSession(false);
        if (currentSession != null) {
            return currentSession.getId().equals(this.getRequestedSessionId());
        }
        return false;
    }

    protected synchronized void parseCookies() {
        block13: {
            block12: {
                String value;
                char c;
                String name;
                Tokenizer tokenizer;
                int cookieVersion;
                Vector<Cookie> cookieVector;
                block14: {
                    if (this.cookies != null) break block13;
                    String cookieHeader = this.getHeaderUpper("COOKIE");
                    if (cookieHeader == null) break block12;
                    cookieVector = new Vector<Cookie>(20);
                    cookieVersion = 0;
                    tokenizer = new Tokenizer(cookieHeader);
                    name = tokenizer.getToken("=");
                    c = tokenizer.getChar();
                    if (!name.equals("$Version")) break block14;
                    if (c != '=') break block12;
                    value = tokenizer.getString(";,");
                    try {
                        cookieVersion = Integer.parseInt(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    name = null;
                }
                while (true) {
                    Cookie cookie;
                    if (name == null) {
                        name = tokenizer.getToken("=");
                        c = tokenizer.getChar();
                    }
                    if (c != '=') break block12;
                    value = tokenizer.getString(";,");
                    c = tokenizer.getChar();
                    try {
                        cookie = new Cookie(name, value);
                    }
                    catch (IllegalArgumentException e) {
                        break block12;
                    }
                    cookie.setVersion(cookieVersion);
                    cookieVector.addElement(cookie);
                    if (c == '\u0000') break;
                    name = tokenizer.getToken("=");
                    c = tokenizer.getChar();
                    if (name.equals("$Path")) {
                        if (c != '=') break block12;
                        cookie.setPath(tokenizer.getString(";,"));
                        c = tokenizer.getChar();
                        if (c == '\u0000') break;
                        name = tokenizer.getToken("=");
                        c = tokenizer.getChar();
                    }
                    if (!name.equals("$Domain")) continue;
                    if (c == '=') {
                        cookie.setDomain(tokenizer.getString(";,"));
                        c = tokenizer.getChar();
                        if (c == '\u0000') break;
                        name = null;
                        continue;
                    }
                    break block12;
                    break;
                }
                if (cookieVector.size() > 0) {
                    this.cookies = new Cookie[cookieVector.size()];
                    cookieVector.copyInto(this.cookies);
                    return;
                }
            }
            this.cookies = new Cookie[0];
        }
    }

    protected void parseHeaders() throws IOException {
        this.headers = new Hashtable(31);
        byte[] buffer = new byte[4096];
        String line = this.readHeaderLine(buffer);
        if (line.length() == 0) {
            throw new InterruptedIOException(HttpMsg.HTTP_NO_HEADER_LINE_READ_EXCEPTION);
        }
        this.socket.markActive();
        this.parseRequestLine(line);
        boolean firstLine = true;
        String header = null;
        StringBuffer value = new StringBuffer(256);
        while (true) {
            if ((line = this.readHeaderLine(buffer)).length() == 0) {
                if (firstLine) break;
                this.headers.put(header, value.toString().trim());
                break;
            }
            char c = line.charAt(0);
            if (c == ' ' || c == '\t') {
                if (firstLine) {
                    throw new IOException(NLS.bind((String)HttpMsg.HTTP_INVALID_HEADER_LINE_EXCEPTION, (Object)line));
                }
                value.append(line.substring(1));
                continue;
            }
            if (!firstLine) {
                this.headers.put(header, value.toString().trim());
                value.setLength(0);
            }
            int colon = line.indexOf(58, 0);
            header = line.substring(0, colon).toUpperCase();
            value.append(line.substring(colon + 1));
            firstLine = false;
        }
    }

    protected synchronized void parseQueryData() {
        if (!this.parsedQueryData) {
            block10: {
                try {
                    int content_length;
                    int index;
                    String content_type;
                    if (this.queryString != null) {
                        if (this.parameters == null) {
                            this.parameters = new Hashtable();
                        }
                        this.parseQueryString(this.parameters, this.queryString, null);
                    }
                    if ((content_type = this.getContentType()) != null && (index = content_type.indexOf(59, 0)) >= 0) {
                        content_type = content_type.substring(0, index).trim();
                    }
                    if (!"POST".equals(this.method) || !"http".equals(this.scheme) && !"https".equals(this.scheme) || !"application/x-www-form-urlencoded".equals(content_type) || (content_length = this.getContentLength()) <= 0) break block10;
                    ServletInputStream in = this.getInputStream();
                    byte[] buffer = new byte[content_length];
                    int bytesRead = 0;
                    while (bytesRead < content_length) {
                        int count;
                        try {
                            count = in.read(buffer, bytesRead, content_length - bytesRead);
                        }
                        catch (IOException iOException) {
                            throw new IllegalArgumentException();
                        }
                        if (count < 1) break;
                        bytesRead += count;
                    }
                    String encoding = this.getCharacterEncoding();
                    String postData = URI.convert(buffer, 0, bytesRead, encoding);
                    if (this.parameters == null) {
                        this.parameters = new Hashtable();
                    }
                    this.parseQueryString(this.parameters, postData, encoding);
                }
                catch (Exception e) {
                    this.http.logError(HttpMsg.HTTP_QUERYDATA_PARSE_EXCEPTION, e);
                }
            }
            this.parsedQueryData = true;
        }
    }

    protected void parseQueryString(Hashtable result, String data, String encoding) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        int len = (data = data.trim()).length();
        if (len >= 0) {
            int begin = 0;
            while (true) {
                String value;
                String key;
                int equals;
                int end;
                if ((end = data.indexOf(38, begin)) == -1) {
                    end = len;
                }
                if ((equals = data.indexOf(61, begin)) >= end || equals == -1) {
                    key = URI.decode(data, begin, end, encoding);
                    value = "";
                } else {
                    key = URI.decode(data, begin, equals, encoding);
                    value = URI.decode(data, equals + 1, end, encoding);
                }
                String[] values = (String[])result.get(key);
                if (values == null) {
                    values = new String[]{value};
                    result.put(key, values);
                } else {
                    int length = values.length;
                    String[] newvalues = new String[length + 1];
                    System.arraycopy(values, 0, newvalues, 0, length);
                    newvalues[length] = value;
                    result.put(key, newvalues);
                }
                if (end == len) break;
                begin = end + 1;
            }
        }
    }

    protected void parseRequestLine(String requestLine) {
        int space = requestLine.indexOf(32, 0);
        this.method = requestLine.substring(0, space);
        int nextspace = requestLine.lastIndexOf(32);
        this.protocol = requestLine.substring(nextspace + 1);
        int query = requestLine.indexOf(63, space + 1);
        if (query >= nextspace || query == -1) {
            this.reqURI = URI.decode(requestLine, space + 1, nextspace, null);
        } else {
            this.reqURI = URI.decode(requestLine, space + 1, query, null);
            this.queryString = requestLine.substring(query + 1, nextspace);
        }
    }

    protected String readHeaderLine(byte[] buffer) throws IOException {
        int read = this.servletInputStream.readLine(buffer, 0, buffer.length);
        if (read <= 0) {
            throw new InterruptedIOException(HttpMsg.HTTP_NO_HEADER_LINE_READ_EXCEPTION);
        }
        String line = URI.convert(buffer, 0, read, null);
        if (line.endsWith("\n")) {
            return line.trim();
        }
        try {
            this.response.sendError(413);
        }
        finally {
            this.response.close();
        }
        throw new IOException(NLS.bind((String)HttpMsg.HTTP_HEADER_LINE_TOO_LONG_EXCEPTION, (Object)new Integer(buffer.length)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object val) {
        if (this.attributes == null) {
            HttpServletRequestImpl httpServletRequestImpl = this;
            synchronized (httpServletRequestImpl) {
                if (this.attributes == null) {
                    this.attributes = new Hashtable(31);
                }
            }
        }
        if (val == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, val);
        }
    }

    public String getContextPath() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public Enumeration getHeaders(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public StringBuffer getRequestURL() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public Principal getUserPrincipal() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public boolean isUserInRole(String role) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public Locale getLocale() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public Enumeration getLocales() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public Map getParameterMap() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public RequestDispatcher getRequestDispatcher(String path) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public boolean isSecure() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public void removeAttribute(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException, UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public String getLocalAddr() {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public String getLocalName() {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }
}

