/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.Http;
import org.eclipse.equinox.http.HttpDate;
import org.eclipse.equinox.http.HttpMsg;
import org.eclipse.equinox.http.SecureAction;
import org.eclipse.equinox.http.Tokenizer;
import org.eclipse.equinox.http.servlet.HttpServletRequestImpl;
import org.eclipse.equinox.http.servlet.ServletOutputStreamImpl;
import org.eclipse.equinox.http.servlet.ServletPrintWriter;
import org.eclipse.equinox.socket.SocketInterface;

public class HttpServletResponseImpl
implements HttpServletResponse {
    private Http http;
    protected HttpServletRequestImpl request;
    private SocketInterface socket;
    protected ServletOutputStreamImpl servletOutputStream;
    protected String charset = null;
    protected static final String defaultCharset = "ISO-8859-1";
    protected int contentLength = 0;
    protected String contentType = null;
    protected Vector cookies = null;
    protected Hashtable headers = null;
    protected int status = 200;
    protected String statusString = "OK";
    private boolean gotOutputStream = false;
    protected PrintWriter writer = null;
    private boolean keepAlive = false;

    public HttpServletResponseImpl(SocketInterface socket, Http http) throws IOException {
        this.http = http;
        this.socket = socket;
        this.servletOutputStream = new ServletOutputStreamImpl(socket.getOutputStream(), this);
    }

    protected void setRequest(HttpServletRequestImpl request) {
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(Cookie cookie) {
        Object object;
        if (this.cookies == null) {
            object = this;
            synchronized (object) {
                if (this.cookies == null) {
                    this.cookies = new Vector(20);
                }
            }
        }
        object = this.cookies;
        synchronized (object) {
            if (!this.cookies.contains(cookie)) {
                this.cookies.addElement(cookie);
            }
        }
    }

    public boolean containsHeader(String name) {
        if (this.headers == null) {
            return false;
        }
        Object value = this.headers.get(name);
        if (value != null) {
            return true;
        }
        Enumeration headerEnumeration = this.headers.keys();
        while (headerEnumeration.hasMoreElements()) {
            String key = (String)headerEnumeration.nextElement();
            if (!name.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeURL(String url) {
        return url;
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
        } else {
            try {
                this.servletOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (!this.keepAlive) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getCharacterEncoding() {
        if (this.charset == null) {
            ByteArrayOutputStream dummy = new ByteArrayOutputStream();
            String fileEncoding = new SecureAction().getProperty("file.encoding", defaultCharset);
            if (fileEncoding == null || fileEncoding.length() < 1) {
                fileEncoding = defaultCharset;
            }
            String fileEncodingAlias = null;
            String accept = this.request.getHeaderUpper("ACCEPT-CHARSET");
            if (accept != null) {
                char c;
                Tokenizer tokenizer = new Tokenizer(accept);
                do {
                    block15: {
                        String acceptCharset;
                        if (!(acceptCharset = tokenizer.getToken(",;")).equals("*")) {
                            try {
                                String encodingAlias = new OutputStreamWriter((OutputStream)dummy, acceptCharset).getEncoding();
                                if (this.charset == null) {
                                    this.charset = acceptCharset;
                                    break block15;
                                }
                                if (fileEncodingAlias == null) {
                                    try {
                                        fileEncodingAlias = new OutputStreamWriter((OutputStream)dummy, fileEncoding).getEncoding();
                                    }
                                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                                }
                                if (encodingAlias.equals(fileEncodingAlias)) {
                                    this.charset = acceptCharset;
                                    break;
                                }
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {}
                        }
                    }
                    if ((c = tokenizer.getChar()) != ';') continue;
                    tokenizer.getToken(",");
                    c = tokenizer.getChar();
                } while (c != '\u0000');
            }
            if (this.charset == null) {
                this.charset = fileEncoding;
                try {
                    new OutputStreamWriter((OutputStream)dummy, this.charset);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.charset = defaultCharset;
                }
            }
        }
        return this.charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletOutputStream getOutputStream() {
        if (!this.gotOutputStream) {
            HttpServletResponseImpl httpServletResponseImpl = this;
            synchronized (httpServletResponseImpl) {
                if (this.writer != null) {
                    throw new IllegalStateException();
                }
                this.gotOutputStream = true;
            }
        }
        return this.servletOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            HttpServletResponseImpl httpServletResponseImpl = this;
            synchronized (httpServletResponseImpl) {
                if (this.writer == null) {
                    if (this.gotOutputStream) {
                        throw new IllegalStateException();
                    }
                    String encoding = this.getCharacterEncoding();
                    this.writer = new ServletPrintWriter(this.servletOutputStream, encoding);
                    if (this.contentType == null) {
                        this.contentType = "text/plain; charset=" + encoding;
                        this.setHeader("Content-Type", this.contentType);
                    } else if (this.contentType.toLowerCase().indexOf("charset=") == -1) {
                        this.contentType = String.valueOf(this.contentType) + "; charset=" + encoding;
                        this.setHeader("Content-Type", this.contentType);
                    }
                }
            }
        }
        return this.writer;
    }

    boolean gotStreamOrWriter() {
        return this.writer != null || this.gotOutputStream;
    }

    public void sendError(int statusCode) throws IOException {
        this.sendError(statusCode, this.http.getStatusPhrase(statusCode));
    }

    public void sendError(int sc, String msg) throws IOException {
        this.status = sc;
        this.statusString = msg;
        this.servletOutputStream.print("<html><body><h3>");
        this.servletOutputStream.print(sc);
        this.servletOutputStream.print(" - ");
        this.servletOutputStream.print(msg);
        this.servletOutputStream.print("</h3></body></html>");
        this.servletOutputStream.close();
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(302);
        this.setHeader("Location", location);
        this.servletOutputStream.close();
    }

    public void setContentLength(int len) {
        this.contentLength = len;
        this.setIntHeader("Content-Length", len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentType(String type) {
        if (this.contentType == null) {
            HttpServletResponseImpl httpServletResponseImpl = this;
            synchronized (httpServletResponseImpl) {
                if (this.contentType == null) {
                    this.contentType = type;
                    this.setHeader("Content-Type", type);
                    int index = type.indexOf(59, 0);
                    if (index >= 0) {
                        char c;
                        Tokenizer tokenizer = new Tokenizer(type);
                        tokenizer.getToken(";");
                        tokenizer.getChar();
                        do {
                            String attribute = tokenizer.getToken("=");
                            c = tokenizer.getChar();
                            if (c != '=') break;
                            String value = tokenizer.getString(";");
                            c = tokenizer.getChar();
                            if (!"charset".equalsIgnoreCase(attribute)) continue;
                            this.charset = value;
                        } while (c != '\u0000');
                    }
                }
            }
        }
    }

    protected void setCookies() {
        if (this.cookies == null) {
            return;
        }
        int numCookies = this.cookies.size();
        if (numCookies > 0) {
            StringBuffer value = new StringBuffer(256);
            int i = 0;
            while (i < numCookies) {
                Cookie cookie = (Cookie)this.cookies.elementAt(i);
                if (i > 0) {
                    value.append(',');
                }
                value.append(cookie.getName());
                value.append("=\"");
                value.append(cookie.getValue());
                value.append('\"');
                if (cookie.getVersion() != 0) {
                    value.append(";Version=");
                    value.append(cookie.getVersion());
                }
                if (cookie.getComment() != null) {
                    value.append(";Comment=\"");
                    value.append(cookie.getComment());
                    value.append('\"');
                }
                if (cookie.getDomain() != null) {
                    value.append(";Domain=\"");
                    value.append(cookie.getDomain());
                    value.append('\"');
                }
                if (cookie.getMaxAge() != -1) {
                    value.append(";Max-Age=\"");
                    value.append(cookie.getMaxAge());
                    value.append('\"');
                }
                if (cookie.getPath() != null) {
                    value.append(";Path=\"");
                    value.append(cookie.getPath());
                    value.append('\"');
                }
                if (cookie.getSecure()) {
                    value.append(";Secure");
                }
                ++i;
            }
            this.setHeader("Set-Cookie", value.toString());
        }
    }

    public void setDateHeader(String name, long date) {
        HttpDate d = new HttpDate(date);
        this.setHeader(name, d.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String name, String value) {
        if (this.headers == null) {
            HttpServletResponseImpl httpServletResponseImpl = this;
            synchronized (httpServletResponseImpl) {
                if (this.headers == null) {
                    this.headers = new Hashtable(31);
                }
            }
        }
        this.headers.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void setStatus(int statusCode) {
        this.status = statusCode;
        this.statusString = this.http.getStatusPhrase(statusCode);
    }

    public void setStatus(int si, String ss) {
        this.status = si;
        this.statusString = ss;
    }

    void writeHeaders(int length) throws IOException {
        String requestConnection;
        this.setCookies();
        if (length != -1 && !this.containsHeader("Content-Length")) {
            this.setContentLength(length);
        }
        if (this.containsHeader("Content-Length") && (requestConnection = this.request.getHeaderUpper("CONNECTION")) != null && requestConnection.toLowerCase().indexOf("keep-alive") >= 0) {
            this.setHeader("Connection", "Keep-Alive");
            this.keepAlive = true;
        }
        if (!this.keepAlive) {
            this.setHeader("Connection", "close");
        }
        this.servletOutputStream.print("HTTP/1.0 ");
        this.servletOutputStream.print(this.status);
        this.servletOutputStream.print(" ");
        this.servletOutputStream.println(this.statusString);
        if (this.headers != null) {
            Enumeration headerEnumeration = this.headers.keys();
            while (headerEnumeration.hasMoreElements()) {
                String name = (String)headerEnumeration.nextElement();
                String value = (String)this.headers.get(name);
                this.servletOutputStream.print(name);
                this.servletOutputStream.print(": ");
                this.servletOutputStream.println(value);
            }
        }
        this.servletOutputStream.println();
    }

    public void addDateHeader(String name, long date) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public void addHeader(String name, String value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public void addIntHeader(String name, int value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public void flushBuffer() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public int getBufferSize() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public Locale getLocale() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public boolean isCommitted() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public void reset() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public void resetBuffer() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public void setBufferSize(int size) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public void setLocale(Locale loc) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public String getContentType() {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public void setCharacterEncoding(String arg0) {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }
}

