/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFrameworkFactory;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.shell.internal.util.ServiceHolder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class QuasiServiceUtil {
    private QuasiFrameworkFactory quasiFrameworkFactory;
    private BundleContext bundleContext;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public QuasiServiceUtil(BundleContext bundleContext, QuasiFrameworkFactory quasiFrameworkFactory) {
        this.bundleContext = bundleContext.getBundle(0L).getBundleContext();
        this.quasiFrameworkFactory = quasiFrameworkFactory;
    }

    public ServiceHolder getService(long serviceId) {
        SortedMap<Long, ServiceHolder> services = this.getServicesSortedMap();
        return (ServiceHolder)services.get(serviceId);
    }

    public List<ServiceHolder> getAllServices() {
        ArrayList<ServiceHolder> quasiLiveServices = new ArrayList<ServiceHolder>();
        SortedMap<Long, ServiceHolder> services = this.getServicesSortedMap();
        for (Map.Entry<Long, ServiceHolder> serviceEntry : services.entrySet()) {
            quasiLiveServices.add(serviceEntry.getValue());
        }
        return quasiLiveServices;
    }

    private SortedMap<Long, ServiceHolder> getServicesSortedMap() {
        TreeMap<Long, ServiceHolder> services = new TreeMap<Long, ServiceHolder>();
        ServiceReference[] allServiceReferences = null;
        try {
            allServiceReferences = this.bundleContext.getAllServiceReferences(null, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return services;
        }
        if (allServiceReferences == null) {
            return services;
        }
        ServiceReference[] serviceReferenceArray = allServiceReferences;
        int n = allServiceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference serviceReference = serviceReferenceArray[n2];
            ServiceHolder service = new ServiceHolder(this.quasiFrameworkFactory.create(), serviceReference);
            services.put(service.getServiceId(), service);
            ++n2;
        }
        return services;
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.shell.internal.util.QuasiServiceUtil");
    }
}

