/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.equinox.internal.cm.ConfigurationAdminFactory;
import org.eclipse.equinox.internal.cm.ConfigurationDictionary;
import org.eclipse.equinox.internal.cm.ConfigurationStore;
import org.osgi.framework.Bundle;
import org.osgi.service.cm.Configuration;

class ConfigurationImpl
implements Configuration {
    private final ConfigurationAdminFactory configurationAdminFactory;
    private final ConfigurationStore configurationStore;
    private String bundleLocation;
    private final String factoryPid;
    private final String pid;
    private ConfigurationDictionary dictionary;
    private boolean deleted = false;
    private Bundle boundBundle;
    private int lockedCount = 0;
    private Thread lockHolder = null;

    public ConfigurationImpl(ConfigurationAdminFactory configurationAdminFactory, ConfigurationStore configurationStore, String factoryPid, String pid, String bundleLocation) {
        this.configurationAdminFactory = configurationAdminFactory;
        this.configurationStore = configurationStore;
        this.factoryPid = factoryPid;
        this.pid = pid;
        this.bundleLocation = bundleLocation;
    }

    public ConfigurationImpl(ConfigurationAdminFactory configurationAdminFactory, ConfigurationStore configurationStore, Dictionary dictionary) {
        this.configurationAdminFactory = configurationAdminFactory;
        this.configurationStore = configurationStore;
        this.pid = (String)dictionary.get("service.pid");
        this.factoryPid = (String)dictionary.get("service.factoryPid");
        this.bundleLocation = (String)dictionary.get("service.bundleLocation");
        this.updateDictionary(dictionary);
    }

    /*
     * Exception decompiling
     */
    protected synchronized void lock() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected synchronized void unlock() {
        Thread current = Thread.currentThread();
        if (this.lockHolder != current) {
            throw new IllegalStateException("Thread not lock owner");
        }
        --this.lockedCount;
        if (this.lockedCount == 0) {
            this.lockHolder = null;
            this.notify();
        }
    }

    protected synchronized void checkLocked() {
        Thread current = Thread.currentThread();
        if (this.lockHolder != current) {
            throw new IllegalStateException("Thread not lock owner");
        }
    }

    protected boolean bind(Bundle bundle) {
        try {
            this.lock();
            if (this.boundBundle == null && (this.bundleLocation == null || this.bundleLocation.equals(bundle.getLocation()))) {
                this.boundBundle = bundle;
            }
            boolean bl = this.boundBundle == bundle;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    protected void unbind(Bundle bundle) {
        try {
            this.lock();
            if (this.boundBundle == bundle) {
                this.boundBundle = null;
            }
        }
        finally {
            this.unlock();
        }
    }

    public void delete() throws IOException {
        try {
            this.lock();
            this.checkDeleted();
            this.deleted = true;
            this.configurationAdminFactory.notifyConfigurationDeleted(this, this.factoryPid != null);
            this.configurationAdminFactory.dispatchEvent(2, this.factoryPid, this.pid);
        }
        finally {
            this.unlock();
        }
        this.configurationStore.removeConfiguration(this.pid);
    }

    private void checkDeleted() {
        if (this.deleted) {
            throw new IllegalStateException("deleted");
        }
    }

    public String getBundleLocation() {
        return this.getBundleLocation(true);
    }

    protected String getBundleLocation(boolean checkPermission) {
        try {
            this.lock();
            this.checkDeleted();
            if (checkPermission) {
                this.configurationAdminFactory.checkConfigurationPermission();
            }
            if (this.bundleLocation != null) {
                String string = this.bundleLocation;
                return string;
            }
            if (this.boundBundle != null) {
                String string = this.boundBundle.getLocation();
                return string;
            }
            return null;
        }
        finally {
            this.unlock();
        }
    }

    protected String getFactoryPid(boolean checkDeleted) {
        try {
            this.lock();
            if (checkDeleted) {
                this.checkDeleted();
            }
            String string = this.factoryPid;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    public String getFactoryPid() {
        return this.getFactoryPid(true);
    }

    protected String getPid(boolean checkDeleted) {
        try {
            this.lock();
            if (checkDeleted) {
                this.checkDeleted();
            }
            String string = this.pid;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    public String getPid() {
        return this.getPid(true);
    }

    public Dictionary getProperties() {
        try {
            this.lock();
            this.checkDeleted();
            if (this.dictionary == null) {
                return null;
            }
            ConfigurationDictionary copy = this.dictionary.copy();
            ((Dictionary)copy).put("service.pid", this.pid);
            if (this.factoryPid != null) {
                ((Dictionary)copy).put("service.factoryPid", this.factoryPid);
            }
            ConfigurationDictionary configurationDictionary = copy;
            return configurationDictionary;
        }
        finally {
            this.unlock();
        }
    }

    protected Dictionary getAllProperties() {
        try {
            this.lock();
            if (this.deleted) {
                return null;
            }
            Dictionary copy = this.getProperties();
            if (copy == null) {
                return null;
            }
            String boundLocation = this.getBundleLocation(false);
            if (boundLocation != null) {
                copy.put("service.bundleLocation", boundLocation);
            }
            Dictionary dictionary = copy;
            return dictionary;
        }
        finally {
            this.unlock();
        }
    }

    public void setBundleLocation(String bundleLocation) {
        try {
            this.lock();
            this.checkDeleted();
            this.configurationAdminFactory.checkConfigurationPermission();
            this.bundleLocation = bundleLocation;
            this.boundBundle = null;
        }
        finally {
            this.unlock();
        }
    }

    public void update() throws IOException {
        try {
            this.lock();
            this.checkDeleted();
            if (this.dictionary == null) {
                this.dictionary = new ConfigurationDictionary();
            }
            this.configurationStore.saveConfiguration(this.pid, this);
            this.configurationAdminFactory.notifyConfigurationUpdated(this, this.factoryPid != null);
        }
        finally {
            this.unlock();
        }
    }

    public void update(Dictionary properties) throws IOException {
        try {
            this.lock();
            this.checkDeleted();
            this.updateDictionary(properties);
            this.configurationStore.saveConfiguration(this.pid, this);
            this.configurationAdminFactory.notifyConfigurationUpdated(this, this.factoryPid != null);
            this.configurationAdminFactory.dispatchEvent(1, this.factoryPid, this.pid);
        }
        finally {
            this.unlock();
        }
    }

    private void updateDictionary(Dictionary properties) {
        ConfigurationDictionary newDictionary = new ConfigurationDictionary();
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (newDictionary.get(key) == null) {
                Object value = properties.get(key);
                if (value.getClass().isArray()) {
                    int arrayLength = Array.getLength(value);
                    Object copyOfArray = Array.newInstance(value.getClass().getComponentType(), arrayLength);
                    System.arraycopy(value, 0, copyOfArray, 0, arrayLength);
                    newDictionary.put(key, copyOfArray);
                    continue;
                }
                if (value instanceof Collection) {
                    newDictionary.put(key, new Vector((Collection)value));
                    continue;
                }
                newDictionary.put(key, properties.get(key));
                continue;
            }
            throw new IllegalArgumentException(key + " is already present or is a case variant.");
        }
        newDictionary.remove("service.pid");
        newDictionary.remove("service.factoryPid");
        newDictionary.remove("service.bundleLocation");
        this.dictionary = newDictionary;
    }

    public boolean equals(Object obj) {
        return obj instanceof Configuration && this.pid.equals(((Configuration)obj).getPid());
    }

    public int hashCode() {
        return this.pid.hashCode();
    }

    protected boolean isDeleted() {
        try {
            this.lock();
            boolean bl = this.deleted;
            return bl;
        }
        finally {
            this.unlock();
        }
    }
}

