/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.internal.bundle;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.virgo.kernel.model.Artifact;
import org.eclipse.virgo.kernel.model.RuntimeArtifactRepository;
import org.eclipse.virgo.kernel.model.internal.DependencyDeterminer;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFramework;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFrameworkFactory;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiRequiredBundle;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;

public final class BundleDependencyDeterminer
implements DependencyDeterminer {
    private final QuasiFrameworkFactory quasiFrameworkFactory;
    private final RuntimeArtifactRepository artifactRepository;
    private final RegionDigraph regionDigraph;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public BundleDependencyDeterminer(@NonNull QuasiFrameworkFactory quasiFrameworkFactory, @NonNull RuntimeArtifactRepository artifactRepository, @NonNull RegionDigraph regionDigraph) {
        RegionDigraph regionDigraph2 = regionDigraph;
        RuntimeArtifactRepository runtimeArtifactRepository = artifactRepository;
        QuasiFrameworkFactory quasiFrameworkFactory2 = quasiFrameworkFactory;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)quasiFrameworkFactory2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)runtimeArtifactRepository);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)regionDigraph2);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.quasiFrameworkFactory = quasiFrameworkFactory;
            this.artifactRepository = artifactRepository;
            this.regionDigraph = regionDigraph;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Set<Artifact> getDependents(Artifact rootArtifact) {
        try {
            if (!rootArtifact.getType().equalsIgnoreCase("bundle")) {
                return Collections.emptySet();
            }
            QuasiBundle rootBundle = this.getBundle(rootArtifact);
            if (rootBundle == null) {
                return Collections.emptySet();
            }
            HashSet<Artifact> artifacts = new HashSet<Artifact>();
            for (QuasiImportPackage importPackage : rootBundle.getImportPackages()) {
                QuasiExportPackage provider = importPackage.getProvider();
                if (provider == null) continue;
                QuasiBundle bundle = provider.getExportingBundle();
                this.addDependentBundle(artifacts, bundle);
            }
            this.addDependents(artifacts, rootBundle.getHosts());
            List requiredBundles = rootBundle.getRequiredBundles();
            if (requiredBundles != null) {
                for (QuasiRequiredBundle requiredBundle : requiredBundles) {
                    this.addDependentBundle(artifacts, requiredBundle.getProvider());
                }
            }
            return artifacts;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void addDependents(Set<Artifact> artifacts, List<QuasiBundle> dependents) {
        try {
            try {
                BundleDependencyDeterminer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                if (dependents != null) {
                    for (QuasiBundle dependent : dependents) {
                        this.addDependentBundle(artifacts, dependent);
                    }
                }
                BundleDependencyDeterminer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                BundleDependencyDeterminer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void addDependentBundle(Set<Artifact> artifacts, QuasiBundle bundle) {
        try {
            try {
                BundleDependencyDeterminer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                if (bundle != null) {
                    Artifact artifact = this.artifactRepository.getArtifact("bundle", bundle.getSymbolicName(), bundle.getVersion(), this.regionDigraph.getRegion(bundle.getBundleId()));
                    artifacts.add(artifact);
                }
                BundleDependencyDeterminer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                BundleDependencyDeterminer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private QuasiBundle getBundle(Artifact artifact) {
        try {
            QuasiFramework framework = this.quasiFrameworkFactory.create();
            for (QuasiBundle bundle : framework.getBundles()) {
                if (!artifact.getName().equals(bundle.getSymbolicName()) || !artifact.getVersion().equals((Object)bundle.getVersion()) || !artifact.getRegion().getName().equals(this.regionDigraph.getRegion(bundle.getBundleId()).getName())) continue;
                return bundle;
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("BundleDependencyDeterminer.java", Class.forName("org.eclipse.virgo.kernel.model.internal.bundle.BundleDependencyDeterminer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addDependents", "org.eclipse.virgo.kernel.model.internal.bundle.BundleDependencyDeterminer", "java.util.Set:java.util.List:", "artifacts:dependents:", "", "void"), 91);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addDependentBundle", "org.eclipse.virgo.kernel.model.internal.bundle.BundleDependencyDeterminer", "java.util.Set:org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle:", "artifacts:bundle:", "", "void"), 99);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.model.internal.bundle.BundleDependencyDeterminer");
    }
}

