/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;

public class XmlSerializer {
    private Writer writer;
    private Vector stack;
    private StringWriter attrsWriter;
    private StringBuffer attrs;
    private boolean empty;
    private boolean closed;
    private String indentString;
    private boolean prologWritten;

    public XmlSerializer setOutput(Writer writer) {
        this.writer = writer;
        this.closed = true;
        this.prologWritten = false;
        if (this.stack == null) {
            this.stack = new Vector(5);
        } else {
            this.stack.removeAllElements();
        }
        if (this.attrs != null) {
            this.attrs.setLength(0);
        }
        return this;
    }

    public void setOutput(OutputStream os, String encoding) throws IOException {
        if (os == null) {
            throw new NullPointerException("output stream can not be null");
        }
        OutputStreamWriter writer = encoding != null ? new OutputStreamWriter(os, encoding) : new OutputStreamWriter(os);
        this.setOutput(writer);
    }

    public XmlSerializer startDocument(String encoding, Boolean standalone) throws IOException {
        if (this.prologWritten) {
            throw new IllegalStateException("Prolog already written");
        }
        this.writer.write("<?xml version=\"1.0\"");
        if (encoding != null) {
            this.writer.write(" encoding=\"");
            this.writer.write(encoding);
            this.writer.write("\"");
        }
        if (standalone != null) {
            this.writer.write(" standalone=\"");
            this.writer.write(standalone != false ? "yes" : "no");
            this.writer.write("\"");
        }
        this.writer.write("?>");
        this.prologWritten = true;
        return this;
    }

    public void endDocument() {
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException("Tags are not all closed. Possibly, '" + this.pop() + "' is unclosed. ");
        }
    }

    public int getDepth() {
        return this.stack.size();
    }

    public XmlSerializer startTag(String name) throws IOException {
        if (!this.prologWritten) {
            this.startDocument(null, null);
        }
        this.closeOpeningTag();
        this.closed = false;
        this.indent();
        this.writer.write("<");
        this.writer.write(name);
        this.stack.addElement(name);
        this.empty = true;
        return this;
    }

    public XmlSerializer endTag() throws IOException {
        return this.endTag(null);
    }

    public XmlSerializer endTag(String aName) throws IOException {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Called endEntity too many times.");
        }
        String name = this.pop();
        if (name != null) {
            if (aName != null && !aName.equals(name)) {
                throw new IllegalArgumentException("Expected element name '" + name + "', not '" + aName + "'");
            }
            if (this.empty) {
                this.writeAttributes();
                this.writer.write("/>");
            } else {
                this.indent();
                this.writer.write("</");
                this.writer.write(name);
                this.writer.write(">");
            }
            this.empty = false;
        }
        return this;
    }

    public XmlSerializer attribute(String localName, String value) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Opening tag is already closed");
        }
        if (localName == null) {
            throw new IllegalArgumentException("Attribute name is null");
        }
        if (value == null) {
            value = "";
        }
        if (this.attrsWriter == null) {
            this.attrsWriter = new StringWriter();
            this.attrs = this.attrsWriter.getBuffer();
        }
        this.attrs.append(" ");
        this.attrs.append(localName);
        this.attrs.append("=\"");
        this.writeEscape(value, this.attrsWriter);
        this.attrs.append("\"");
        return this;
    }

    public XmlSerializer text(String text) throws IOException {
        this.closeOpeningTag();
        if (text != null && text.length() > 0) {
            this.indent();
            this.empty = false;
            this.writeEscape(text, this.writer);
        }
        return this;
    }

    public XmlSerializer cdsect(String text) throws IOException {
        this.closeOpeningTag();
        this.writer.write("<![CDATA[");
        this.writer.write(text);
        this.writer.write("]]>");
        return this;
    }

    public XmlSerializer comment(String text) throws IOException {
        this.closeOpeningTag();
        this.writer.write("<!--");
        this.writer.write(text);
        this.writer.write("-->");
        return this;
    }

    public XmlSerializer docdecl(String text) throws IOException {
        if (!this.prologWritten) {
            throw new IllegalStateException("Document is not open");
        }
        if (this.getDepth() != 0) {
            throw new IllegalStateException("Cannot add DOCTYPE after start tag has been opened!");
        }
        this.closeOpeningTag();
        this.writer.write("<!DOCTYPE");
        this.writer.write(text);
        this.writer.write(">");
        return this;
    }

    public void setIndent(boolean indent) {
        this.indentString = indent ? "\t" : null;
    }

    private void closeOpeningTag() throws IOException {
        if (!this.closed) {
            this.writeAttributes();
            this.closed = true;
            this.writer.write(">");
        }
    }

    private void writeAttributes() throws IOException {
        if (this.attrs != null) {
            this.writer.write(this.attrs.toString());
            this.attrs.setLength(0);
            this.empty = false;
        }
    }

    private final String pop() {
        int location = this.stack.size() - 1;
        String ret = (String)this.stack.elementAt(location);
        this.stack.removeElementAt(location);
        return ret;
    }

    private final void indent() throws IOException {
        if (this.indentString != null) {
            this.writer.write(10);
            int i = 0;
            while (i < this.stack.size()) {
                this.writer.write(this.indentString);
                ++i;
            }
        }
    }

    private final void writeEscape(String text, Writer out) throws IOException {
        char[] buf = text.toCharArray();
        int len = buf.length;
        int pos = 0;
        int i = 0;
        while (i < len) {
            char ch = buf[i];
            if (ch == '&') {
                if (i > pos) {
                    out.write(buf, pos, i - pos);
                }
                out.write("&amp;");
                pos = i + 1;
            } else if (ch == '<') {
                if (i > pos) {
                    out.write(buf, pos, i - pos);
                }
                out.write("&lt;");
                pos = i + 1;
            } else if (ch == '>') {
                if (i > pos) {
                    out.write(buf, pos, i - pos);
                }
                out.write("&gt;");
                pos = i + 1;
            } else if (ch == '\"') {
                if (i > pos) {
                    out.write(buf, pos, i - pos);
                }
                out.write("&guot;");
                pos = i + 1;
            } else if (ch == '\'') {
                if (i > pos) {
                    out.write(buf, pos, i - pos);
                }
                out.write("&apos;");
                pos = i + 1;
            } else if (ch < ' ' && ch != '\t' && ch != '\n' && ch != '\r') {
                throw new IllegalStateException("character " + ch + " (" + Integer.toString(ch) + ") is not allowed in output");
            }
            ++i;
        }
        if (len > pos) {
            out.write(buf, pos, len - pos);
        }
    }
}

