/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.common;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.felix.service.command.CommandSession;
import org.eclipse.equinox.console.common.ConsoleInputStream;
import org.eclipse.equinox.console.common.HistoryHolder;
import org.eclipse.equinox.console.common.KEYS;
import org.eclipse.equinox.console.common.Scanner;
import org.eclipse.equinox.console.common.SimpleByteBuffer;
import org.eclipse.equinox.console.completion.CompletionHandler;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleInputScanner
extends Scanner {
    private static final byte TAB = 9;
    private boolean isCR = false;
    private boolean replace = false;
    private boolean isCompletionMode = false;
    private boolean isHistoryEnabled = true;
    private final HistoryHolder history = new HistoryHolder();
    private final SimpleByteBuffer buffer = new SimpleByteBuffer();
    private CommandSession session;
    private BundleContext context;
    private Candidates candidates;
    private int originalCursorPos;
    private static final byte[] INVERSE_ON = new byte[]{27, 91, 55, 109};
    private static final byte[] INVERSE_OFF = new byte[]{27, 91, 50, 55, 109};

    public ConsoleInputScanner(ConsoleInputStream toShell, OutputStream toTelnet) {
        super(toShell, toTelnet);
    }

    public void toggleHistoryEnabled(boolean isEnabled) {
        this.isHistoryEnabled = isEnabled;
    }

    public void setSession(CommandSession session) {
        this.session = session;
    }

    public void setContext(BundleContext context) {
        this.context = context;
    }

    @Override
    public void scan(int b) throws IOException {
        b &= 0xFF;
        if (this.isCR) {
            this.isCR = false;
            if (b == 10) {
                return;
            }
        }
        if (b != 9 && this.isCompletionMode) {
            this.isCompletionMode = false;
            this.candidates = null;
            this.originalCursorPos = 0;
        }
        if (this.isEsc) {
            this.scanEsc(b);
        } else if (b == this.getBackspace()) {
            this.backSpace();
        } else if (b == 9) {
            if (!this.isCompletionMode) {
                this.isCompletionMode = true;
                this.processTab();
            } else {
                this.processNextTab();
            }
        } else if (b == 13) {
            this.isCR = true;
            this.processData();
        } else if (b == 10) {
            this.processData();
        } else if (b == 27) {
            this.startEsc();
        } else if (b == this.getDel()) {
            this.delete();
        } else if (b >= 32 && b < 127) {
            this.newChar(b);
        }
    }

    private void delete() throws IOException {
        this.clearLine();
        this.buffer.delete();
        this.echoBuff();
        this.flush();
    }

    private void backSpace() throws IOException {
        this.clearLine();
        this.buffer.backSpace();
        this.echoBuff();
        this.flush();
    }

    protected void clearLine() throws IOException {
        int size = this.buffer.getSize();
        int pos = this.buffer.getPos();
        int i = size - pos;
        while (i < size) {
            this.echo(8);
            ++i;
        }
        i = 0;
        while (i < size) {
            this.echo(32);
            ++i;
        }
        i = 0;
        while (i < size) {
            this.echo(8);
            ++i;
        }
    }

    protected void echoBuff() throws IOException {
        byte[] data;
        byte[] byArray = data = this.buffer.copyCurrentData();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            this.echo(b);
            ++n2;
        }
        int pos = this.buffer.getPos();
        int i = data.length;
        while (i > pos) {
            this.echo(8);
            --i;
        }
    }

    protected void newChar(int b) throws IOException {
        if (this.buffer.getPos() < this.buffer.getSize()) {
            if (this.replace) {
                this.buffer.replace(b);
            } else {
                this.buffer.insert(b);
            }
            this.clearLine();
            this.echoBuff();
            this.flush();
        } else if (this.replace) {
            this.buffer.replace(b);
        } else {
            this.buffer.insert(b);
        }
    }

    protected void processTab() throws IOException {
        CompletionHandler completionHandler = new CompletionHandler(this.context, this.session);
        Map<String, Integer> completionCandidates = completionHandler.getCandidates(this.buffer.copyCurrentData(), this.buffer.getPos());
        if (completionCandidates.size() == 1) {
            this.completeSingleCandidate(completionCandidates);
            this.isCompletionMode = false;
            return;
        }
        this.printNewLine();
        if (completionCandidates.size() == 0) {
            this.printCompletionError();
            this.isCompletionMode = false;
        } else {
            this.processCandidates(completionCandidates);
        }
        this.printNewLine();
        this.printPrompt();
    }

    protected void processCandidates(Map<String, Integer> completionCandidates) throws IOException {
        Set<String> candidatesNamesSet = completionCandidates.keySet();
        String[] candidatesNames = candidatesNamesSet.toArray(new String[0]);
        this.originalCursorPos = this.buffer.getPos();
        String[] candidateSuffixes = new String[candidatesNames.length];
        int i = 0;
        while (i < candidatesNames.length) {
            String candidateName = candidatesNames[i];
            candidateSuffixes[i] = this.getCandidateSuffix(candidateName, completionCandidates.get(candidateName), this.originalCursorPos);
            byte[] byArray = candidateName.getBytes();
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte symbol = byArray[n2];
                this.echo(symbol);
                ++n2;
            }
            this.printNewLine();
            ++i;
        }
        String commonPrefix = this.getCommonPrefix(candidateSuffixes);
        this.candidates = new Candidates(this.removeCommonPrefix(candidateSuffixes, commonPrefix));
        this.printString(commonPrefix, false);
        this.originalCursorPos = this.buffer.getPos();
    }

    /*
     * Unable to fully structure code
     */
    protected void processNextTab() throws IOException {
        if (this.candidates != null) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.backSpace();
lbl4:
            // 2 sources

            ** while (this.originalCursorPos < this.buffer.getPos())
        }
lbl5:
        // 1 sources

        candidate = this.candidates.getCurrent();
        if (!candidate.equals("")) {
            this.printString(candidate, true);
        }
    }

    protected void printCandidate(String candidate, int startIndex, int completionIndex) throws IOException {
        String suffix = this.getCandidateSuffix(candidate, startIndex, completionIndex);
        if (suffix.equals("")) {
            return;
        }
        this.printString(suffix, true);
    }

    protected void printString(String st, boolean isEcho) throws IOException {
        byte[] byArray = st.getBytes();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte symbol = byArray[n2];
            this.buffer.insert(symbol);
            if (isEcho) {
                this.echo(symbol);
            }
            ++n2;
        }
        this.flush();
    }

    protected String getCommonPrefix(String[] names) {
        char[] name;
        if (names.length == 0) {
            return "";
        }
        if (names.length == 1) {
            return names[0];
        }
        StringBuilder builder = new StringBuilder();
        char[] cArray = name = names[0].toCharArray();
        int n = name.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            String prefix = builder.append(c).toString();
            int i = 1;
            while (i < names.length) {
                if (!names[i].startsWith(prefix)) {
                    return prefix.substring(0, prefix.length() - 1);
                }
                ++i;
            }
            ++n2;
        }
        return builder.toString();
    }

    protected String[] removeCommonPrefix(String[] names, String commonPrefix) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String nameWithoutPrefix = name.substring(commonPrefix.length());
            if (nameWithoutPrefix.length() > 0) {
                result.add(nameWithoutPrefix);
            }
            ++n2;
        }
        result.add("");
        return result.toArray(new String[0]);
    }

    protected String getCandidateSuffix(String candidate, int startIndex, int completionIndex) {
        int partialLength = completionIndex - startIndex;
        if (partialLength >= candidate.length()) {
            return "";
        }
        return candidate.substring(partialLength);
    }

    protected void completeSingleCandidate(Map<String, Integer> completionCandidates) throws IOException {
        Set<String> keys = completionCandidates.keySet();
        String key = keys.toArray(new String[0])[0];
        int startIndex = completionCandidates.get(key);
        this.printCandidate(key, startIndex, this.buffer.getPos());
    }

    protected void printCompletionError() throws IOException {
        byte[] curr = this.buffer.getCurrentData();
        if (this.isHistoryEnabled) {
            this.history.add(curr);
        }
        String errorMessage = "No completion available";
        byte[] byArray = errorMessage.getBytes();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte symbol = byArray[n2];
            this.echo(symbol);
            ++n2;
        }
    }

    protected void printNewLine() throws IOException {
        this.echo(13);
        this.echo(10);
        this.flush();
    }

    protected void printPrompt() throws IOException {
        this.echo(111);
        this.echo(115);
        this.echo(103);
        this.echo(105);
        this.echo(62);
        this.echo(32);
        this.echoBuff();
        this.flush();
    }

    private void processData() throws IOException {
        this.buffer.add(10);
        this.echo(13);
        this.echo(10);
        this.flush();
        byte[] curr = this.buffer.getCurrentData();
        if (this.isHistoryEnabled) {
            this.history.add(curr);
        }
        this.toShell.add(curr);
    }

    public void resetHistory() {
        this.history.reset();
    }

    @Override
    protected void scanEsc(int b) throws IOException {
        this.esc = String.valueOf(this.esc) + (char)b;
        KEYS key = this.checkEscape(this.esc);
        if (key == KEYS.UNFINISHED) {
            return;
        }
        if (key == KEYS.UNKNOWN) {
            this.isEsc = false;
            this.scan(b);
            return;
        }
        this.isEsc = false;
        switch (key) {
            case UP: {
                this.processUpArrow();
                break;
            }
            case DOWN: {
                this.processDownArrow();
                break;
            }
            case RIGHT: {
                this.processRightArrow();
                break;
            }
            case LEFT: {
                this.processLeftArrow();
                break;
            }
            case HOME: {
                this.processHome();
                break;
            }
            case END: {
                this.processEnd();
                break;
            }
            case PGUP: {
                this.processPgUp();
                break;
            }
            case PGDN: {
                this.processPgDn();
                break;
            }
            case INS: {
                this.processIns();
                break;
            }
            case DEL: {
                this.delete();
                break;
            }
        }
    }

    private void echo(byte[] data) throws IOException {
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            this.echo(b);
            ++n2;
        }
    }

    private void processIns() throws IOException {
        this.replace = !this.replace;
        int b = this.buffer.getCurrentChar();
        this.echo(INVERSE_ON);
        this.echo(this.replace ? 82 : 73);
        this.flush();
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {}
        this.echo(INVERSE_OFF);
        this.echo(8);
        this.echo(b == -1 ? 32 : b);
        this.echo(8);
        this.flush();
    }

    private void processPgDn() throws IOException {
        byte[] last = this.history.last();
        if (last != null) {
            this.clearLine();
            this.buffer.set(last);
            this.echoBuff();
            this.flush();
        }
    }

    private void processPgUp() throws IOException {
        byte[] first = this.history.first();
        if (first != null) {
            this.clearLine();
            this.buffer.set(first);
            this.echoBuff();
            this.flush();
        }
    }

    private void processHome() throws IOException {
        int pos = this.buffer.resetPos();
        if (pos > 0) {
            int i = 0;
            while (i < pos) {
                this.echo(8);
                ++i;
            }
            this.flush();
        }
    }

    private void processEnd() throws IOException {
        int b;
        while ((b = this.buffer.goRight()) != -1) {
            this.echo(b);
        }
        this.flush();
    }

    private void processLeftArrow() throws IOException {
        if (this.buffer.goLeft()) {
            this.echo(8);
            this.flush();
        }
    }

    private void processRightArrow() throws IOException {
        int b = this.buffer.goRight();
        if (b != -1) {
            this.echo(b);
            this.flush();
        }
    }

    private void processDownArrow() throws IOException {
        byte[] next = this.history.next();
        if (next != null) {
            this.clearLine();
            this.buffer.set(next);
            this.echoBuff();
            this.flush();
        }
    }

    private void processUpArrow() throws IOException {
        this.clearLine();
        byte[] prev = this.history.prev();
        this.buffer.set(prev);
        this.echoBuff();
        this.flush();
    }

    private static class Candidates {
        private String[] candidates;
        private int currentCandidateIndex = 0;

        public Candidates(String[] candidates) {
            this.candidates = (String[])candidates.clone();
        }

        public String getCurrent() {
            if (this.currentCandidateIndex >= this.candidates.length) {
                this.currentCandidateIndex = 0;
            }
            return this.candidates[this.currentCandidateIndex++];
        }
    }
}

