/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.artifact.fs;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSFactory;
import org.eclipse.virgo.kernel.artifact.fs.internal.DirectoryArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.internal.FileArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.internal.JarFileArtifactFS;

public final class StandardArtifactFSFactory
implements ArtifactFSFactory {
    private static final List<String> JAR_EXTENSIONS = Arrays.asList("jar", "war");

    @Override
    public ArtifactFS create(File file) {
        if (file.isDirectory()) {
            return new DirectoryArtifactFS(file);
        }
        return this.looksLikeAJar(file.getName()) ? new JarFileArtifactFS(file) : new FileArtifactFS(file);
    }

    private boolean looksLikeAJar(String name) {
        String fileName = name.toLowerCase(Locale.ENGLISH);
        int dotLocation = fileName.lastIndexOf(46);
        if (dotLocation == -1) {
            return false;
        }
        return JAR_EXTENSIONS.contains(fileName.substring(dotLocation + 1));
    }
}

