/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import org.eclipse.equinox.http.Http;
import org.eclipse.equinox.http.HttpMsg;
import org.eclipse.equinox.http.HttpThread;
import org.eclipse.osgi.util.NLS;

public class HttpThreadPool
extends ThreadGroup {
    final Http http;
    private final Vector idleThreads;
    private final Vector activeThreads;
    private int upper;
    private int lower;
    private volatile int priority;
    private int hitCount;
    private int number;
    private int adjusting = 0;

    public HttpThreadPool(Http http, int lower, int upper, int priority) {
        super("Http Service Thread Pool");
        this.http = http;
        this.idleThreads = new Vector(upper);
        this.activeThreads = new Vector(upper);
        this.number = 0;
        this.setSize(lower, upper);
        this.setPriority(priority);
    }

    public synchronized int getLowerSizeLimit() {
        return this.lower;
    }

    public synchronized int getUpperSizeLimit() {
        return this.upper;
    }

    public synchronized void setSize(int lower, int upper) {
        this.lower = lower;
        this.upper = upper;
        this.adjustThreadCount();
    }

    private void adjustThreadCount() {
        int delta;
        if (this.adjusting > 0) {
            --this.adjusting;
            return;
        }
        int active = this.activeThreads.size();
        int idle = this.idleThreads.size();
        int count = idle + active;
        if (idle < 2) {
            count += 5;
        } else if (idle > 10) {
            count -= 5;
        }
        if (count > this.upper) {
            count = this.upper;
        }
        if (count < this.lower) {
            count = this.lower;
        }
        if ((delta = count - (idle + active)) < 0) {
            if ((delta = -delta) < idle) {
                int i = idle - 1;
                while (delta > 0) {
                    HttpThread thread = (HttpThread)this.idleThreads.elementAt(i);
                    this.idleThreads.removeElementAt(i);
                    thread.close();
                    --i;
                    --delta;
                }
            } else {
                this.hitCount += delta - idle;
                int i = 0;
                while (i < idle) {
                    HttpThread thread = (HttpThread)this.idleThreads.elementAt(i);
                    thread.close();
                    ++i;
                }
                this.idleThreads.removeAllElements();
            }
        } else if (delta > 0) {
            this.adjusting = delta;
            if (delta > this.hitCount) {
                delta -= this.hitCount;
                this.hitCount = 0;
                this.idleThreads.ensureCapacity(count);
                int i = 0;
                while (i < delta) {
                    ++this.number;
                    final String threadName = "HttpThread_" + this.number;
                    try {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                HttpThread thread = new HttpThread(HttpThreadPool.this.http, HttpThreadPool.this, threadName);
                                thread.start();
                                return null;
                            }
                        });
                    }
                    catch (RuntimeException e) {
                        this.http.logError(NLS.bind((String)HttpMsg.HTTP_THREAD_POOL_CREATE_NUMBER_ERROR, (Object)new Integer(this.number)), e);
                        --this.number;
                        this.upper -= delta - i;
                        break;
                    }
                    ++i;
                }
            } else {
                this.hitCount -= delta;
            }
        }
    }

    public void setPriority(int priority) {
        if (1 > priority || priority > 10) {
            throw new IllegalArgumentException(NLS.bind((String)HttpMsg.HTTP_INVALID_VALUE_RANGE_EXCEPTION, (Object[])new Object[]{new Integer(1), new Integer(10)}));
        }
        this.priority = priority;
    }

    public synchronized void putThread(HttpThread thread) {
        this.activeThreads.removeElement(thread);
        if (this.hitCount > 0) {
            --this.hitCount;
            thread.close();
        } else if (!this.idleThreads.contains(thread)) {
            this.idleThreads.addElement(thread);
            this.notify();
        }
        this.adjustThreadCount();
    }

    public synchronized HttpThread getThread() {
        this.adjustThreadCount();
        while (this.upper > 0) {
            int count = this.idleThreads.size();
            if (count > 0) {
                int i = count - 1;
                HttpThread thread = (HttpThread)this.idleThreads.elementAt(i);
                this.idleThreads.removeElementAt(i);
                if (thread.getPriority() != this.priority) {
                    thread.setPriority(this.priority);
                }
                this.activeThreads.addElement(thread);
                return thread;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    public synchronized void close() {
        this.recallThreads();
        this.setSize(0, 0);
        this.notifyAll();
        try {
            this.setDaemon(true);
            this.destroy();
        }
        catch (Exception exception) {}
    }

    public synchronized void recallThreads() {
        int count = this.activeThreads.size();
        int i = count - 1;
        while (i >= 0) {
            HttpThread thread = (HttpThread)this.activeThreads.elementAt(i);
            thread.recall();
            --i;
        }
    }
}

