/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.shell.Converter;
import org.eclipse.virgo.shell.internal.CommandDescriptor;
import org.eclipse.virgo.shell.internal.CommandInvoker;
import org.eclipse.virgo.shell.internal.CommandNotFoundException;
import org.eclipse.virgo.shell.internal.CommandRegistry;
import org.eclipse.virgo.shell.internal.ParametersMismatchException;
import org.eclipse.virgo.shell.internal.converters.ConverterRegistry;
import org.eclipse.virgo.shell.internal.parsing.ParsedCommand;
import org.springframework.util.ReflectionUtils;

final class CommandRegistryCommandInvoker
implements CommandInvoker {
    private final CommandRegistry commandRegistry;
    private final ConverterRegistry converterRegistry;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    CommandRegistryCommandInvoker(CommandRegistry commandRegistry, ConverterRegistry converterRegistry) {
        this.commandRegistry = commandRegistry;
        this.converterRegistry = converterRegistry;
    }

    @Override
    public List<String> invokeCommand(ParsedCommand command) throws CommandNotFoundException, ParametersMismatchException {
        try {
            List<String> list;
            block9: {
                CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                List<CommandDescriptor> commands = CommandRegistryCommandInvoker.commandsOfCommandName(this.commandRegistry, command.getCommand());
                if (commands.isEmpty()) {
                    throw new CommandNotFoundException();
                }
                String[] arguments = command.getArguments();
                String subcommandName = CommandRegistryCommandInvoker.extractSubcommand(arguments);
                String[] subcommandArguments = CommandRegistryCommandInvoker.extractSubcommandArguments(arguments);
                ParametersMismatchException lastException = null;
                for (CommandDescriptor commandDescriptor : commands) {
                    String commandString;
                    List<String> objResult;
                    block8: {
                        objResult = null;
                        String commandSubcommandName = commandDescriptor.getSubCommandName();
                        commandString = commandDescriptor.getCommandName();
                        if (commandSubcommandName == null || commandSubcommandName.equals("")) break block8;
                        if (!CommandRegistryCommandInvoker.isSubcommandMatch(commandSubcommandName, subcommandName)) continue;
                        commandString = String.valueOf(commandString) + " " + subcommandName;
                        list = objResult = this.attemptExecution(commandDescriptor, subcommandArguments);
                        break block9;
                    }
                    try {
                        list = objResult = this.attemptExecution(commandDescriptor, arguments);
                        break block9;
                    }
                    catch (ParametersMismatchException e) {
                        lastException = new ParametersMismatchException("Command " + commandString + ": " + e.getMessage());
                    }
                }
                if (lastException != null) {
                    throw lastException;
                }
                throw new ParametersMismatchException("Command '" + command.getCommand() + "' expects a subcommand; try help vsh:" + command.getCommand());
            }
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return list;
        }
        catch (Throwable throwable) {
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private static boolean isSubcommandMatch(String commandSubcommandName, String subcommandName) {
        try {
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            boolean bl = subcommandName == null ? false : commandSubcommandName != null && commandSubcommandName.equals(subcommandName);
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return bl;
        }
        catch (Throwable throwable) {
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private static String[] extractSubcommandArguments(String[] arguments) {
        try {
            String[] stringArray;
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            if (arguments.length > 0) {
                String[] result = new String[arguments.length - 1];
                System.arraycopy(arguments, 1, result, 0, result.length);
                stringArray = result;
            } else {
                stringArray = null;
            }
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return stringArray;
        }
        catch (Throwable throwable) {
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private static String extractSubcommand(String[] arguments) {
        try {
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            String string = arguments.length > 0 ? arguments[0] : null;
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return string;
        }
        catch (Throwable throwable) {
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private List<String> attemptExecution(CommandDescriptor commandDescriptor, String[] arguments) throws ParametersMismatchException {
        try {
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            Method method = commandDescriptor.getMethod();
            Object[] convertedArguments = this.convertArguments(method, arguments);
            ReflectionUtils.makeAccessible((Method)method);
            List list = (List)ReflectionUtils.invokeMethod((Method)method, (Object)commandDescriptor.getTarget(), (Object[])convertedArguments);
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return list;
        }
        catch (Throwable throwable) {
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private static List<CommandDescriptor> commandsOfCommandName(CommandRegistry commandRegistry, String commandName) {
        try {
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
            ArrayList<CommandDescriptor> commands = new ArrayList<CommandDescriptor>();
            for (CommandDescriptor commandDescriptor : commandRegistry.getCommandDescriptors()) {
                if (!commandDescriptor.getCommandName().equals(commandName)) continue;
                commands.add(commandDescriptor);
            }
            ArrayList<CommandDescriptor> arrayList = commands;
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
            return arrayList;
        }
        catch (Throwable throwable) {
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    private Object[] convertArguments(Method method, String[] arguments) throws ParametersMismatchException {
        try {
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != arguments.length) {
                throw new ParametersMismatchException("Incorrect number of parameters");
            }
            Object[] parameters = new Object[parameterTypes.length];
            int i = 0;
            while (i < parameterTypes.length) {
                Object convertedParameter = this.convertArgument(arguments[i], parameterTypes[i]);
                if (convertedParameter == null) {
                    throw new ParametersMismatchException("Cannot convert parameter " + i + ".");
                }
                parameters[i] = convertedParameter;
                ++i;
            }
            Object[] objectArray = parameters;
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return objectArray;
        }
        catch (Throwable throwable) {
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    private Object convertArgument(String argument, Class<?> type) {
        try {
            Object object;
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
            Converter converter = this.converterRegistry.getConverter(type);
            if (converter == null) {
                object = null;
            } else {
                try {
                    object = converter.convert(type, argument);
                }
                catch (Exception exception) {
                    object = null;
                }
            }
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
            return object;
        }
        catch (Throwable throwable) {
            CommandRegistryCommandInvoker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("CommandRegistryCommandInvoker.java", Class.forName("org.eclipse.virgo.shell.internal.CommandRegistryCommandInvoker"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "invokeCommand", "org.eclipse.virgo.shell.internal.CommandRegistryCommandInvoker", "org.eclipse.virgo.shell.internal.parsing.ParsedCommand:", "command:", "org.eclipse.virgo.shell.internal.CommandNotFoundException:org.eclipse.virgo.shell.internal.ParametersMismatchException:", "java.util.List"), 49);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "isSubcommandMatch", "org.eclipse.virgo.shell.internal.CommandRegistryCommandInvoker", "java.lang.String:java.lang.String:", "commandSubcommandName:subcommandName:", "", "boolean"), 91);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "extractSubcommandArguments", "org.eclipse.virgo.shell.internal.CommandRegistryCommandInvoker", "[Ljava.lang.String;:", "arguments:", "", "[Ljava.lang.String;"), 103);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "extractSubcommand", "org.eclipse.virgo.shell.internal.CommandRegistryCommandInvoker", "[Ljava.lang.String;:", "arguments:", "", "java.lang.String"), 112);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "attemptExecution", "org.eclipse.virgo.shell.internal.CommandRegistryCommandInvoker", "org.eclipse.virgo.shell.internal.CommandDescriptor:[Ljava.lang.String;:", "commandDescriptor:arguments:", "org.eclipse.virgo.shell.internal.ParametersMismatchException:", "java.util.List"), 120);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "commandsOfCommandName", "org.eclipse.virgo.shell.internal.CommandRegistryCommandInvoker", "org.eclipse.virgo.shell.internal.CommandRegistry:java.lang.String:", "commandRegistry:commandName:", "", "java.util.List"), 129);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "convertArguments", "org.eclipse.virgo.shell.internal.CommandRegistryCommandInvoker", "java.lang.reflect.Method:[Ljava.lang.String;:", "method:arguments:", "org.eclipse.virgo.shell.internal.ParametersMismatchException:", "[Ljava.lang.Object;"), 139);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "convertArgument", "org.eclipse.virgo.shell.internal.CommandRegistryCommandInvoker", "java.lang.String:java.lang.Class:", "argument:type:", "", "java.lang.Object"), 162);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.shell.internal.CommandRegistryCommandInvoker");
    }
}

