/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.osgicommand.helper;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ClassLoadingHelper {
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public static boolean isPackageExported(BundleContext bundleContext, String classPackage, Bundle testBundle) {
        try {
            boolean bl;
            block4: {
                ExportPackageDescription[] exportDescriptions;
                ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                ServiceReference reference = bundleContext.getServiceReference(PlatformAdmin.class);
                PlatformAdmin platformAdmin = (PlatformAdmin)bundleContext.getService(reference);
                BundleDescription bundleDescription = platformAdmin.getState(false).getBundle(testBundle.getBundleId());
                ExportPackageDescription[] exportPackageDescriptionArray = exportDescriptions = bundleDescription.getSelectedExports();
                int n = exportDescriptions.length;
                int n2 = 0;
                while (n2 < n) {
                    ExportPackageDescription exportDescription = exportPackageDescriptionArray[n2];
                    if (exportDescription.getName().equals(ClassLoadingHelper.convertToClassName(classPackage))) {
                        bl = true;
                        break block4;
                    }
                    ++n2;
                }
                bl = false;
            }
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return bl;
        }
        catch (Throwable throwable) {
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    public static Map<Bundle, Bundle> getBundlesLoadingClass(BundleContext bundleContext, String className) {
        Bundle[] bundles = bundleContext.getBundles();
        HashMap<Bundle, Bundle> foundBundles = new HashMap<Bundle, Bundle>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            Bundle originBundle = ClassLoadingHelper.getOriginBundleOfClass(className, bundleContext, bundle);
            if (originBundle != null) {
                foundBundles.put(bundle, originBundle);
            }
            ++n2;
        }
        return foundBundles;
    }

    public static Bundle getOriginBundleOfClass(String className, BundleContext bundleContext, Bundle loadingBundle) {
        Class<?> clasz = ClassLoadingHelper.tryToLoadClass(className, loadingBundle);
        Bundle originBundle = null;
        if (clasz != null && (originBundle = FrameworkUtil.getBundle(clasz)) == null) {
            originBundle = bundleContext.getBundle(0L);
        }
        return originBundle;
    }

    public static Class<?> tryToLoadClass(String className, Bundle bundle) {
        try {
            Class clazz;
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            if (bundle == null) {
                clazz = null;
            } else {
                try {
                    clazz = bundle.loadClass(ClassLoadingHelper.convertToClassName(className));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = null;
                }
            }
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return clazz;
        }
        catch (Throwable throwable) {
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    public static String convertToClassName(String resourcePath) {
        try {
            String string;
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
            if (resourcePath == null) {
                string = null;
            } else {
                if ((resourcePath = resourcePath.replace("/", ".")).startsWith(".")) {
                    resourcePath = resourcePath.substring(1);
                }
                if (resourcePath.endsWith(".class")) {
                    resourcePath = resourcePath.substring(0, resourcePath.length() - 6);
                }
                string = resourcePath;
            }
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
            return string;
        }
        catch (Throwable throwable) {
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    public static String convertToResourcePath(String className) {
        try {
            String string;
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
            if (className == null) {
                string = null;
            } else {
                String result = className;
                if (!className.contains("/") && !className.contains("*")) {
                    if (className.endsWith(".class")) {
                        result = className.substring(0, className.length() - 6);
                    }
                    string = String.valueOf(result.replace(".", "/")) + ".class";
                } else {
                    string = result;
                }
            }
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
            return string;
        }
        catch (Throwable throwable) {
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    public static Map<Bundle, Bundle> getBundlesLoadingClass(BundleContext bundleContext, String className, String bundle) throws IllegalArgumentException {
        HashMap<Bundle, Bundle> result = new HashMap<Bundle, Bundle>();
        long id = Long.MIN_VALUE;
        try {
            id = Long.parseLong(bundle);
        }
        catch (NumberFormatException numberFormatException) {}
        if (id >= 0L) {
            Bundle testBundle = bundleContext.getBundle(id);
            if (testBundle == null) {
                throw new IllegalArgumentException("Bundle with ID [" + id + "] not found");
            }
            Bundle originBundle = ClassLoadingHelper.getOriginBundleOfClass(className, bundleContext, testBundle);
            if (originBundle != null) {
                result.put(testBundle, originBundle);
            }
        } else {
            ServiceReference reference = bundleContext.getServiceReference(PackageAdmin.class);
            PackageAdmin packageAdmin = (PackageAdmin)bundleContext.getService(reference);
            Bundle[] bundles = packageAdmin.getBundles(bundle, null);
            if (bundles == null) {
                throw new IllegalArgumentException("Bundle with symbolic name [" + bundle + "] not found");
            }
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle testBundle = bundleArray[n2];
                Bundle originBundle = ClassLoadingHelper.getOriginBundleOfClass(className, bundleContext, testBundle);
                if (originBundle != null) {
                    result.put(testBundle, originBundle);
                }
                ++n2;
            }
        }
        return result;
    }

    public static Map<Bundle, List<String>> getBundlesContainingResource(BundleContext bundleContext, String resourcePattern) {
        Bundle[] bundles;
        HashMap<Bundle, List<String>> result = new HashMap<Bundle, List<String>>();
        Bundle[] bundleArray = bundles = bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            List<String> entries = ClassLoadingHelper.findEntries(bundle, resourcePattern);
            if (entries != null && entries.size() != 0) {
                result.put(bundle, entries);
            }
            ++n2;
        }
        return result;
    }

    private static List<String> findEntries(Bundle bundle, String resourcePattern) {
        try {
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            HashSet<String> urls = new HashSet<String>();
            int index = resourcePattern.lastIndexOf("/");
            if (index != -1) {
                String resourcePath = resourcePattern.substring(0, index);
                String resourceEntity = resourcePattern.substring(index + 1);
                ClassLoadingHelper.addURLs(urls, bundle.findEntries("/", resourceEntity, true), resourcePath);
            }
            ClassLoadingHelper.addURLs(urls, bundle.findEntries("/", resourcePattern, true), null);
            ArrayList<String> arrayList = new ArrayList<String>(urls);
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return arrayList;
        }
        catch (Throwable throwable) {
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private static void addURLs(HashSet<String> urls, Enumeration<URL> foundURLs, String path) {
        try {
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
            if (foundURLs != null) {
                while (foundURLs.hasMoreElements()) {
                    String url = foundURLs.nextElement().getFile();
                    if (path != null && !url.contains(path)) continue;
                    urls.add(url);
                }
            }
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            ClassLoadingHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ClassLoadingHelper.java", Class.forName("org.eclipse.virgo.shell.osgicommand.helper.ClassLoadingHelper"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isPackageExported", "org.eclipse.virgo.shell.osgicommand.helper.ClassLoadingHelper", "org.osgi.framework.BundleContext:java.lang.String:org.osgi.framework.Bundle:", "bundleContext:classPackage:testBundle:", "", "boolean"), 40);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "tryToLoadClass", "org.eclipse.virgo.shell.osgicommand.helper.ClassLoadingHelper", "java.lang.String:org.osgi.framework.Bundle:", "className:bundle:", "", "java.lang.Class"), 103);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "convertToClassName", "org.eclipse.virgo.shell.osgicommand.helper.ClassLoadingHelper", "java.lang.String:", "resourcePath:", "", "java.lang.String"), 121);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "convertToResourcePath", "org.eclipse.virgo.shell.osgicommand.helper.ClassLoadingHelper", "java.lang.String:", "className:", "", "java.lang.String"), 142);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "findEntries", "org.eclipse.virgo.shell.osgicommand.helper.ClassLoadingHelper", "org.osgi.framework.Bundle:java.lang.String:", "bundle:resourcePattern:", "", "java.util.List"), 230);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "addURLs", "org.eclipse.virgo.shell.osgicommand.helper.ClassLoadingHelper", "java.util.HashSet:java.util.Enumeration:java.lang.String:", "urls:foundURLs:path:", "", "void"), 258);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.shell.osgicommand.helper.ClassLoadingHelper");
    }
}

