/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.core.AttributeOverride;
import org.eclipse.dali.core.Column;
import org.eclipse.dali.core.DaliFactory;
import org.eclipse.dali.core.Embeddable;
import org.eclipse.dali.core.Embedded;
import org.eclipse.dali.core.PersistentAttributeFlavor;
import org.eclipse.dali.core.PersistentType;
import org.eclipse.dali.core.adapters.IEmbeddedModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaAttributeOverrideAdapter;
import org.eclipse.dali.core.adapters.java.JavaAttributeOverrideColumnModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaPersistentAttributeFlavorModelAdapter;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.db.wrappers.TableWrapper;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;

public class JavaEmbeddedModelAdapter
extends JavaPersistentAttributeFlavorModelAdapter
implements IEmbeddedModelAdapter {
    protected PersistentAttributeFlavor buildFlavor(boolean isDefault) {
        return DaliFactory.eINSTANCE.createEmbedded(this, isDefault);
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.updatePersAttributeOverrides(astRoot);
    }

    private void updatePersAttributeOverrides(CompilationUnit astRoot) {
        ArrayList<AttributeOverride> overridesToRemove = new ArrayList<AttributeOverride>();
        for (AttributeOverride override : this.getEmbedded().getAttributeOverrides()) {
            if (!this.existsInJava(override, astRoot)) {
                overridesToRemove.add(override);
                continue;
            }
            ((JavaAttributeOverrideAdapter)override.getModelAdapter()).updatePersModel(astRoot);
        }
        this.getEmbedded().getAttributeOverrides().removeAll(overridesToRemove);
        Iterator i = this.attributeOverrideNormalAnnotations(astRoot).iterator();
        while (i.hasNext()) {
            this.addOrUpdatePersAttributeOverrideFrom((NormalAnnotation)i.next(), astRoot);
        }
        Iterator attributes = this.getEmbedded().possibleAttributeOverrideNames();
        while (attributes.hasNext()) {
            String attributeName = (String)attributes.next();
            AttributeOverride existingOverride = this.attributeOverrideNamed(attributeName);
            if (existingOverride != null) continue;
            this.createAttributeOverride(attributeName);
        }
    }

    private AttributeOverride attributeOverrideNamed(String attributeName) {
        for (AttributeOverride override : this.getEmbedded().getAttributeOverrides()) {
            if (override.getName() == null || !override.getName().equals(attributeName)) continue;
            return override;
        }
        return null;
    }

    private boolean existsInJava(AttributeOverride override, CompilationUnit astRoot) {
        String overrideName = override.getName();
        if (overrideName == null) {
            return false;
        }
        Iterator attributeNames = this.getEmbedded().possibleAttributeOverrideNames();
        while (attributeNames.hasNext()) {
            String attributeName = (String)attributeNames.next();
            if (!overrideName.equals(attributeName)) continue;
            return true;
        }
        for (NormalAnnotation normalAnnotation : this.attributeOverrideNormalAnnotations(astRoot)) {
            if (!overrideName.equals(this.nameFromAttributeOverrideAnnotation(normalAnnotation))) continue;
            return true;
        }
        return false;
    }

    private Collection attributeOverrideNormalAnnotations(CompilationUnit astRoot) {
        ArrayList<Annotation> overrideAnnotations = new ArrayList<Annotation>();
        Annotation attributeOverridesAnnotation = this.getAttribute().getAnnotation("AttributeOverrides", astRoot);
        if (attributeOverridesAnnotation != null) {
            MemberValuePair valueValuePair;
            Expression valueExpression = null;
            if (attributeOverridesAnnotation.isSingleMemberAnnotation()) {
                valueExpression = ((SingleMemberAnnotation)attributeOverridesAnnotation).getValue();
            } else if (attributeOverridesAnnotation.isNormalAnnotation() && (valueValuePair = ASTTools.getMemberValuePair((NormalAnnotation)attributeOverridesAnnotation, "value")) != null) {
                valueExpression = valueValuePair.getValue();
            }
            if (valueExpression == null) {
                return overrideAnnotations;
            }
            if (valueExpression.getNodeType() == 77) {
                if (((NormalAnnotation)valueExpression).getTypeName().getFullyQualifiedName().equals("AttributeOverride")) {
                    overrideAnnotations.add((Annotation)valueExpression);
                }
            } else if (valueExpression.getNodeType() == 4) {
                List expressions = ((ArrayInitializer)valueExpression).expressions();
                int i = 0;
                while (i < expressions.size()) {
                    Expression expression = (Expression)expressions.get(i);
                    if (expression.getNodeType() == 77 && ((NormalAnnotation)expression).getTypeName().getFullyQualifiedName().equals("AttributeOverride")) {
                        overrideAnnotations.add((Annotation)expression);
                    }
                    ++i;
                }
            }
        } else {
            Annotation attributeOverrideAnnotation = this.getAttribute().getAnnotation("AttributeOverride", astRoot);
            if (attributeOverrideAnnotation != null && attributeOverrideAnnotation.getNodeType() == 77) {
                overrideAnnotations.add(attributeOverrideAnnotation);
            }
        }
        return overrideAnnotations;
    }

    private String nameFromAttributeOverrideAnnotation(NormalAnnotation attributeOverrideAnnotation) {
        MemberValuePair nameValuePair = ASTTools.getMemberValuePair(attributeOverrideAnnotation, "name");
        String attributeName = null;
        if (nameValuePair != null && nameValuePair.getValue().getNodeType() == 45) {
            attributeName = ((StringLiteral)nameValuePair.getValue()).getLiteralValue();
        }
        return attributeName;
    }

    private void addOrUpdatePersAttributeOverrideFrom(NormalAnnotation attributeOverrideAnnotation, CompilationUnit astRoot) {
        String attributeName = this.nameFromAttributeOverrideAnnotation(attributeOverrideAnnotation);
        for (AttributeOverride attributeOverride : this.getEmbedded().getAttributeOverrides()) {
            if (!attributeOverride.getName().equals(attributeName)) continue;
            ((JavaAttributeOverrideAdapter)attributeOverride.getModelAdapter()).updatePersModel(astRoot);
            return;
        }
        this.createAttributeOverride(attributeName);
    }

    public AttributeOverride createAttributeOverride(String attributeName) {
        JavaAttributeOverrideAdapter overrideAdapter = new JavaAttributeOverrideAdapter();
        AttributeOverride attributeOverride = DaliFactory.eINSTANCE.createAttributeOverride(overrideAdapter);
        attributeOverride.setDefaultName(attributeName);
        attributeOverride.setSpecifiedName(attributeName);
        JavaAttributeOverrideColumnModelAdapter modelAdapter = new JavaAttributeOverrideColumnModelAdapter();
        Column column = DaliFactory.eINSTANCE.createColumn(modelAdapter, this.buildColumnContext());
        attributeOverride.setColumn(column);
        this.getEmbedded().getAttributeOverrides().add((Object)attributeOverride);
        CompilationUnit ast = this.getAttribute().createASTRoot();
        overrideAdapter.engage(attributeOverride, this.getAttribute(), modelAdapter, column, ast);
        return attributeOverride;
    }

    private Column.ColumnContext buildColumnContext() {
        return new Column.ColumnContext(){

            public TableWrapper getExpectedTable() {
                return JavaEmbeddedModelAdapter.this.getEmbedded().getPersistentTypeFlavor().getResolvedDBTable();
            }
        };
    }

    public void defaultChanged() {
        this.updateJavaDefault();
    }

    private void updateJavaDefault() {
        boolean persDefault;
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        boolean javaDefault = this.javaPersistentAttributeType(astRoot) == null;
        if (javaDefault == (persDefault = this.getEmbedded().isDefault())) {
            return;
        }
        if (persDefault) {
            this.removeAnnotation("Embedded");
        } else {
            this.addMappingAnnotation("Embedded");
        }
    }

    public String flavorName() {
        return "Embedded";
    }

    private Embedded getEmbedded() {
        return (Embedded)this.getFlavor();
    }

    public Embeddable getEmbeddable() {
        PersistentType persistentType;
        String[][] resolvedType;
        String signature = this.getAttribute().getTypeSignature();
        String simpleName = Signature.getSignatureSimpleName((String)signature);
        String qualifier = Signature.getSignatureQualifier((String)signature);
        String qualifiedName = simpleName;
        if (!StringTools.stringIsEmpty((String)qualifier)) {
            qualifiedName = String.valueOf(qualifier) + "." + simpleName;
        }
        try {
            resolvedType = this.getType().resolveType(qualifiedName);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        if (resolvedType == null || resolvedType.length > 1) {
            return null;
        }
        String packageName = resolvedType[0][0];
        String fullyQualifiedTypeName = simpleName;
        if (!StringTools.stringIsEmpty((String)packageName)) {
            fullyQualifiedTypeName = String.valueOf(packageName) + "." + simpleName;
        }
        if ((persistentType = this.getEmbedded().getPersistenceFile().resolvePersistentType(fullyQualifiedTypeName)) != null && persistentType.getFlavorKey() == Embeddable.Key.INSTANCE) {
            return (Embeddable)persistentType.getFlavor();
        }
        return null;
    }
}

