/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.actions;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dali.core.PersistenceProject;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.ui.PersistenceUiPlugin;
import org.eclipse.dali.ui.actions.EntityGenerator;
import org.eclipse.dali.ui.actions.PackageGenerator;
import org.eclipse.dali.ui.actions.ProjectAction;
import org.eclipse.dali.ui.wizards.GenerateEntitiesWizard;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class GenerateEntitiesAction
extends ProjectAction {
    PersistenceProject persistenceProject;

    protected void execute(PersistenceProject project) {
        GenerateEntitiesWizard wizard = new GenerateEntitiesWizard(this.tables(project), this.getCurrentSelection());
        WizardDialog dialog = new WizardDialog(PersistenceUiPlugin.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        int returnCode = dialog.open();
        if (returnCode == 0) {
            Collection selectedTables = wizard.getSelectedTables();
            IPackageFragmentRoot sourceRoot = wizard.getSourcePackageFragmentRoot();
            IPackageFragment packageFragment = wizard.getPackageFragment();
            PackageGenerator.generateEntities(this.buildPackageConfig(project, sourceRoot, packageFragment), this.buildEntityConfig(project), selectedTables, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private Collection tables(PersistenceProject project) {
        return CollectionTools.collection((Iterator)project.getSchema().tables());
    }

    private PackageGenerator.Config buildPackageConfig(PersistenceProject pp, IPackageFragmentRoot sourcePackageFragmentRoot, IPackageFragment packageFragment) {
        this.persistenceProject = pp;
        PackageGenerator.Config config = new PackageGenerator.Config();
        config.setPersistenceProject(pp);
        config.setSourcePackageFragmentRoot(sourcePackageFragmentRoot);
        config.setPackageFragment(packageFragment);
        return config;
    }

    private EntityGenerator.Config buildEntityConfig(PersistenceProject pp) {
        EntityGenerator.Config config = new EntityGenerator.Config();
        config.setCaseSensitive(false);
        config.setAnnotateProperties(false);
        config.setFieldVisibility(0);
        config.setMethodVisibility(3);
        config.setGenerateGettersAndSetters(true);
        return config;
    }
}

