/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.actions;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dali.core.PersistenceProject;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.ui.actions.EntityGenerator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class PackageGenerator {
    private final Config config;
    private final EntityGenerator.Config entityConfig;
    private final Collection tables;
    private final IProgressMonitor monitor;

    public static void generateEntities(Config config, EntityGenerator.Config entityConfig, Collection tables, IProgressMonitor monitor) {
        if (config == null || entityConfig == null || tables == null) {
            throw new NullPointerException();
        }
        new PackageGenerator(config, entityConfig, tables, monitor).generateEntities();
    }

    private PackageGenerator(Config config, EntityGenerator.Config entityConfig, Collection tables, IProgressMonitor monitor) {
        this.config = config;
        this.entityConfig = entityConfig;
        this.tables = tables;
        this.monitor = monitor;
    }

    private IJavaProject javaProject() {
        return this.config.getPersistenceProject().getJavaProject();
    }

    private void generateEntities() {
        Iterator stream = this.tables.iterator();
        while (stream.hasNext()) {
            this.buildEntity((Table)stream.next());
        }
    }

    private void buildEntity(Table table) {
        EntityGenerator.generateEntity(this.entityConfig, this.config.getPackageFragment(), table, this.monitor);
    }

    public static class Config {
        private PersistenceProject persistenceProject;
        private IPackageFragmentRoot sourcePackageFragmentRoot;
        private IPackageFragment packageFragment;

        public PersistenceProject getPersistenceProject() {
            return this.persistenceProject;
        }

        public void setPersistenceProject(PersistenceProject persistenceProject) {
            this.persistenceProject = persistenceProject;
        }

        public IPackageFragmentRoot getSourcePackageFragmentRoot() {
            return this.sourcePackageFragmentRoot;
        }

        public void setSourcePackageFragmentRoot(IPackageFragmentRoot sourcePackageFragmentRoot) {
            this.sourcePackageFragmentRoot = sourcePackageFragmentRoot;
        }

        public IPackageFragment getPackageFragment() {
            return this.packageFragment;
        }

        public void setPackageFragment(IPackageFragment packageFragment) {
            this.packageFragment = packageFragment;
        }
    }
}

