/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.core.AttributeOverride;
import org.eclipse.dali.core.Entity;
import org.eclipse.dali.edit.AttributeOverrideItemProvider;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.EntityItemProvider;
import org.eclipse.dali.ui.views.ColumnComposite;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class AttributeOverridesComposite
extends Composite
implements IPersistenceComposite {
    private static final String COLUMN_HELP_CONTEXT_ID = ".entity_attributeOverridesColumn";
    private ListViewer listViewer;
    private Entity entity;
    private INotifyChangedListener entityListener;
    private AttributeOverride attributeOverride;
    private INotifyChangedListener attributeOverrideItemListener;
    private EntityItemProvider entityItemProvider;
    private AttributeOverrideItemProvider attributeOverrideItemProvider;
    protected ColumnComposite columnComposite;
    private EditingDomain editingDomain;
    private DaliItemProviderAdapterFactory adapterFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AttributeOverridesComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.entityItemProvider = (EntityItemProvider)adapterFactory.createEntityAdapter();
        this.attributeOverrideItemProvider = (AttributeOverrideItemProvider)adapterFactory.createAttributeOverrideAdapter();
        this.initializeLayout();
    }

    private void initializeLayout() {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group attributeOverridesGroup = new Group((Composite)this, 16);
        attributeOverridesGroup.setText("Attribute Overrides:");
        attributeOverridesGroup.setLayout((Layout)new GridLayout(2, true));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        attributeOverridesGroup.setLayoutData((Object)gridData);
        this.listViewer = this.buildAttributeOverridesListViewer((Composite)attributeOverridesGroup);
        gridData = new GridData();
        gridData.verticalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.listViewer.getList().setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.listViewer.getList(), "org.eclipse.dali.ui.entity_attributeOverrides");
        this.columnComposite = new ColumnComposite((Composite)attributeOverridesGroup, this.editingDomain, this.adapterFactory, COLUMN_HELP_CONTEXT_ID);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.columnComposite.setLayoutData(gridData);
    }

    private ListViewer buildAttributeOverridesListViewer(Composite parent) {
        ListViewer listViewer = new ListViewer(parent, 2052);
        listViewer.setLabelProvider((IBaseLabelProvider)this.buildAttributeOverridesLabelProvider());
        listViewer.setContentProvider(this.buildAttributeOverridesContentProvider());
        listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (((StructuredSelection)event.getSelection()).isEmpty()) {
                    AttributeOverridesComposite.this.columnComposite.populate(null);
                    if (AttributeOverridesComposite.this.attributeOverride != null) {
                        AttributeOverridesComposite.this.attributeOverride.eAdapters().remove((Object)AttributeOverridesComposite.this.attributeOverrideItemProvider);
                        AttributeOverridesComposite.this.attributeOverride = null;
                    }
                } else {
                    AttributeOverridesComposite.this.attributeOverride = (AttributeOverride)((StructuredSelection)event.getSelection()).getFirstElement();
                    AttributeOverridesComposite.this.columnComposite.populate((EObject)AttributeOverridesComposite.this.attributeOverride.getColumn());
                    AttributeOverridesComposite.this.attributeOverride.eAdapters().add((Object)AttributeOverridesComposite.this.attributeOverrideItemProvider);
                }
            }
        });
        return listViewer;
    }

    private ILabelProvider buildAttributeOverridesLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((AttributeOverride)element).getName();
            }
        };
    }

    private IContentProvider buildAttributeOverridesContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((Entity)inputElement).getAttributeOverrides().toArray();
            }
        };
    }

    private AttributeOverride getSelectedAttributeOverride() {
        return (AttributeOverride)((StructuredSelection)this.listViewer.getSelection()).getFirstElement();
    }

    public void populate(EObject entity) {
        if (this.entity != null) {
            this.entityItemProvider.removeListener(this.getEntityListener());
            this.entity.eAdapters().remove((Object)this.entityItemProvider);
            this.attributeOverrideItemProvider.removeListener(this.getAttributeOverrideItemListener());
        }
        this.entity = (Entity)entity;
        if (this.entity == null) {
            this.columnComposite.populate(null);
            return;
        }
        this.entityItemProvider.addListener(this.getEntityListener());
        this.attributeOverrideItemProvider.addListener(this.getAttributeOverrideItemListener());
        this.entity.eAdapters().add((Object)this.entityItemProvider);
        if (this.listViewer.getInput() != entity) {
            this.listViewer.setInput((Object)entity);
        }
        if (!this.entity.getAttributeOverrides().isEmpty()) {
            if (this.listViewer.getSelection().isEmpty()) {
                this.listViewer.setSelection((ISelection)new StructuredSelection(this.entity.getAttributeOverrides().get(0)));
            } else {
                this.columnComposite.populate((EObject)((AttributeOverride)((StructuredSelection)this.listViewer.getSelection()).getFirstElement()).getColumn());
            }
        }
    }

    private INotifyChangedListener getEntityListener() {
        if (this.entityListener == null) {
            this.entityListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.dali.core.Entity");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    switch (notification.getFeatureID((Class)clazz)) {
                        case 4: {
                            Display.getDefault().syncExec(new Runnable(this){
                                final /* synthetic */ 4 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    AttributeOverridesComposite.access$3(4.access$0(this.this$1)).refresh();
                                }
                            });
                            if (notification.getEventType() != 3) break;
                            Object newValue = notification.getNewValue();
                            Display.getDefault().syncExec(new Runnable(this, newValue){
                                final /* synthetic */ 4 this$1;
                                private final /* synthetic */ Object val$newValue;
                                {
                                    this.this$1 = var1_1;
                                    this.val$newValue = object;
                                }

                                public void run() {
                                    AttributeOverridesComposite.access$3(4.access$0(this.this$1)).setSelection((ISelection)new StructuredSelection(this.val$newValue));
                                }
                            });
                            break;
                        }
                    }
                }

                static /* synthetic */ AttributeOverridesComposite access$0(4 var0) {
                    return var0.AttributeOverridesComposite.this;
                }
            };
        }
        return this.entityListener;
    }

    private INotifyChangedListener getAttributeOverrideItemListener() {
        if (this.attributeOverrideItemListener == null) {
            this.attributeOverrideItemListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.dali.core.AttributeOverride");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    switch (notification.getFeatureID((Class)clazz)) {
                        case 2: {
                            AttributeOverride attributeOverride = (AttributeOverride)notification.getNotifier();
                            Display.getDefault().syncExec(new Runnable(this, attributeOverride){
                                final /* synthetic */ 7 this$1;
                                private final /* synthetic */ AttributeOverride val$attributeOverride;
                                {
                                    this.this$1 = var1_1;
                                    this.val$attributeOverride = attributeOverride;
                                }

                                public void run() {
                                    AttributeOverridesComposite.access$3(7.access$0(this.this$1)).refresh((Object)this.val$attributeOverride);
                                }
                            });
                            break;
                        }
                    }
                }

                static /* synthetic */ AttributeOverridesComposite access$0(7 var0) {
                    return var0.AttributeOverridesComposite.this;
                }
            };
        }
        return this.attributeOverrideItemListener;
    }

    static /* synthetic */ ListViewer access$3(AttributeOverridesComposite attributeOverridesComposite) {
        return attributeOverridesComposite.listViewer;
    }
}

