/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.MultiRelationshipMapping;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.RelationshipMappingItemProvider;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.JoinTableComposite;
import org.eclipse.dali.ui.views.OrderByComposite;
import org.eclipse.dali.ui.views.RelationshipMappingComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public class MultiRelationshipMappingComposite
extends RelationshipMappingComposite
implements IPersistenceComposite {
    protected Combo mappedByCombo;
    protected JoinTableComposite joinTableComposite;
    protected OrderByComposite orderByComposite;
    static /* synthetic */ Class class$0;

    protected MultiRelationshipMappingComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, editingDomain, adapterFactory);
        this.initializeLayout();
    }

    protected RelationshipMappingItemProvider createRelationshipMappingItemProvider(DaliItemProviderAdapterFactory adapterFactory) {
        return (RelationshipMappingItemProvider)adapterFactory.createOneToManyMappingAdapter();
    }

    private void initializeLayout() {
        this.setLayout((Layout)new FillLayout(512));
        TabFolder folder = new TabFolder((Composite)this, 128);
        Control generalControl = this.buildGeneralTab(folder);
        TabItem generalTab = new TabItem(folder, 0);
        generalTab.setText("General");
        generalTab.setControl(generalControl);
        Control joinTableControl = this.buildJoinTableTab(folder);
        TabItem joinTableTab = new TabItem(folder, 0);
        joinTableTab.setText("Join Table");
        joinTableTab.setControl(joinTableControl);
        folder.setSelection(0);
    }

    private Control buildGeneralTab(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label targetEntityLabel = new Label(composite, 16384);
        targetEntityLabel.setText("Target Entity:");
        this.targetEntityCombo = this.buildTargetEntityCombo(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.targetEntityCombo.setLayoutData((Object)gridData);
        this.buildTargetEntitySelectionButton(composite);
        Label cascadeTypeLabel = new Label(composite, 16384);
        cascadeTypeLabel.setText("Cascade Type:");
        this.cascadeTypeComboViewer = this.buildCascadeTypeCombo(composite);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cascadeTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        Label fetchTypeLabel = new Label(composite, 16384);
        fetchTypeLabel.setText("Fetch Type:");
        this.fetchTypeComboViewer = this.buildFetchTypeCombo(composite);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fetchTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        Label mappedByLabel = new Label(composite, 16384);
        mappedByLabel.setText("Mapped By:");
        this.mappedByCombo = this.buildMappedByCombo(composite);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.mappedByCombo.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mappedByCombo, "org.eclipse.dali.ui.mapping_mappedBy");
        this.orderByComposite = new OrderByComposite(composite, this.editingDomain, this.adapterFactory);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.orderByComposite.setLayoutData(gridData);
        return composite;
    }

    private Control buildJoinTableTab(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout());
        this.joinTableComposite = new JoinTableComposite(composite, this.editingDomain, this.adapterFactory);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.joinTableComposite.setLayoutData(gridData);
        return composite;
    }

    private Combo buildMappedByCombo(Composite parent) {
        Combo combo = new Combo(parent, 2052);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MultiRelationshipMappingComposite.this.populating) {
                    return;
                }
                String mappedBy = ((Combo)e.getSource()).getText();
                if (mappedBy.equals("")) {
                    mappedBy = null;
                    if (MultiRelationshipMappingComposite.this.getMultiRelationshipMapping().getMappedBy() == null || MultiRelationshipMappingComposite.this.getMultiRelationshipMapping().getMappedBy().equals("")) {
                        return;
                    }
                }
                if (MultiRelationshipMappingComposite.this.getMultiRelationshipMapping().getMappedBy() == null || !MultiRelationshipMappingComposite.this.getMultiRelationshipMapping().getMappedBy().equals(mappedBy)) {
                    MultiRelationshipMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)MultiRelationshipMappingComposite.this.editingDomain, (Object)MultiRelationshipMappingComposite.this.getMultiRelationshipMapping(), (Object)DaliPackage.eINSTANCE.getNonOwningMapping_MappedBy(), (Object)mappedBy));
                }
            }
        });
        return combo;
    }

    private MultiRelationshipMapping getMultiRelationshipMapping() {
        return (MultiRelationshipMapping)this.relationshipMapping;
    }

    public void populate(EObject model) {
        super.populate(model);
        this.populating = true;
        if (this.mappedByCombo.getItemCount() > 0) {
            this.mappedByCombo.removeAll();
        }
        if (model != null) {
            this.populateMappedByCombo();
            this.populateJoinTablePanel();
            this.orderByComposite.populate((EObject)this.getMultiRelationshipMapping().getOrderBy());
        } else {
            this.unpopulateJoinTablePanel();
        }
        this.populating = false;
    }

    private void populateMappedByCombo() {
        String mappedBy = this.getMultiRelationshipMapping().getMappedBy();
        Iterator i = this.getMultiRelationshipMapping().possibleMappedByAttributeNames();
        while (i.hasNext()) {
            this.mappedByCombo.add((String)i.next());
        }
        if (mappedBy != null && !this.mappedByCombo.getText().equals(mappedBy)) {
            this.mappedByCombo.setText(mappedBy);
        }
    }

    private void unpopulateJoinTablePanel() {
        this.joinTableComposite.populate(null);
    }

    private void populateJoinTablePanel() {
        this.joinTableComposite.populate((EObject)this.getMultiRelationshipMapping().getJoinTable());
    }

    protected void mappingTypeChanged(Notification notification) {
        super.mappingTypeChanged(notification);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.MultiRelationshipMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 6) {
            final String mappedBy = (String)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (MultiRelationshipMappingComposite.this.mappedByCombo.getText() == null || !MultiRelationshipMappingComposite.this.mappedByCombo.getText().equals(mappedBy)) {
                        if (mappedBy == null) {
                            MultiRelationshipMappingComposite.this.mappedByCombo.setText("");
                        } else {
                            MultiRelationshipMappingComposite.this.mappedByCombo.setText(mappedBy);
                        }
                    }
                }
            });
        }
    }

    public static class MultiRelationshipMappingCompositeBuilder
    implements IMappingCompositeBuilder {
        public IPersistenceComposite buildMappingComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
            return new MultiRelationshipMappingComposite(parent, editingDomain, adapterFactory);
        }
    }
}

